/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.logging.impl;

import java.lang.invoke.MethodHandles;
import java.util.Set;
import org.hibernate.search.backend.elasticsearch.util.spi.URLEncodedString;
import org.hibernate.search.engine.backend.types.Highlightable;
import org.hibernate.search.engine.backend.types.TermVector;
import org.hibernate.search.engine.backend.types.VectorSimilarity;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.CategorizedLogger;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;

@CategorizedLogger(category="org.hibernate.search.mapping.elasticsearch")
@MessageLogger(projectCode="HSEARCH")
public interface MappingLog {
    public static final String CATEGORY_NAME = "org.hibernate.search.mapping.elasticsearch";
    public static final MappingLog INSTANCE = (MappingLog)LoggerFactory.make(MappingLog.class, (String)"org.hibernate.search.mapping.elasticsearch", (MethodHandles.Lookup)MethodHandles.lookup());

    @Message(id=400520, value="Duplicate index field definition: '%1$s'. Index field names must be unique. Look for two property mappings with the same field name, or two indexed-embeddeds with prefixes that lead to conflicting index field names, or two custom bridges declaring index fields with the same name.")
    public SearchException indexSchemaNodeNameConflict(String var1, @Param EventContext var2);

    @Message(id=400530, value="Conflicting index names: Hibernate Search indexes '%1$s' and '%2$s' both target the Elasticsearch index name or alias '%3$s'")
    public SearchException conflictingIndexNames(String var1, String var2, String var3);

    @Message(id=400545, value="No built-in index field type for class: '%1$s'.")
    public SearchException cannotGuessFieldType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @Param EventContext var2);

    @Message(id=400554, value="Incomplete field definition. You must call toReference() to complete the field definition.")
    public SearchException incompleteFieldDefinition(@Param EventContext var1);

    @Message(id=400555, value="Multiple calls to toReference() for the same field definition. You must call toReference() exactly once.")
    public SearchException cannotCreateReferenceMultipleTimes(@Param EventContext var1);

    @Message(id=400567, value="Invalid index field type: missing decimal scale. Define the decimal scale explicitly.  %1$s")
    public SearchException nullDecimalScale(String var1, @Param EventContext var2);

    @Message(id=400570, value="Invalid index field type: decimal scale '%1$s' is positive. The decimal scale of BigInteger fields must be zero or negative.")
    public SearchException invalidDecimalScale(Integer var1, @Param EventContext var2);

    @Message(id=400596, value="Invalid Elasticsearch index layout: the write alias and read alias are set to the same value: '%1$s'. The write alias and read alias must be different.")
    public SearchException sameWriteAndReadAliases(URLEncodedString var1);

    @Message(id=400607, value="Duplicate index field template definition: '%1$s'. Multiple bridges may be trying to access the same index field template,  or two indexed-embeddeds may have prefixes that lead to conflicting field names, or you may have declared multiple conflicting mappings. In any case, there is something wrong with your mapping and you should fix it.")
    public SearchException indexSchemaFieldTemplateNameConflict(String var1, @Param EventContext var2);

    @Message(id=400631, value="Unable to find the given custom index settings file: '%1$s'.")
    public SearchException customIndexSettingsFileNotFound(String var1, @Param EventContext var2);

    @Message(id=400632, value="Error on loading the given custom index settings file '%1$s': %2$s")
    public SearchException customIndexSettingsErrorOnLoading(String var1, String var2, @Cause Exception var3, @Param EventContext var4);

    @Message(id=400633, value="There are some JSON syntax errors on the given custom index settings file '%1$s': %2$s")
    public SearchException customIndexSettingsJsonSyntaxErrors(String var1, String var2, @Cause Exception var3, @Param EventContext var4);

    @Message(id=400637, value="The index schema named predicate '%1$s' was added twice.")
    public SearchException indexSchemaNamedPredicateNameConflict(String var1, @Param EventContext var2);

    @Message(id=400651, value="Unable to find the given custom index mapping file: '%1$s'.")
    public SearchException customIndexMappingFileNotFound(String var1, @Param EventContext var2);

    @Message(id=400652, value="Error on loading the given custom index mapping file '%1$s': %2$s")
    public SearchException customIndexMappingErrorOnLoading(String var1, String var2, @Cause Exception var3, @Param EventContext var4);

    @Message(id=400653, value="There are some JSON syntax errors on the given custom index mapping file '%1$s': %2$s")
    public SearchException customIndexMappingJsonSyntaxErrors(String var1, String var2, @Cause Exception var3, @Param EventContext var4);

    @Message(id=400667, value="Cannot use 'NO' in combination with other highlightable values. Applied values are: '%1$s'")
    public SearchException unsupportedMixOfHighlightableValues(Set<Highlightable> var1);

    @Message(id=400668, value="The '%1$s' term vector storage strategy is not compatible with the fast vector highlighter. Either change the strategy to one of `WITH_POSITIONS_PAYLOADS`/`WITH_POSITIONS_OFFSETS_PAYLOADS` or remove the requirement for the fast vector highlighter support.")
    public SearchException termVectorDontAllowFastVectorHighlighter(TermVector var1);

    @Message(id=400669, value="Setting the `highlightable` attribute to an empty array is not supported. Set the value to `NO` if the field does not require the highlight projection.")
    public SearchException noHighlightableProvided();

    @Message(id=400678, value="No built-in vector index field type for class: '%1$s'.")
    public SearchException cannotGuessVectorFieldType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @Param EventContext var2);

    @Message(id=400679, value="Invalid index field type: missing vector dimension. Define the vector dimension explicitly. %1$s")
    public SearchException nullVectorDimension(String var1, @Param EventContext var2);

    @Message(id=400680, value="Fields of this type cannot be multivalued.")
    public SearchException multiValuedFieldNotAllowed(@Param EventContext var1);

    @Message(id=400688, value="The OpenSearch distribution does not allow using %1$s as a space type for a Lucene engine. Try using a different similarity type and refer to the OpenSearch documentation for more details.")
    public SearchException vectorSimilarityNotSupportedByOpenSearchBackend(VectorSimilarity var1);
}

