/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.aggregation.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AbstractElasticsearchNestableAggregation;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationRequestBuildingContextContext;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchSearchAggregation;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicate;
import org.hibernate.search.engine.search.aggregation.AggregationKey;

public abstract class AbstractElasticsearchBucketAggregation<K, V>
extends AbstractElasticsearchNestableAggregation<Map<K, V>> {
    protected static final JsonAccessor<JsonObject> REQUEST_AGGREGATIONS_ACCESSOR = JsonAccessor.root().property("aggregations").asObject();
    private static final JsonAccessor<JsonObject> REQUEST_REVERSE_NESTED_ACCESSOR = JsonAccessor.root().property("reverse_nested").asObject();
    protected static final JsonAccessor<JsonObject> REQUEST_REVERSE_NESTED_WRAPPER_ACCESSOR = JsonAccessor.root().property("reverse_nested_wrapper").asObject();
    private static final String ROOT_DOC_COUNT_NAME = "root_doc_count";
    private static final JsonAccessor<JsonObject> REQUEST_AGGREGATIONS_ROOT_DOC_COUNT_ACCESSOR = JsonAccessor.root().property("aggregations").property("root_doc_count").asObject();
    protected static final String INNER_EXTRACTOR = "innerExtractor";

    AbstractElasticsearchBucketAggregation(AbstractBuilder<K, V> builder) {
        super(builder);
    }

    @Override
    protected final JsonObject doRequest(AggregationRequestBuildingContextContext context) {
        JsonObject outerObject = new JsonObject();
        JsonObject innerObject = new JsonObject();
        this.doRequest(outerObject, innerObject, context);
        if (this.isNested()) {
            if (!innerObject.isEmpty()) {
                JsonObject aggregations = new JsonObject();
                JsonObject wrapper = new JsonObject();
                REQUEST_REVERSE_NESTED_WRAPPER_ACCESSOR.set(aggregations, wrapper);
                REQUEST_REVERSE_NESTED_ACCESSOR.set(wrapper, new JsonObject());
                REQUEST_AGGREGATIONS_ACCESSOR.set(wrapper, innerObject);
                REQUEST_AGGREGATIONS_ACCESSOR.set(outerObject, aggregations);
            } else {
                JsonObject rootDocCountSubAggregationOuterObject = new JsonObject();
                JsonObject rootDocCountSubAggregationInnerObject = new JsonObject();
                REQUEST_REVERSE_NESTED_ACCESSOR.set(rootDocCountSubAggregationOuterObject, rootDocCountSubAggregationInnerObject);
                REQUEST_AGGREGATIONS_ROOT_DOC_COUNT_ACCESSOR.set(outerObject, rootDocCountSubAggregationOuterObject);
            }
        } else if (!innerObject.isEmpty()) {
            REQUEST_AGGREGATIONS_ACCESSOR.set(outerObject, innerObject);
        }
        return outerObject;
    }

    protected abstract void doRequest(JsonObject var1, JsonObject var2, AggregationRequestBuildingContextContext var3);

    public static abstract class AbstractBuilder<K, V>
    extends AbstractElasticsearchNestableAggregation.AbstractBuilder<Map<K, V>> {
        public AbstractBuilder(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<?> field) {
            super(scope, field);
        }

        @Override
        public abstract ElasticsearchSearchAggregation<Map<K, V>> build();
    }

    protected abstract class AbstractBucketExtractor<A, B>
    extends AbstractElasticsearchNestableAggregation.AbstractExtractor<Map<A, B>> {
        protected AbstractBucketExtractor(AggregationKey<?> key, List<String> nestedPathHierarchy, ElasticsearchSearchPredicate filter) {
            super(key, nestedPathHierarchy, filter);
        }

        @Override
        protected final Map<A, B> doExtract(JsonObject aggregationResult, AggregationExtractContext context) {
            JsonElement buckets = aggregationResult.get("buckets");
            return this.doExtract(context, buckets);
        }

        protected abstract Map<A, B> doExtract(AggregationExtractContext var1, JsonElement var2);
    }
}

