/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.aggregation.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonObjectAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchClientLog;
import org.hibernate.search.backend.elasticsearch.logging.impl.QueryLog;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AbstractElasticsearchAggregation;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationRequestBuildingContextContext;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchSearchAggregation;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateNestingContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.predicate.SearchPredicate;

public abstract class AbstractElasticsearchNestableAggregation<A>
extends AbstractElasticsearchAggregation<A> {
    private static final JsonAccessor<String> REQUEST_NESTED_PATH_ACCESSOR = JsonAccessor.root().property("nested").property("path").asString();
    private static final JsonObjectAccessor REQUEST_FILTER_ACCESSOR = JsonAccessor.root().property("filter").asObject();
    private static final String NESTED_NAME = "nested";
    private static final JsonAccessor<JsonObject> REQUEST_AGGREGATIONS_NESTED_ACCESSOR = JsonAccessor.root().property("aggregations").property("nested").asObject();
    private static final JsonAccessor<JsonObject> RESPONSE_NESTED_ACCESSOR = JsonAccessor.root().property("nested").asObject();
    private static final String FILTERED_NAME = "filtered";
    private static final JsonAccessor<JsonObject> REQUEST_AGGREGATIONS_FILTERED_ACCESSOR = JsonAccessor.root().property("aggregations").property("filtered").asObject();
    private static final JsonAccessor<JsonObject> RESPONSE_FILTERED_ACCESSOR = JsonAccessor.root().property("filtered").asObject();
    protected final List<String> nestedPathHierarchy;
    protected final ElasticsearchSearchPredicate filter;

    AbstractElasticsearchNestableAggregation(AbstractBuilder<A> builder) {
        super(builder);
        this.nestedPathHierarchy = builder.nestedPathHierarchy;
        this.filter = builder.filter;
    }

    @Override
    public final ElasticsearchSearchAggregation.Extractor<A> request(AggregationRequestContext context, AggregationKey<?> key, JsonObject jsonAggregations) {
        AggregationRequestBuildingContextContext buildingContext = new AggregationRequestBuildingContextContext(context);
        jsonAggregations.add(key.name(), (JsonElement)this.request(buildingContext));
        return this.extractor(key, buildingContext);
    }

    private JsonObject request(AggregationRequestBuildingContextContext context) {
        int hierarchyLastIndex;
        JsonObject result = this.doRequest(context);
        if (this.nestedPathHierarchy.isEmpty()) {
            return result;
        }
        if (this.filter != null) {
            PredicateRequestContext filterContext = context.getRootPredicateContext().withNestedPath(this.nestedPathHierarchy.get(this.nestedPathHierarchy.size() - 1));
            JsonObject jsonFilter = this.filter.toJsonQuery(filterContext);
            JsonObject object = new JsonObject();
            REQUEST_FILTER_ACCESSOR.set(object, jsonFilter);
            REQUEST_AGGREGATIONS_FILTERED_ACCESSOR.set(object, result);
            result = object;
        }
        for (int i = hierarchyLastIndex = this.nestedPathHierarchy.size() - 1; i >= 0; --i) {
            String path = this.nestedPathHierarchy.get(i);
            JsonObject object = new JsonObject();
            REQUEST_NESTED_PATH_ACCESSOR.set(object, path);
            REQUEST_AGGREGATIONS_NESTED_ACCESSOR.set(object, result);
            result = object;
        }
        return result;
    }

    protected abstract JsonObject doRequest(AggregationRequestBuildingContextContext var1);

    protected abstract ElasticsearchSearchAggregation.Extractor<A> extractor(AggregationKey<?> var1, AggregationRequestBuildingContextContext var2);

    protected final boolean isNested() {
        return !this.nestedPathHierarchy.isEmpty();
    }

    public static abstract class AbstractBuilder<A>
    extends AbstractElasticsearchAggregation.AbstractBuilder<A> {
        protected final ElasticsearchSearchIndexValueFieldContext<?> field;
        protected final List<String> nestedPathHierarchy;
        private ElasticsearchSearchPredicate filter;

        public AbstractBuilder(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<?> field) {
            super(scope);
            this.field = field;
            this.nestedPathHierarchy = field.nestedPathHierarchy();
        }

        public void filter(SearchPredicate filter) {
            if (this.nestedPathHierarchy.isEmpty()) {
                throw QueryLog.INSTANCE.cannotFilterAggregationOnRootDocumentField(this.field.absolutePath(), this.field.eventContext());
            }
            ElasticsearchSearchPredicate elasticsearchFilter = ElasticsearchSearchPredicate.from(this.scope, filter);
            elasticsearchFilter.checkNestableWithin(PredicateNestingContext.nested(this.nestedPathHierarchy.get(this.nestedPathHierarchy.size() - 1)));
            this.filter = elasticsearchFilter;
        }

        @Override
        public abstract ElasticsearchSearchAggregation<A> build();
    }

    protected static abstract class AbstractExtractor<T>
    implements ElasticsearchSearchAggregation.Extractor<T> {
        private final AggregationKey<?> key;
        private final List<String> nestedPathHierarchy;
        private final ElasticsearchSearchPredicate filter;

        protected AbstractExtractor(AggregationKey<?> key, List<String> nestedPathHierarchy, ElasticsearchSearchPredicate filter) {
            this.key = key;
            this.nestedPathHierarchy = nestedPathHierarchy;
            this.filter = filter;
        }

        @Override
        public final T extract(JsonObject aggregationResult, AggregationExtractContext context) {
            int nestedPathHierarchySize = this.nestedPathHierarchy.size();
            JsonObject actualAggregationResult = aggregationResult.getAsJsonObject(this.key.name());
            for (int i = 0; i < nestedPathHierarchySize; ++i) {
                actualAggregationResult = RESPONSE_NESTED_ACCESSOR.get(actualAggregationResult).orElseThrow(ElasticsearchClientLog.INSTANCE::elasticsearchResponseMissingData);
            }
            if (this.filter != null) {
                actualAggregationResult = RESPONSE_FILTERED_ACCESSOR.get(actualAggregationResult).orElseThrow(ElasticsearchClientLog.INSTANCE::elasticsearchResponseMissingData);
            }
            return this.doExtract(actualAggregationResult, context);
        }

        protected abstract T doExtract(JsonObject var1, AggregationExtractContext var2);

        @Override
        public AggregationKey<?> key() {
            return this.key;
        }
    }
}

