/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.aggregation.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.util.common.annotation.Incubating;

@Incubating
public final class AggregationRequestBuildingContextContext
implements AggregationRequestContext {
    private final AggregationRequestContext aggregationRequestContext;
    private final Map<Key<?>, Object> buildingContext = new HashMap();

    public AggregationRequestBuildingContextContext(AggregationRequestContext aggregationRequestContext) {
        this.aggregationRequestContext = aggregationRequestContext;
    }

    public <T> T get(Key<T> key) {
        Object value = this.buildingContext.get(key);
        return key.cast(value);
    }

    public void add(Key<?> key, Object value) {
        this.buildingContext.put(key, value);
    }

    @Override
    public PredicateRequestContext getRootPredicateContext() {
        return this.aggregationRequestContext.getRootPredicateContext();
    }

    @Override
    public boolean isRootContext() {
        return false;
    }

    public static <V> Key<V> buildingContextKey(String name) {
        return new Key(name);
    }

    public static class Key<V> {
        private final String name;

        private Key(String name) {
            this.name = name;
        }

        private V cast(Object value) {
            return (V)value;
        }

        public boolean equals(Object o) {
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            return Objects.equals(this.name, key.name);
        }

        public int hashCode() {
            return Objects.hashCode(this.name);
        }
    }
}

