/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.aggregation.impl;

import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchClientLog;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AbstractElasticsearchAggregation;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchSearchAggregation;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.hibernate.search.engine.search.aggregation.spi.CompositeAggregationBuilder;
import org.hibernate.search.engine.search.spi.ResultsCompositor;

public class ElasticsearchCompositeAggregation<A>
extends AbstractElasticsearchAggregation<A> {
    private static final String REVERSE_NESTED_WRAPPER_NAME = "reverse_nested_wrapper";
    private static final JsonAccessor<JsonObject> REQUEST_REVERSE_NESTED_WRAPPER_ACCESSOR = JsonAccessor.root().property("reverse_nested_wrapper").asObject();
    private static final AggregationKey<?> REVERSE_NESTED_WRAPPER_KEY = AggregationKey.of((String)"reverse_nested_wrapper");
    private static final AggregationKey<?> REGULAR_KEY = AggregationKey.of((String)"regular_aggregation");
    private final ElasticsearchSearchAggregation<?>[] aggregations;
    private final ResultsCompositor<?, A> compositor;

    private ElasticsearchCompositeAggregation(Builder<A> builder) {
        super(builder);
        this.aggregations = builder.inners;
        this.compositor = builder.compositor;
    }

    @Override
    public ElasticsearchSearchAggregation.Extractor<A> request(AggregationRequestContext context, AggregationKey<?> key, JsonObject jsonAggregations) {
        ElasticsearchSearchAggregation.Extractor[] extractors = new ElasticsearchSearchAggregation.Extractor[this.aggregations.length];
        AggregationKey[] keys = new AggregationKey[this.aggregations.length];
        for (int i = 0; i < this.aggregations.length; ++i) {
            keys[i] = AggregationKey.of((String)(key.name() + "_composite_" + i));
            JsonObject innerObject = new JsonObject();
            extractors[i] = this.aggregations[i].request(context, keys[i], innerObject);
            if (innerObject.isEmpty()) continue;
            jsonAggregations.add(keys[i].name(), innerObject.get(keys[i].name()));
        }
        return new CompositeExtractor(key, this.compositor, extractors, keys);
    }

    static AggregationKey<?> compositeKeyFor(boolean isNested) {
        return isNested ? REVERSE_NESTED_WRAPPER_KEY : REGULAR_KEY;
    }

    public static class Builder<T>
    extends AbstractElasticsearchAggregation.AbstractBuilder<T>
    implements CompositeAggregationBuilder<T> {
        private ElasticsearchSearchAggregation<?>[] inners;
        private ResultsCompositor<?, T> compositor;

        public Builder(ElasticsearchSearchIndexScope<?> scope) {
            super(scope);
        }

        private Builder(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchAggregation<?>[] inners, ResultsCompositor<?, T> compositor) {
            super(scope);
            this.inners = inners;
            this.compositor = compositor;
        }

        @Override
        public ElasticsearchCompositeAggregation<T> build() {
            return new ElasticsearchCompositeAggregation(this);
        }

        public CompositeAggregationBuilder<T> innerAggregations(SearchAggregation<?>[] inners) {
            this.inners = new ElasticsearchSearchAggregation[inners.length];
            for (int i = 0; i < inners.length; ++i) {
                this.inners[i] = ElasticsearchSearchAggregation.from(this.scope, inners[i]);
            }
            return this;
        }

        public <V> CompositeAggregationBuilder<V> compositor(ResultsCompositor<?, V> compositor) {
            return new Builder<V>(this.scope, this.inners, compositor);
        }
    }

    private record CompositeExtractor<E, A>(AggregationKey<?> key, ResultsCompositor<E, A> compositor, ElasticsearchSearchAggregation.Extractor<?>[] extractors, AggregationKey<?>[] keys) implements ElasticsearchSearchAggregation.Extractor<A>
    {
        @Override
        public A extract(JsonObject aggregationResult, AggregationExtractContext context) {
            if (REVERSE_NESTED_WRAPPER_KEY.equals(this.key)) {
                aggregationResult = REQUEST_REVERSE_NESTED_WRAPPER_ACCESSOR.get(aggregationResult).orElseThrow(ElasticsearchClientLog.INSTANCE::elasticsearchResponseMissingData);
            }
            Object initial = this.compositor.createInitial();
            for (int i = 0; i < this.extractors.length; ++i) {
                initial = this.compositor.set(initial, i, this.extractors[i].extract(aggregationResult, context));
            }
            return (A)this.compositor.finish(initial);
        }
    }
}

