/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.aggregation.impl;

import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonAccessor;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchClientLog;
import org.hibernate.search.backend.elasticsearch.logging.impl.QueryLog;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AbstractElasticsearchAggregation;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchSearchAggregation;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexNodeContext;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.query.impl.ElasticsearchSearchQueryExtractContext;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.aggregation.spi.CountDocumentAggregationBuilder;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementFactory;

public class ElasticsearchCountDocumentAggregation
extends AbstractElasticsearchAggregation<Long> {
    private static final JsonAccessor<Long> TOTAL_HITS_VALUE_PROPERTY_ACCESSOR = JsonAccessor.root().property("hits").property("total").property("value").asLong();
    private static final JsonAccessor<Long> RESPONSE_DOC_COUNT_ACCESSOR = JsonAccessor.root().property("doc_count").asLong();
    private static final JsonAccessor<Long> RESPONSE_ROOT_DOC_COUNT_ACCESSOR = JsonAccessor.root().property("root_doc_count").property("doc_count").asLong();
    private final boolean isNested;

    private ElasticsearchCountDocumentAggregation(Builder builder) {
        super(builder);
        this.isNested = builder.isNested;
    }

    public static SearchQueryElementFactory<CountDocumentAggregationBuilder.TypeSelector, ElasticsearchSearchIndexScope<?>, ElasticsearchSearchIndexNodeContext> factory() {
        return new Factory();
    }

    @Override
    public ElasticsearchSearchAggregation.Extractor<Long> request(AggregationRequestContext context, AggregationKey<?> key, JsonObject jsonAggregations) {
        return new CountDocumentsExtractor(key, this.isNested, context.isRootContext());
    }

    private static class Builder
    extends AbstractElasticsearchAggregation.AbstractBuilder<Long>
    implements CountDocumentAggregationBuilder {
        private final boolean isNested;

        private Builder(ElasticsearchSearchIndexScope<?> scope, boolean isNested) {
            super(scope);
            this.isNested = isNested;
        }

        @Override
        public ElasticsearchCountDocumentAggregation build() {
            return new ElasticsearchCountDocumentAggregation(this);
        }
    }

    private static class Factory
    implements SearchQueryElementFactory<CountDocumentAggregationBuilder.TypeSelector, ElasticsearchSearchIndexScope<?>, ElasticsearchSearchIndexNodeContext> {
        private Factory() {
        }

        public CountDocumentAggregationBuilder.TypeSelector create(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexNodeContext node) {
            return new TypeSelector(scope, node);
        }

        public void checkCompatibleWith(SearchQueryElementFactory<?, ?, ?> other) {
            if (!this.getClass().equals(other.getClass())) {
                throw QueryLog.INSTANCE.differentImplementationClassForQueryElement(this.getClass(), other.getClass());
            }
        }
    }

    private record CountDocumentsExtractor(AggregationKey<?> key, boolean isNested, boolean rootContext) implements ElasticsearchSearchAggregation.Extractor<Long>
    {
        @Override
        public Long extract(JsonObject aggregationResult, AggregationExtractContext context) {
            if (this.rootContext) {
                if (context instanceof ElasticsearchSearchQueryExtractContext) {
                    ElasticsearchSearchQueryExtractContext c = (ElasticsearchSearchQueryExtractContext)context;
                    return TOTAL_HITS_VALUE_PROPERTY_ACCESSOR.get(c.getResponseBody()).orElseThrow(ElasticsearchClientLog.INSTANCE::elasticsearchResponseMissingData);
                }
            } else {
                if (this.isNested) {
                    return RESPONSE_ROOT_DOC_COUNT_ACCESSOR.get(aggregationResult).orElseThrow(ElasticsearchClientLog.INSTANCE::elasticsearchResponseMissingData);
                }
                return RESPONSE_DOC_COUNT_ACCESSOR.get(aggregationResult).orElseThrow(ElasticsearchClientLog.INSTANCE::elasticsearchResponseMissingData);
            }
            throw ElasticsearchClientLog.INSTANCE.elasticsearchResponseMissingData();
        }
    }

    private static final class TypeSelector
    implements CountDocumentAggregationBuilder.TypeSelector {
        private final ElasticsearchSearchIndexScope<?> scope;
        private final ElasticsearchSearchIndexNodeContext node;

        private TypeSelector(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexNodeContext node) {
            this.scope = scope;
            this.node = node;
        }

        public CountDocumentAggregationBuilder builder() {
            boolean isNested = this.node.isValueField() && !this.node.toValueField().nestedPathHierarchy().isEmpty();
            return new Builder(this.scope, isNested);
        }
    }
}

