/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.aggregation.impl;

import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchCompositeAggregation;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchUserProvidedJsonAggregation;
import org.hibernate.search.backend.elasticsearch.search.aggregation.impl.ElasticsearchWithParametersAggregation;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.engine.search.aggregation.spi.CompositeAggregationBuilder;
import org.hibernate.search.engine.search.aggregation.spi.SearchAggregationBuilder;
import org.hibernate.search.engine.search.aggregation.spi.SearchAggregationBuilderFactory;
import org.hibernate.search.engine.search.aggregation.spi.WithParametersAggregationBuilder;

public class ElasticsearchSearchAggregationBuilderFactory
implements SearchAggregationBuilderFactory {
    private final ElasticsearchSearchIndexScope<?> scope;

    public ElasticsearchSearchAggregationBuilderFactory(ElasticsearchSearchIndexScope<?> scope) {
        this.scope = scope;
    }

    public SearchAggregationBuilder<JsonObject> fromJson(JsonObject jsonObject) {
        return new ElasticsearchUserProvidedJsonAggregation.Builder(this.scope, jsonObject);
    }

    public SearchAggregationBuilder<JsonObject> fromJson(String jsonString) {
        return this.fromJson((JsonObject)this.scope.userFacingGson().fromJson(jsonString, JsonObject.class));
    }

    public <T> WithParametersAggregationBuilder<T> withParameters() {
        return new ElasticsearchWithParametersAggregation.Builder(this.scope);
    }

    public <T> CompositeAggregationBuilder<T> compositeAggregation() {
        return new ElasticsearchCompositeAggregation.Builder(this.scope);
    }
}

