/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.predicate.impl;

import com.google.gson.JsonObject;
import java.util.LinkedHashMap;
import java.util.Map;
import org.hibernate.search.backend.elasticsearch.logging.impl.QueryLog;
import org.hibernate.search.backend.elasticsearch.search.common.impl.AbstractElasticsearchCompositeNodeSearchQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexCompositeNodeContext;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.AbstractElasticsearchSingleFieldPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.ElasticsearchSearchPredicate;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateNestingContext;
import org.hibernate.search.backend.elasticsearch.search.predicate.impl.PredicateRequestContext;
import org.hibernate.search.engine.search.common.NonStaticMetamodelScope;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementFactory;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.definition.PredicateDefinition;
import org.hibernate.search.engine.search.predicate.definition.PredicateDefinitionContext;
import org.hibernate.search.engine.search.predicate.definition.TypedPredicateDefinition;
import org.hibernate.search.engine.search.predicate.definition.TypedPredicateDefinitionContext;
import org.hibernate.search.engine.search.predicate.dsl.ExtendedSearchPredicateFactory;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.engine.search.predicate.dsl.TypedSearchPredicateFactory;
import org.hibernate.search.engine.search.predicate.spi.NamedPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.NamedValuesBasedPredicateDefinitionContext;
import org.hibernate.search.engine.search.predicate.spi.NamedValuesBasedTypedPredicateDefinitionContext;

public class ElasticsearchNamedPredicate
extends AbstractElasticsearchSingleFieldPredicate {
    private final ElasticsearchSearchPredicate providedPredicate;

    private ElasticsearchNamedPredicate(Builder builder, ElasticsearchSearchPredicate providedPredicate) {
        super(builder);
        this.providedPredicate = providedPredicate;
    }

    @Override
    public void checkNestableWithin(PredicateNestingContext context) {
        this.providedPredicate.checkNestableWithin(context);
        super.checkNestableWithin(context);
    }

    @Override
    protected JsonObject doToJsonQuery(PredicateRequestContext context, JsonObject outerObject, JsonObject innerObject) {
        return this.providedPredicate.toJsonQuery(context);
    }

    private static class TypedBuilder<SR>
    extends Builder {
        private final TypedPredicateDefinition<SR> definition;
        private TypedSearchPredicateFactory<SR> factory;

        TypedBuilder(TypedPredicateDefinition<SR> definition, String predicateName, ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexCompositeNodeContext node) {
            super(predicateName, scope, node);
            this.definition = definition;
        }

        public void factory(ExtendedSearchPredicateFactory<?, ?> factory) {
            this.factory = factory.withScopeRoot(this.definition.scopeRootType());
        }

        @Override
        protected ElasticsearchSearchPredicate providedPredicate() {
            NamedValuesBasedTypedPredicateDefinitionContext ctx = new NamedValuesBasedTypedPredicateDefinitionContext(this.factory, this.params, name -> QueryLog.INSTANCE.paramNotDefined((String)name, this.predicateName, this.field.eventContext()));
            return ElasticsearchSearchPredicate.from(this.scope, this.definition.create((TypedPredicateDefinitionContext)ctx));
        }
    }

    private static class BasicBuilder
    extends Builder {
        private final PredicateDefinition definition;
        private SearchPredicateFactory factory;

        BasicBuilder(PredicateDefinition definition, String predicateName, ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexCompositeNodeContext node) {
            super(predicateName, scope, node);
            this.definition = definition;
        }

        public void factory(ExtendedSearchPredicateFactory<?, ?> factory) {
            this.factory = factory.withScopeRoot(NonStaticMetamodelScope.class);
        }

        @Override
        protected ElasticsearchSearchPredicate providedPredicate() {
            NamedValuesBasedPredicateDefinitionContext ctx = new NamedValuesBasedPredicateDefinitionContext(this.factory, this.params, name -> QueryLog.INSTANCE.paramNotDefined((String)name, this.predicateName, this.field.eventContext()));
            return ElasticsearchSearchPredicate.from(this.scope, this.definition.create((PredicateDefinitionContext)ctx));
        }
    }

    private static abstract class Builder
    extends AbstractElasticsearchSingleFieldPredicate.AbstractBuilder
    implements NamedPredicateBuilder {
        protected final String predicateName;
        protected final ElasticsearchSearchIndexCompositeNodeContext field;
        protected final Map<String, Object> params = new LinkedHashMap<String, Object>();

        Builder(String predicateName, ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexCompositeNodeContext node) {
            super(scope, node);
            this.predicateName = predicateName;
            this.field = node;
        }

        public final void param(String name, Object value) {
            this.params.put(name, value);
        }

        protected abstract ElasticsearchSearchPredicate providedPredicate();

        public final SearchPredicate build() {
            return new ElasticsearchNamedPredicate(this, this.providedPredicate());
        }
    }

    public static class TypedFactory<SR>
    extends AbstractElasticsearchCompositeNodeSearchQueryElementFactory<NamedPredicateBuilder> {
        private final TypedPredicateDefinition<SR> definition;
        private final String predicateName;

        public TypedFactory(TypedPredicateDefinition<SR> definition, String predicateName) {
            this.definition = definition;
            this.predicateName = predicateName;
        }

        @Override
        public void checkCompatibleWith(SearchQueryElementFactory<?, ?, ?> other) {
            super.checkCompatibleWith(other);
            TypedFactory castedOther = (TypedFactory)other;
            if (!this.definition.equals(castedOther.definition)) {
                throw QueryLog.INSTANCE.differentPredicateDefinitionForQueryElement(this.definition, castedOther.definition);
            }
        }

        public NamedPredicateBuilder create(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexCompositeNodeContext node) {
            return new TypedBuilder<SR>(this.definition, this.predicateName, scope, node);
        }
    }

    public static class Factory
    extends AbstractElasticsearchCompositeNodeSearchQueryElementFactory<NamedPredicateBuilder> {
        private final PredicateDefinition definition;
        private final String predicateName;

        public Factory(PredicateDefinition definition, String predicateName) {
            this.definition = definition;
            this.predicateName = predicateName;
        }

        @Override
        public void checkCompatibleWith(SearchQueryElementFactory<?, ?, ?> other) {
            super.checkCompatibleWith(other);
            Factory castedOther = (Factory)other;
            if (!this.definition.equals((Object)castedOther.definition)) {
                throw QueryLog.INSTANCE.differentPredicateDefinitionForQueryElement(this.definition, castedOther.definition);
            }
        }

        public NamedPredicateBuilder create(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexCompositeNodeContext node) {
            return new BasicBuilder(this.definition, this.predicateName, scope, node);
        }
    }
}

