/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.search.projection.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.util.function.Function;
import org.hibernate.search.backend.elasticsearch.logging.impl.QueryLog;
import org.hibernate.search.backend.elasticsearch.search.common.impl.AbstractElasticsearchCodecAwareSearchQueryElementFactory;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexScope;
import org.hibernate.search.backend.elasticsearch.search.common.impl.ElasticsearchSearchIndexValueFieldContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.AbstractElasticsearchProjection;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.AccumulatingSourceExtractor;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionExtractContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionRequestContext;
import org.hibernate.search.backend.elasticsearch.search.projection.impl.ProjectionTransformContext;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;
import org.hibernate.search.engine.backend.types.converter.runtime.FromDocumentValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;
import org.hibernate.search.engine.search.common.ValueModel;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.projection.ProjectionCollector;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.spi.FieldProjectionBuilder;

public class ElasticsearchFieldProjection<F, V, P, T>
extends AbstractElasticsearchProjection<P> {
    private final String absoluteFieldPath;
    private final String[] absoluteFieldPathComponents;
    private final String requiredContextAbsoluteFieldPath;
    private final Function<JsonElement, T> decodeFunction;
    private final boolean canDecodeArrays;
    private final ProjectionConverter<? super T, ? extends V> converter;
    private final ProjectionCollector.Provider<V, P> collectorProvider;

    private ElasticsearchFieldProjection(Builder<F, V, T> builder, ProjectionCollector.Provider<V, P> collectorProvider) {
        this(builder.scope, builder.field, builder.decodeFunction, builder.canDecodeArrays, builder.converter, collectorProvider);
    }

    ElasticsearchFieldProjection(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<?> field, Function<JsonElement, T> decodeFunction, boolean canDecodeArrays, ProjectionConverter<? super T, ? extends V> converter, ProjectionCollector.Provider<V, P> collectorProvider) {
        super(scope);
        this.absoluteFieldPath = field.absolutePath();
        this.absoluteFieldPathComponents = field.absolutePathComponents();
        this.requiredContextAbsoluteFieldPath = collectorProvider.isSingleValued() ? field.closestMultiValuedParentAbsolutePath() : null;
        this.decodeFunction = decodeFunction;
        this.canDecodeArrays = canDecodeArrays;
        this.converter = converter;
        this.collectorProvider = collectorProvider;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[absoluteFieldPath=" + this.absoluteFieldPath + ", collectorProvider=" + String.valueOf(this.collectorProvider) + "]";
    }

    public ValueFieldExtractor<?> request(JsonObject requestBody, ProjectionRequestContext context) {
        ProjectionRequestContext innerContext = context.forField(this.absoluteFieldPath, this.absoluteFieldPathComponents);
        if (!context.projectionCardinalityCorrectlyAddressed(this.requiredContextAbsoluteFieldPath)) {
            throw QueryLog.INSTANCE.invalidSingleValuedProjectionOnValueFieldInMultiValuedObjectField(this.absoluteFieldPath, this.requiredContextAbsoluteFieldPath);
        }
        JsonPrimitive fieldPathJson = new JsonPrimitive(this.absoluteFieldPath);
        AccumulatingSourceExtractor.REQUEST_SOURCE_ACCESSOR.addElementIfAbsent(requestBody, (JsonElement)fieldPathJson);
        return new ValueFieldExtractor(innerContext.relativeCurrentFieldPathComponents(), this.collectorProvider.get());
    }

    public static class Builder<F, V, T>
    implements FieldProjectionBuilder<V> {
        private final Function<JsonElement, T> decodeFunction;
        private final boolean canDecodeArrays;
        private final ElasticsearchSearchIndexScope<?> scope;
        private final ElasticsearchSearchIndexValueFieldContext<F> field;
        private final ProjectionConverter<T, ? extends V> converter;

        private Builder(Function<JsonElement, T> decodeFunction, boolean canDecodeArrays, ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<F> field, ProjectionConverter<T, ? extends V> converter) {
            this.decodeFunction = decodeFunction;
            this.canDecodeArrays = canDecodeArrays;
            this.scope = scope;
            this.field = field;
            this.converter = converter;
        }

        public <P> SearchProjection<P> build(ProjectionCollector.Provider<V, P> collectorProvider) {
            if (collectorProvider.isSingleValued() && this.field.multiValued()) {
                throw QueryLog.INSTANCE.invalidSingleValuedProjectionOnMultiValuedField(this.field.absolutePath(), this.field.eventContext());
            }
            return new ElasticsearchFieldProjection(this, collectorProvider);
        }
    }

    private class ValueFieldExtractor<A>
    extends AccumulatingSourceExtractor<T, V, A, P> {
        public ValueFieldExtractor(String[] fieldPathComponents, ProjectionCollector<T, V, A, P> collector) {
            super(fieldPathComponents, collector);
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[absoluteFieldPath=" + ElasticsearchFieldProjection.this.absoluteFieldPath + ", collector=" + String.valueOf(this.collector) + "]";
        }

        @Override
        protected T extract(ProjectionHitMapper<?> projectionHitMapper, JsonObject hit, JsonElement sourceElement, ProjectionExtractContext context) {
            return ElasticsearchFieldProjection.this.decodeFunction.apply(sourceElement);
        }

        @Override
        protected boolean canDecodeArrays() {
            return ElasticsearchFieldProjection.this.canDecodeArrays;
        }

        @Override
        public P transform(LoadingResult<?> loadingResult, A extractedData, ProjectionTransformContext context) {
            FromDocumentValueConvertContext convertContext = context.fromDocumentValueConvertContext();
            Object transformedData = this.collector.transformAll(extractedData, ElasticsearchFieldProjection.this.converter.delegate(), convertContext);
            return this.collector.finish(transformedData);
        }
    }

    public static class TypeSelector<F>
    implements FieldProjectionBuilder.TypeSelector {
        private final ElasticsearchFieldCodec<F> codec;
        private final ElasticsearchSearchIndexScope<?> scope;
        private final ElasticsearchSearchIndexValueFieldContext<F> field;

        private TypeSelector(ElasticsearchFieldCodec<F> codec, ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<F> field) {
            this.codec = codec;
            this.scope = scope;
            this.field = field;
        }

        public <V> Builder<F, V, ?> type(Class<V> expectedType, ValueModel valueModel) {
            if (ValueModel.RAW.equals((Object)valueModel)) {
                return new Builder(Function.identity(), this.codec.canDecodeArrays(), this.scope, this.field, this.field.type().rawProjectionConverter().withConvertedType(expectedType, this.field));
            }
            return new Builder(this.codec::decode, this.codec.canDecodeArrays(), this.scope, this.field, this.field.type().projectionConverter(valueModel).withConvertedType(expectedType, this.field));
        }
    }

    public static class Factory<F>
    extends AbstractElasticsearchCodecAwareSearchQueryElementFactory<FieldProjectionBuilder.TypeSelector, F> {
        public Factory(ElasticsearchFieldCodec<F> codec) {
            super(codec);
        }

        @Override
        public TypeSelector<?> create(ElasticsearchSearchIndexScope<?> scope, ElasticsearchSearchIndexValueFieldContext<F> field) {
            field.nestedPathHierarchy();
            return new TypeSelector<F>(this.codec, scope, field);
        }
    }
}

