/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.codec.impl;

import com.google.gson.JsonElement;
import java.util.Optional;
import org.hibernate.search.backend.elasticsearch.lowlevel.syntax.search.impl.ElasticsearchSearchSyntax;
import org.hibernate.search.util.common.AssertionFailure;

public interface ElasticsearchFieldCodec<F> {
    public JsonElement encode(F var1);

    default public JsonElement encodeForMissing(F value) {
        return this.encode(value);
    }

    default public JsonElement encodeForAggregation(ElasticsearchSearchSyntax searchSyntax, F value) {
        return this.encode(value);
    }

    public F decode(JsonElement var1);

    default public F decode(Double element) {
        throw new AssertionFailure(String.valueOf(this) + " codec is not expected to handle decoding metric aggregation values.");
    }

    default public F decodeAggregationKey(JsonElement key, JsonElement keyAsString) {
        return this.decode(key);
    }

    default public F decodeAggregationValue(Optional<Double> value, JsonElement valueAsString) {
        if (valueAsString != null) {
            return this.decode(valueAsString);
        }
        return value.map(this::decode).orElse(null);
    }

    public boolean isCompatibleWith(ElasticsearchFieldCodec<?> var1);

    default public boolean canDecodeArrays() {
        return false;
    }

    public JsonElement fromJsonStringToElement(String var1);

    public String fromJsonElementToString(JsonElement var1);
}

