/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.types.codec.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import org.hibernate.search.backend.elasticsearch.gson.impl.JsonElementTypes;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.AbstractElasticsearchFieldCodec;
import org.hibernate.search.backend.elasticsearch.types.codec.impl.ElasticsearchFieldCodec;

public final class ElasticsearchStringFieldCodec
extends AbstractElasticsearchFieldCodec<String> {
    public ElasticsearchStringFieldCodec(Gson gson) {
        super(gson);
    }

    @Override
    public JsonElement encode(String value) {
        if (value == null) {
            return JsonNull.INSTANCE;
        }
        return new JsonPrimitive(value);
    }

    @Override
    public String decode(JsonElement element) {
        if (element == null || element.isJsonNull()) {
            return null;
        }
        return JsonElementTypes.STRING.fromElement(element);
    }

    @Override
    public String decode(Double value) {
        return value.toString();
    }

    @Override
    public boolean isCompatibleWith(ElasticsearchFieldCodec<?> other) {
        return other instanceof ElasticsearchStringFieldCodec;
    }
}

