/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.elasticsearch.work.impl;

import com.google.gson.JsonObject;
import org.hibernate.search.backend.elasticsearch.logging.impl.ElasticsearchClientLog;
import org.hibernate.search.backend.elasticsearch.work.impl.BulkableWork;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchRequestSuccessAssessor;
import org.hibernate.search.backend.elasticsearch.work.impl.ElasticsearchWorkExecutionContext;
import org.hibernate.search.backend.elasticsearch.work.impl.SingleDocumentIndexingWork;
import org.hibernate.search.engine.backend.work.execution.DocumentRefreshStrategy;

public abstract class AbstractSingleDocumentIndexingWork
implements BulkableWork<Void>,
SingleDocumentIndexingWork {
    private final JsonObject bulkableActionMetadata;
    private final JsonObject bulkableActionBody;
    protected final ElasticsearchRequestSuccessAssessor resultAssessor;
    private final String entityTypeName;
    private final Object entityIdentifier;
    private final String documentIdentifier;
    private final DocumentRefreshStrategy refreshStrategy;

    protected AbstractSingleDocumentIndexingWork(AbstractBuilder<?> builder) {
        this.bulkableActionMetadata = builder.buildBulkableActionMetadata();
        this.bulkableActionBody = builder.buildBulkableActionBody();
        this.resultAssessor = builder.resultAssessor;
        this.entityTypeName = builder.entityTypeName;
        this.entityIdentifier = builder.entityIdentifier;
        this.documentIdentifier = builder.documentIdentifier;
        this.refreshStrategy = builder.refreshStrategy;
    }

    @Override
    public String getQueuingKey() {
        return this.documentIdentifier;
    }

    @Override
    public String getEntityTypeName() {
        return this.entityTypeName;
    }

    @Override
    public Object getEntityIdentifier() {
        return this.entityIdentifier;
    }

    @Override
    public DocumentRefreshStrategy getRefreshStrategy() {
        return this.refreshStrategy;
    }

    @Override
    public JsonObject getBulkableActionMetadata() {
        return this.bulkableActionMetadata;
    }

    @Override
    public JsonObject getBulkableActionBody() {
        return this.bulkableActionBody;
    }

    @Override
    public Void handleBulkResult(ElasticsearchWorkExecutionContext context, JsonObject bulkResponseItem) {
        try {
            this.resultAssessor.checkSuccess(bulkResponseItem);
        }
        catch (RuntimeException e) {
            throw ElasticsearchClientLog.INSTANCE.elasticsearchBulkedRequestFailed(this.getBulkableActionMetadata(), bulkResponseItem, e.getMessage(), e);
        }
        return null;
    }

    protected static abstract class AbstractBuilder<B> {
        private final ElasticsearchRequestSuccessAssessor resultAssessor;
        private final String entityTypeName;
        private final Object entityIdentifier;
        protected final String documentIdentifier;
        private DocumentRefreshStrategy refreshStrategy = DocumentRefreshStrategy.NONE;

        public AbstractBuilder(ElasticsearchRequestSuccessAssessor resultAssessor, String entityTypeName, Object entityIdentifier, String documentIdentifier) {
            this.resultAssessor = resultAssessor;
            this.entityTypeName = entityTypeName;
            this.entityIdentifier = entityIdentifier;
            this.documentIdentifier = documentIdentifier;
        }

        public B refresh(DocumentRefreshStrategy refreshStrategy) {
            this.refreshStrategy = refreshStrategy;
            return (B)this;
        }

        protected abstract JsonObject buildBulkableActionMetadata();

        protected abstract JsonObject buildBulkableActionBody();

        public abstract AbstractSingleDocumentIndexingWork build();
    }
}

