/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.kafka.impl;

import io.smallrye.reactive.messaging.kafka.KafkaAdmin;
import io.smallrye.reactive.messaging.kafka.impl.ReactiveKafkaAdminClient;
import java.util.HashMap;
import java.util.Map;
import org.apache.kafka.clients.admin.AdminClientConfig;

public class KafkaAdminHelper {
    private KafkaAdminHelper() {
    }

    public static KafkaAdmin createAdminClient(Map<String, Object> kafkaConfigurationMap, String channel, boolean incoming) {
        Object id;
        HashMap<String, String> copy = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : kafkaConfigurationMap.entrySet()) {
            if (AdminClientConfig.configNames().contains(entry.getKey())) {
                copy.put(entry.getKey(), entry.getValue().toString());
                continue;
            }
            if (!entry.getKey().startsWith("sasl.")) continue;
            copy.put(entry.getKey(), entry.getValue().toString());
        }
        if (!kafkaConfigurationMap.containsKey("reconnect.backoff.max.ms")) {
            copy.put("reconnect.backoff.max.ms", "10000");
        }
        String name = (id = kafkaConfigurationMap.get("client.id")) != null ? "kafka-admin-" + String.valueOf(id) + "-" + channel : "kafka-admin-" + (incoming ? "incoming-" : "outgoing-") + channel;
        copy.put("client.id", name);
        return new ReactiveKafkaAdminClient(copy);
    }
}

