/*
 * Decompiled with CFR 0.152.
 */
package io.narayana.lra.client.internal;

import io.narayana.lra.Current;
import io.narayana.lra.LRAConstants;
import io.narayana.lra.LRAData;
import io.narayana.lra.logging.LRALogger;
import io.smallrye.stork.Stork;
import io.smallrye.stork.api.Service;
import io.smallrye.stork.api.ServiceDefinition;
import io.smallrye.stork.api.ServiceInstance;
import io.smallrye.stork.api.config.ConfigWithType;
import io.smallrye.stork.servicediscovery.staticlist.StaticConfiguration;
import jakarta.enterprise.context.RequestScoped;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.container.Suspended;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.Link;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.io.Closeable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.lra.annotation.AfterLRA;
import org.eclipse.microprofile.lra.annotation.Compensate;
import org.eclipse.microprofile.lra.annotation.Complete;
import org.eclipse.microprofile.lra.annotation.Forget;
import org.eclipse.microprofile.lra.annotation.LRAStatus;
import org.eclipse.microprofile.lra.annotation.Status;
import org.eclipse.microprofile.lra.annotation.ws.rs.Leave;

@RequestScoped
public class NarayanaLRAClient
implements Closeable {
    public static final String LRA_COORDINATOR_URL_KEY = "lra.coordinator.url";
    public static final String COORDINATOR_URLS_KEY = "lra.coordinator.urls";
    public static final String COORDINATOR_LB_METHOD_KEY = "lra.coordinator.lb-method";
    public static final String LB_METHOD_ROUND_ROBIN = "round-robin";
    public static final String LB_METHOD_STICKY = "sticky";
    public static final String LB_METHOD_RANDOM = "random";
    public static final String LB_METHOD_LEAST_REQUESTS = "least-requests";
    public static final String LB_METHOD_LEAST_RESPONSE_TIME = "least-response-time";
    public static final String LB_METHOD_POWER_OF_TWO_CHOICES = "power-of-two-choices";
    public static final String[] NARAYANA_LRA_SUPPORTED_LB_METHODS = new String[]{"round-robin", "sticky", "random", "least-requests", "least-response-time", "power-of-two-choices"};
    private static final String START_PATH = "/start";
    private static final String LEAVE_PATH = "%s/remove";
    private static final String STATUS_PATH = "%s/status";
    private static final String CLOSE_PATH = "%s/close";
    private static final String CANCEL_PATH = "%s/cancel";
    private static final String LINK_TEXT = "Link";
    private static final long CLIENT_TIMEOUT = Long.getLong("lra.internal.client.timeout", 10L);
    private static final long START_TIMEOUT = Long.getLong("lra.internal.client.timeout.start", CLIENT_TIMEOUT);
    private static final long JOIN_TIMEOUT = Long.getLong("lra.internal.client.timeout.join", CLIENT_TIMEOUT);
    private static final long END_TIMEOUT = Long.getLong("lra.internal.client.end.timeout", CLIENT_TIMEOUT);
    private static final long LEAVE_TIMEOUT = Long.getLong("lra.internal.client.leave.timeout", CLIENT_TIMEOUT);
    private static final long QUERY_TIMEOUT = Long.getLong("lra.internal.client.query.timeout", CLIENT_TIMEOUT);
    private static final Config CONFIG = ConfigProvider.getConfig();
    private Service coordinatorService;
    private URI coordinatorUrl;
    private long coordinatorCount;
    private String lbMethod;
    private boolean lbMethodValid;
    private boolean supportsFailover;
    private boolean storkInitialised;

    public NarayanaLRAClient() {
        this(NarayanaLRAClient.getConfigProperty(LRA_COORDINATOR_URL_KEY, "http://localhost:8080/lra-coordinator"));
    }

    public NarayanaLRAClient(String protocol, String host, int port, String coordinatorPath) {
        this.clusterConfig(UriBuilder.fromPath((String)coordinatorPath).scheme(protocol).host(host).port(port).build(new Object[0]));
    }

    public NarayanaLRAClient(URI coordinatorUrl) {
        this.clusterConfig(coordinatorUrl);
    }

    public NarayanaLRAClient(String coordinatorUrl) {
        this.clusterConfig(this.toURI(coordinatorUrl));
    }

    private URI toURI(String coordinatorUrl) {
        try {
            return new URI(coordinatorUrl);
        }
        catch (URISyntaxException use) {
            String errMsg = LRALogger.i18nLogger.warn_invalid_uri(coordinatorUrl, use.getMessage() + " - NarayanaLRAClient constructor");
            throw new RuntimeException(errMsg, use);
        }
    }

    private static String getConfigProperty(String key, String defaultValue) {
        try {
            String value = (String)CONFIG.getValue(key, String.class);
            if (value != null && !value.isEmpty()) {
                return value;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return defaultValue;
    }

    private ConfigWithType loadBalancer(final String loadBalancer, final Map<String, String> loadBalancerParams) {
        return loadBalancer == null ? null : new ConfigWithType(){

            public String type() {
                return loadBalancer;
            }

            public Map<String, String> parameters() {
                return Objects.requireNonNullElse(loadBalancerParams, Collections.emptyMap());
            }
        };
    }

    private void clusterConfig(URI coordinatorUrl) {
        if (CONFIG.getOptionalValue(COORDINATOR_URLS_KEY, String.class).isEmpty()) {
            this.coordinatorUrl = coordinatorUrl;
            this.coordinatorCount = 1L;
        } else {
            String coordinators = NarayanaLRAClient.getConfigProperty(COORDINATOR_URLS_KEY, coordinatorUrl.toASCIIString());
            this.coordinatorUrl = this.toURI(coordinators.split(",")[0]);
            this.coordinatorCount = coordinators.chars().filter(ch -> ch == 44).count() + 1L;
            try {
                this.lbMethod = NarayanaLRAClient.getConfigProperty(COORDINATOR_LB_METHOD_KEY, LB_METHOD_ROUND_ROBIN);
                this.lbMethodValid = Arrays.asList(NARAYANA_LRA_SUPPORTED_LB_METHODS).contains(this.lbMethod);
                if (!this.lbMethodValid) {
                    LRALogger.i18nLogger.warn_unsupportedLoadBalancer(this.lbMethod, this.coordinatorUrl.toASCIIString());
                } else {
                    if (LRALogger.logger.isDebugEnabled()) {
                        LRALogger.logger.debugf("using stork with coordinator(s) %s and lb-method %d", (Object)coordinators, (Object)this.lbMethod);
                    }
                    ConfigWithType balancer = this.loadBalancer(this.lbMethod, null);
                    Stork.initialize();
                    Stork stork = Stork.getInstance().defineIfAbsent("lra-coordinator", ServiceDefinition.of((ConfigWithType)new StaticConfiguration().withAddressList(coordinators), (ConfigWithType)balancer));
                    this.coordinatorService = stork.getService("lra-coordinator");
                    this.supportsFailover = Objects.equals(LB_METHOD_ROUND_ROBIN, this.lbMethod);
                    this.storkInitialised = true;
                }
            }
            catch (IllegalArgumentException | NoClassDefFoundError error) {
                this.coordinatorUrl = coordinatorUrl;
                this.supportsFailover = false;
                LRALogger.i18nLogger.warn_noLoadBalancer(coordinators, error);
            }
        }
    }

    public boolean isLoadBalancing() {
        return this.coordinatorCount > 1L && this.lbMethodValid;
    }

    public void setCurrentLRA(URI lraId) {
        try {
            this.coordinatorUrl = LRAConstants.getLRACoordinatorUrl((URI)lraId);
        }
        catch (IllegalStateException e) {
            String logMsg = LRALogger.i18nLogger.error_invalidLraIdFormatToConvertToCoordinatorUrl(lraId.toASCIIString(), (Throwable)e);
            LRALogger.logger.error((Object)logMsg);
            this.throwGenericLRAException(lraId, Response.Status.BAD_REQUEST.getStatusCode(), logMsg, null);
        }
    }

    public List<LRAData> getAllLRAs() {
        try (Client client = null;){
            client = this.getClient();
            Response response = (Response)client.target(this.coordinatorUrl).request().header("Narayana-LRA-API-version", (Object)"1.2").async().get().get(QUERY_TIMEOUT, TimeUnit.SECONDS);
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                LRALogger.logger.debugf("Error getting all LRAs from the coordinator, response status: %d", response.getStatus());
                throw new WebApplicationException(response);
            }
            List list = (List)response.readEntity((GenericType)new GenericType<List<LRAData>>(){});
            return list;
        }
    }

    public URI startLRA(String clientID) throws WebApplicationException {
        return this.startLRA(clientID, 0L);
    }

    private URI startLRA(String clientID, Long timeout) throws WebApplicationException {
        return this.startLRA(clientID, timeout, ChronoUnit.SECONDS);
    }

    private URI startLRA(String clientID, Long timeout, ChronoUnit unit) throws WebApplicationException {
        return this.startLRA(this.getCurrent(), clientID, timeout, unit);
    }

    public URI startLRA(URI parentLRA, String clientID, Long timeout, ChronoUnit unit) throws WebApplicationException {
        return this.startLRA(parentLRA, clientID, timeout, unit, true);
    }

    public URI startLRA(URI parentLRA, String clientID, Long timeout, ChronoUnit unit, boolean verbose) throws WebApplicationException {
        if (this.coordinatorCount > 1L && !this.lbMethodValid) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)LRALogger.i18nLogger.error_unsupportedLoadBalancer(this.lbMethod)).build());
        }
        if (clientID == null) {
            clientID = "";
        }
        if (timeout == null) {
            timeout = 0L;
        } else if (timeout < 0L) {
            this.throwGenericLRAException(parentLRA, Response.Status.BAD_REQUEST.getStatusCode(), LRALogger.i18nLogger.warn_invalid_timeout(timeout.longValue()), null);
            return null;
        }
        if (unit == null) {
            unit = ChronoUnit.SECONDS;
        }
        try (Client client = this.getClient();){
            String encodedParentLRA = parentLRA == null ? "" : URLEncoder.encode(parentLRA.toString(), StandardCharsets.UTF_8);
            int i = 0;
            while ((long)i < this.coordinatorCount) {
                URI coordinatorInstance;
                if (this.coordinatorService != null) {
                    ServiceInstance instance = (ServiceInstance)this.coordinatorService.selectInstance().await().atMost(Duration.ofSeconds(START_TIMEOUT));
                    if (LRALogger.logger.isDebugEnabled()) {
                        LRALogger.logger.debugf("Selected coordinator %s:%d%n", (Object)instance.getHost(), (Object)instance.getPort());
                    }
                    coordinatorInstance = UriBuilder.fromPath((String)this.coordinatorUrl.getPath()).scheme(instance.isSecure() ? "https" : "http").host(instance.getHost()).port(instance.getPort()).build(new Object[0]);
                } else {
                    coordinatorInstance = this.coordinatorUrl;
                }
                try {
                    Response response = (Response)client.target(coordinatorInstance).path(START_PATH).queryParam("ClientID", new Object[]{clientID}).queryParam("TimeLimit", new Object[]{Duration.of(timeout, unit).toMillis()}).queryParam("ParentLRA", new Object[]{encodedParentLRA}).request().header("Narayana-LRA-API-version", (Object)"1.2").async().post(null).get(START_TIMEOUT, TimeUnit.SECONDS);
                    if (this.isUnexpectedResponseStatus(response, Response.Status.CREATED)) {
                        if (verbose) {
                            LRALogger.logger.error((Object)LRALogger.i18nLogger.error_lraCreationUnexpectedStatus(response.getStatus(), ""));
                        }
                        throw new WebApplicationException(response);
                    }
                    URI lra = URI.create(response.getHeaderString("Location"));
                    this.lraTrace(lra, "startLRA returned");
                    Current.push((URI)lra);
                    Current.addActiveLRACache((URI)lra);
                    URI uRI = lra;
                    return uRI;
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    if (this.supportsFailover && (long)i == this.coordinatorCount - 1L) {
                        String errMsg = LRALogger.i18nLogger.warn_startLRAFailed(e.getMessage());
                        LRALogger.logger.warn((Object)errMsg, (Throwable)e);
                        throw new WebApplicationException(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)errMsg).build());
                    }
                    ++i;
                }
            }
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)"no available coordinator").build());
        }
    }

    public void cancelLRA(URI lraId) throws WebApplicationException {
        this.endLRA(lraId, false, null, null);
    }

    public void closeLRA(URI lraId) throws WebApplicationException {
        this.endLRA(lraId, true, null, null);
    }

    public void cancelLRA(URI lraId, String compensator, String userData) throws WebApplicationException {
        this.endLRA(lraId, false, compensator, userData);
    }

    public void closeLRA(URI lraId, String compensator, String userData) throws WebApplicationException {
        this.endLRA(lraId, true, compensator, userData);
    }

    public URI joinLRA(URI lraId, Long timeLimit, URI compensateUri, URI completeUri, URI forgetUri, URI leaveUri, URI afterUri, URI statusUri, String compensatorData) throws WebApplicationException {
        return this.enlistCompensator(lraId, timeLimit, "", compensateUri, completeUri, forgetUri, leaveUri, afterUri, statusUri, null);
    }

    public URI joinLRA(URI lraId, Long timeLimit, URI compensateUri, URI completeUri, URI forgetUri, URI leaveUri, URI afterUri, URI statusUri, StringBuilder compensatorData) throws WebApplicationException {
        return this.enlistCompensator(lraId, timeLimit, "", compensateUri, completeUri, forgetUri, leaveUri, afterUri, statusUri, compensatorData);
    }

    public URI joinLRA(URI lraId, Long timeLimit, URI participantUri, StringBuilder compensatorData) throws WebApplicationException {
        this.validateURI(participantUri, false, "Invalid participant URL: %s");
        StringBuilder linkHeaderValue = NarayanaLRAClient.makeLink(new StringBuilder(), null, "participant", participantUri.toASCIIString());
        return this.enlistCompensator(lraId, timeLimit, linkHeaderValue.toString(), compensatorData);
    }

    public void leaveLRA(URI lraId, String body) throws WebApplicationException {
        try (Client client = null;){
            client = this.getClient();
            Response response = (Response)client.target(String.format(LEAVE_PATH, lraId)).request().header("Narayana-LRA-API-version", (Object)"1.2").async().put(body == null ? Entity.text((Object)"") : Entity.text((Object)body)).get(LEAVE_TIMEOUT, TimeUnit.SECONDS);
            if (Response.Status.OK.getStatusCode() != response.getStatus()) {
                String logMsg = LRALogger.i18nLogger.error_lraLeaveUnexpectedStatus(lraId, response.getStatus(), response.hasEntity() ? (String)response.readEntity(String.class) : "");
                LRALogger.logger.error((Object)logMsg);
                this.throwGenericLRAException(null, response.getStatus(), logMsg, null);
            }
        }
    }

    public static Map<String, String> getTerminationUris(Class<?> compensatorClass, String uriPrefix, Long timeout) {
        HashMap<String, String> paths = new HashMap<String, String>();
        boolean[] asyncTermination = new boolean[]{false};
        String timeoutValue = timeout != null ? Long.toString(timeout) : "0";
        Arrays.stream(compensatorClass.getMethods()).forEach(method -> {
            Path pathAnnotation = method.getAnnotation(Path.class);
            if (pathAnnotation != null) {
                if (NarayanaLRAClient.checkMethod(paths, method, "compensate", pathAnnotation, (Annotation)method.getAnnotation(Compensate.class), uriPrefix) != 0) {
                    paths.put("TimeLimit", timeoutValue);
                    if (NarayanaLRAClient.isAsyncCompletion(method)) {
                        asyncTermination[0] = true;
                    }
                }
                if (NarayanaLRAClient.checkMethod(paths, method, "complete", pathAnnotation, (Annotation)method.getAnnotation(Complete.class), uriPrefix) != 0) {
                    paths.put("TimeLimit", timeoutValue);
                    if (NarayanaLRAClient.isAsyncCompletion(method)) {
                        asyncTermination[0] = true;
                    }
                }
                NarayanaLRAClient.checkMethod(paths, method, "status", pathAnnotation, (Annotation)method.getAnnotation(Status.class), uriPrefix);
                NarayanaLRAClient.checkMethod(paths, method, "forget", pathAnnotation, (Annotation)method.getAnnotation(Forget.class), uriPrefix);
                NarayanaLRAClient.checkMethod(paths, method, "leave", pathAnnotation, (Annotation)method.getAnnotation(Leave.class), uriPrefix);
                NarayanaLRAClient.checkMethod(paths, method, "after", pathAnnotation, (Annotation)method.getAnnotation(AfterLRA.class), uriPrefix);
            }
        });
        if (asyncTermination[0] && !paths.containsKey("status") && !paths.containsKey("forget")) {
            String logMsg = LRALogger.i18nLogger.error_asyncTerminationBeanMissStatusAndForget(compensatorClass);
            LRALogger.logger.warn((Object)logMsg);
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)logMsg).build());
        }
        StringBuilder linkHeaderValue = new StringBuilder();
        if (!paths.isEmpty()) {
            paths.forEach((k, v) -> NarayanaLRAClient.makeLink(linkHeaderValue, null, k, v));
            paths.put(LINK_TEXT, linkHeaderValue.toString());
        }
        return paths;
    }

    public static boolean isAsyncCompletion(Method method) {
        if (method.isAnnotationPresent(Complete.class) || method.isAnnotationPresent(Compensate.class)) {
            Annotation[][] annotationArray = method.getParameterAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation[] ann;
                for (Annotation an : ann = annotationArray[i]) {
                    if (!Suspended.class.isAssignableFrom(an.annotationType())) continue;
                    LRALogger.logger.warn((Object)"JAX-RS @Suspended annotation is untested");
                    return true;
                }
            }
        }
        return false;
    }

    private static int checkMethod(Map<String, String> paths, Method method, String rel, Path pathAnnotation, Annotation annotationClass, String uriPrefix) {
        if (annotationClass == null) {
            return 0;
        }
        for (Annotation annotation : method.getDeclaredAnnotations()) {
            String name = annotation.annotationType().getName();
            if (!name.equals(GET.class.getName()) && !name.equals(PUT.class.getName()) && !name.equals(POST.class.getName()) && !name.equals(DELETE.class.getName())) continue;
            Object pathValue = pathAnnotation.value();
            pathValue = ((String)pathValue).startsWith("/") ? pathValue : "/" + (String)pathValue;
            String url = String.format("%s%s?%s=%s", uriPrefix, pathValue, "method", name);
            paths.put(rel, url);
            break;
        }
        return 1;
    }

    public LRAStatus getStatus(URI uri) throws WebApplicationException {
        URL lraId;
        Client client = null;
        try {
            lraId = UriBuilder.fromUri((URI)uri).replaceQuery(null).build(new Object[0]).toURL();
        }
        catch (MalformedURLException mue) {
            this.throwGenericLRAException(null, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Could not convert LRA to a URL : " + mue.getClass().getName() + ":" + mue.getMessage(), mue);
            return null;
        }
        try {
            client = this.getClient();
            Response response = (Response)client.target(String.format(STATUS_PATH, lraId)).request().header("Narayana-LRA-API-version", (Object)"1.2").async().get().get(QUERY_TIMEOUT, TimeUnit.SECONDS);
            if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                throw new NotFoundException(response);
            }
            if (response.getStatus() == Response.Status.NO_CONTENT.getStatusCode()) {
                LRAStatus mue = LRAStatus.Active;
                return mue;
            }
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                String logMsg = LRALogger.i18nLogger.error_invalidStatusCode(this.coordinatorUrl, response.getStatus(), lraId);
                LRALogger.logger.error((Object)logMsg);
                throw new WebApplicationException(response);
            }
            if (!response.hasEntity()) {
                String logMsg = LRALogger.i18nLogger.error_noContentOnGetStatus(this.coordinatorUrl, lraId);
                LRALogger.logger.error((Object)logMsg);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)logMsg).build());
            }
            try {
                LRAStatus logMsg = LRAStatus.valueOf((String)((String)response.readEntity(String.class)));
                return logMsg;
            }
            catch (IllegalArgumentException e) {
                try {
                    String logMsg = LRALogger.i18nLogger.error_invalidArgumentOnStatusFromCoordinator(this.coordinatorUrl, lraId, (Throwable)e);
                    LRALogger.logger.error((Object)logMsg);
                    throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)logMsg).build());
                }
                catch (InterruptedException | ExecutionException | TimeoutException e2) {
                    throw new WebApplicationException(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)"get LRA status client request timed out, try again later").build());
                }
            }
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    private static StringBuilder makeLink(StringBuilder b, String uriPrefix, String key, String value) {
        if (value == null) {
            return b;
        }
        String terminationUri = uriPrefix == null ? value : String.format("%s%s", uriPrefix, value);
        Link link = Link.fromUri((String)terminationUri).title(key + " URI").rel(key).type("text/plain").build(new Object[0]);
        if (b.length() != 0) {
            b.append(',');
        }
        return b.append(link);
    }

    private URI enlistCompensator(URI lraUri, Long timelimit, String uriPrefix, URI compensateUri, URI completeUri, URI forgetUri, URI leaveUri, URI afterUri, URI statusUri, StringBuilder compensatorData) {
        this.validateURI(completeUri, true, "Invalid complete URL: %s");
        this.validateURI(compensateUri, true, "Invalid compensate URL: %s");
        this.validateURI(leaveUri, true, "Invalid status URL: %s");
        this.validateURI(afterUri, true, "Invalid after URL: %s");
        this.validateURI(forgetUri, true, "Invalid forgetUri URL: %s");
        this.validateURI(statusUri, true, "Invalid status URL: %s");
        HashMap<String, URI> terminateURIs = new HashMap<String, URI>();
        terminateURIs.put("compensate", compensateUri);
        terminateURIs.put("complete", completeUri);
        terminateURIs.put("leave", leaveUri);
        terminateURIs.put("after", afterUri);
        terminateURIs.put("status", statusUri);
        terminateURIs.put("forget", forgetUri);
        StringBuilder linkHeaderValue = new StringBuilder();
        terminateURIs.forEach((k, v) -> NarayanaLRAClient.makeLink(linkHeaderValue, uriPrefix, k, v == null ? null : v.toASCIIString()));
        return this.enlistCompensator(lraUri, timelimit, linkHeaderValue.toString(), compensatorData);
    }

    public URI enlistCompensator(URI uri, Long timelimit, String linkHeader, StringBuilder compensatorData) {
        Client client = null;
        Response response = null;
        URL lraId = null;
        String data = compensatorData == null ? null : compensatorData.toString();
        try {
            lraId = uri.toURL();
        }
        catch (MalformedURLException mue) {
            this.throwGenericLRAException(null, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), "Could not convert LRA to a URL : " + mue.getClass().getName() + ":" + mue.getMessage(), mue);
        }
        if (timelimit == null || timelimit < 0L) {
            timelimit = 0L;
        }
        try {
            String responseEntity;
            client = this.getClient();
            MultivaluedHashMap headers = new MultivaluedHashMap();
            headers.add((Object)"Narayana-LRA-API-version", (Object)"1.2");
            if (data != null) {
                headers.add((Object)"Narayana-LRA-Participant-Data", (Object)data);
            }
            headers.add((Object)LINK_TEXT, (Object)linkHeader);
            response = (Response)client.target(this.coordinatorUrl).path(LRAConstants.getLRAUid((URI)uri)).queryParam("TimeLimit", new Object[]{timelimit}).request().headers((MultivaluedMap)headers).async().put(Entity.text((Object)(compensatorData == null ? linkHeader : data))).get(JOIN_TIMEOUT, TimeUnit.SECONDS);
            String string = responseEntity = response.hasEntity() ? (String)response.readEntity(String.class) : "";
            if (response.getStatus() == Response.Status.PRECONDITION_FAILED.getStatusCode()) {
                String logMsg = LRALogger.i18nLogger.error_tooLateToJoin(String.valueOf(lraId), responseEntity);
                LRALogger.logger.error((Object)logMsg);
                throw new WebApplicationException(logMsg, Response.status((Response.Status)Response.Status.PRECONDITION_FAILED).entity((Object)logMsg).build());
            }
            if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                String logMsg = LRALogger.i18nLogger.info_failedToEnlistingLRANotFound(lraId, this.coordinatorUrl, Response.Status.NOT_FOUND.getStatusCode(), Response.Status.NOT_FOUND.getReasonPhrase(), Response.Status.GONE.getStatusCode(), Response.Status.GONE.getReasonPhrase());
                LRALogger.logger.info((Object)logMsg);
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.GONE).entity((Object)logMsg).build());
            }
            if (response.getStatus() != Response.Status.OK.getStatusCode()) {
                throw new WebApplicationException(responseEntity, response);
            }
            String recoveryUrl = null;
            String prevParticipantData = response.getHeaderString("Narayana-LRA-Participant-Data");
            if (compensatorData != null && prevParticipantData != null) {
                compensatorData.setLength(0);
                compensatorData.append(prevParticipantData);
            }
            try {
                recoveryUrl = response.getHeaderString("Long-Running-Action-Recovery");
                URI uRI = new URI(recoveryUrl);
                return uRI;
            }
            catch (URISyntaxException e) {
                URI uRI;
                block18: {
                    try {
                        LRALogger.logger.infof((Throwable)e, "join %s returned an invalid recovery URI '%s': %s", (Object)lraId, (Object)recoveryUrl, (Object)responseEntity);
                        this.throwGenericLRAException(null, Response.Status.SERVICE_UNAVAILABLE.getStatusCode(), "join " + String.valueOf(lraId) + " returned an invalid recovery URI '" + recoveryUrl + "' : " + responseEntity, e);
                        uRI = null;
                        if (client == null) break block18;
                    }
                    catch (InterruptedException | ExecutionException | TimeoutException e2) {
                        throw new WebApplicationException(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)"join LRA client request timed out, try again later").build());
                    }
                    client.close();
                }
                return uRI;
            }
        }
        finally {
            if (client != null) {
                client.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void endLRA(URI lra, boolean confirm, String compensator, String userData) throws WebApplicationException {
        this.lraTracef(lra, "%s LRA", confirm ? "close" : "compensate");
        try (Client client = this.getClient();){
            Response response;
            try {
                URI uri = UriBuilder.fromUri((URI)lra).replaceQuery(null).build(new Object[0]);
                response = (Response)client.target(confirm ? String.format(CLOSE_PATH, uri) : String.format(CANCEL_PATH, uri)).request().header("Narayana-LRA-API-version", (Object)"1.2").header("Narayana-LRA-Participant-Link", (Object)compensator).header("Narayana-LRA-Participant-Data", (Object)userData).async().put(Entity.text((Object)"")).get(END_TIMEOUT, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new WebApplicationException(Response.status((Response.Status)Response.Status.SERVICE_UNAVAILABLE).entity((Object)"end LRA client request timed out, try again later").build());
            }
            if (this.isUnexpectedResponseStatus(response, Response.Status.OK, Response.Status.ACCEPTED, Response.Status.NOT_FOUND)) {
                throw new WebApplicationException(response);
            }
            if (response.getStatus() == Response.Status.NOT_FOUND.getStatusCode()) {
                throw new WebApplicationException(response);
            }
        }
        finally {
            Current.pop((URI)lra);
            Current.removeActiveLRACache((URI)lra);
        }
    }

    private void validateURI(URI uri, boolean nullAllowed, String message) {
        if (uri == null) {
            if (!nullAllowed) {
                this.throwGenericLRAException(null, Response.Status.NOT_ACCEPTABLE.getStatusCode(), String.format(message, "null value"), null);
            }
        } else {
            try {
                uri.toURL();
            }
            catch (MalformedURLException mue) {
                this.throwGenericLRAException(null, Response.Status.NOT_ACCEPTABLE.getStatusCode(), String.format(message, mue.getClass().getName() + ":" + mue.getMessage()) + " uri=" + String.valueOf(uri), mue);
            }
        }
    }

    private boolean isUnexpectedResponseStatus(Response response, Response.Status ... expected) {
        for (Response.Status anExpected : expected) {
            if (response.getStatus() != anExpected.getStatusCode()) continue;
            return false;
        }
        return true;
    }

    public String getCoordinatorUrl() {
        return this.coordinatorUrl.toString();
    }

    public String getRecoveryUrl() {
        return this.getCoordinatorUrl() + "/recovery";
    }

    public URI getCurrent() {
        return Current.peek();
    }

    public void clearCurrent(boolean all) {
        if (all) {
            Current.popAll();
        } else {
            Current.pop();
        }
    }

    private void lraTracef(String reasonFormat, Object ... parameters) {
        if (LRALogger.logger.isTraceEnabled()) {
            LRALogger.logger.tracef(reasonFormat, parameters);
        }
    }

    private void lraTrace(URI lra, String reason) {
        if (LRALogger.logger.isTraceEnabled()) {
            this.lraTracef(lra, reason, (Object[])null);
        }
    }

    private void lraTracef(URI lra, String reasonFormat, Object ... parameters) {
        if (LRALogger.logger.isTraceEnabled()) {
            this.lraTracef(reasonFormat + ", lra id: %s", parameters, lra);
        }
    }

    @Override
    public void close() {
        if (this.storkInitialised) {
            Stork.shutdown();
        }
    }

    private void throwGenericLRAException(URI lraId, int statusCode, String message, Throwable cause) throws WebApplicationException {
        String errorMsg = String.format("%s: %s", lraId, message);
        throw new WebApplicationException(errorMsg, cause, Response.status((int)statusCode).entity((Object)errorMsg).build());
    }

    private Client getClient() {
        return ClientBuilder.newClient();
    }
}

