/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.infinispan.service;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.function.Supplier;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.cache.impl.AbstractDelegatingAdvancedCache;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.configuration.ConfigurationManager;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.factories.ComponentRegistry;
import org.infinispan.factories.GlobalComponentRegistry;
import org.infinispan.factories.impl.BasicComponentRegistry;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.metadata.Metadata;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.EventType;
import org.infinispan.util.concurrent.BlockingManager;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.ProcessStateNotifier;
import org.jboss.as.controller.RequirementServiceTarget;
import org.jboss.as.server.ServerEnvironment;
import org.jboss.as.server.suspend.ServerResumeContext;
import org.jboss.as.server.suspend.ServerSuspendContext;
import org.jboss.as.server.suspend.SuspendableActivity;
import org.jboss.as.server.suspend.SuspendableActivityRegistry;
import org.jboss.as.server.suspend.SuspensionStateProvider;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.infinispan.service.InfinispanServiceDescriptor;
import org.wildfly.clustering.server.service.BinaryServiceConfiguration;
import org.wildfly.service.Installer;
import org.wildfly.service.descriptor.NullaryServiceDescriptor;
import org.wildfly.subsystem.service.ServiceDependency;
import org.wildfly.subsystem.service.ServiceInstaller;

public class CacheServiceInstaller
implements ServiceInstaller {
    private static final Logger LOGGER = Logger.getLogger(CacheServiceInstaller.class);
    private final BinaryServiceConfiguration configuration;

    public CacheServiceInstaller(BinaryServiceConfiguration configuration) {
        this.configuration = configuration;
    }

    public ServiceController<?> install(RequirementServiceTarget target) {
        final ServiceDependency container = this.configuration.getServiceDependency(InfinispanServiceDescriptor.CACHE_CONTAINER);
        final ServiceDependency cacheConfiguration = this.configuration.getServiceDependency(InfinispanServiceDescriptor.CACHE_CONFIGURATION);
        final ServiceDependency activityRegistry = ServiceDependency.on((NullaryServiceDescriptor)SuspendableActivityRegistry.SERVICE_DESCRIPTOR);
        final ServiceDependency processStateProvider = ServiceDependency.on((NullaryServiceDescriptor)ProcessStateNotifier.SERVICE_DESCRIPTOR);
        final ServiceDependency environment = ServiceDependency.on((NullaryServiceDescriptor)ServerEnvironment.SERVICE_DESCRIPTOR);
        final String cacheName = this.configuration.getChildName();
        Supplier factory = new Supplier<Cache<?, ?>>(){

            @Override
            public Cache<?, ?> get() {
                ControlledProcessState.State state;
                Configuration suspendedConfiguration;
                EmbeddedCacheManager manager = (EmbeddedCacheManager)container.get();
                Configuration originalConfiguration = (Configuration)cacheConfiguration.get();
                SuspendableActivityRegistry registry = (SuspendableActivityRegistry)activityRegistry.get();
                Configuration configuration = suspendedConfiguration = originalConfiguration.clustering().cacheMode().isDistributed() ? new ConfigurationBuilder().read(originalConfiguration).clustering().hash().capacityFactor(Float.MIN_VALUE).build() : originalConfiguration;
                if (suspendedConfiguration != originalConfiguration && registry.getState() != SuspensionStateProvider.State.RUNNING && ((state = ((ProcessStateNotifier)processStateProvider.get()).getCurrentState()) == ControlledProcessState.State.RUNNING || state == ControlledProcessState.State.STARTING && ((ServerEnvironment)environment.get()).isStartSuspended())) {
                    LOGGER.debugf("%s cache of %s container will start using a suspended configuration", (Object)cacheName, (Object)manager.getCacheManagerConfiguration().cacheManagerName());
                    CacheServiceInstaller.updateConfiguration(manager, cacheName, suspendedConfiguration);
                }
                Cache cache = manager.getCache(cacheName);
                return suspendedConfiguration != originalConfiguration ? new SuspendableCache(cache, originalConfiguration, suspendedConfiguration, registry) : cache;
            }
        };
        return ((ServiceInstaller)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)((ServiceInstaller.UnaryBuilder)ServiceInstaller.builder(ManagedCache::new, (Supplier)factory).blocking()).provides(this.configuration.resolveServiceName(InfinispanServiceDescriptor.CACHE))).requires(List.of(container, cacheConfiguration, activityRegistry, processStateProvider, environment))).onStart(Lifecycle::start)).onStop(Cache::stop)).build()).install((ServiceTarget)target);
    }

    static void updateConfiguration(Cache<?, ?> cache, Configuration configuration) {
        ((BasicComponentRegistry)ComponentRegistry.componentOf(cache, BasicComponentRegistry.class)).replaceComponent(Installer.Configuration.class.getName(), (Object)configuration, false);
        cache.stop();
        CacheServiceInstaller.updateConfiguration(cache.getCacheManager(), cache.getName(), configuration);
        cache.start();
    }

    static void updateConfiguration(EmbeddedCacheManager manager, String name, Configuration configuration) {
        ConfigurationManager configManager = (ConfigurationManager)GlobalComponentRegistry.componentOf((EmbeddedCacheManager)manager, ConfigurationManager.class);
        configManager.removeConfiguration(name);
        configManager.putConfiguration(name, configuration);
    }

    private static class ManagedCache<K, V>
    extends AbstractDelegatingAdvancedCache<K, V> {
        ManagedCache(Cache<K, V> cache) {
            this(cache.getAdvancedCache());
        }

        private ManagedCache(AdvancedCache<K, V> cache) {
            super(cache);
        }

        public AdvancedCache rewrap(AdvancedCache delegate) {
            return new ManagedCache<K, V>(delegate);
        }

        public void start() {
        }

        public void stop() {
        }
    }

    private static class SuspendableCache<K, V>
    extends AbstractDelegatingAdvancedCache<K, V> {
        private final SuspendableActivityRegistry activityRegistry;
        private final SuspendableActivity activity;
        private final Map<Object, CacheEventFilter<? super K, ? super V>> listeners;

        SuspendableCache(Cache<K, V> cache, Configuration originalConfiguration, Configuration suspendedConfiguration, SuspendableActivityRegistry activityRegistry) {
            this(cache, originalConfiguration, suspendedConfiguration, activityRegistry, Collections.synchronizedMap(new IdentityHashMap()));
        }

        private SuspendableCache(final Cache<K, V> cache, final Configuration originalConfiguration, final Configuration suspendedConfiguration, SuspendableActivityRegistry activityRegistry, final Map<Object, CacheEventFilter<? super K, ? super V>> listeners) {
            this(cache.getAdvancedCache(), activityRegistry, listeners, new SuspendableActivity(){
                private final BlockingManager blocking;
                {
                    this.blocking = (BlockingManager)GlobalComponentRegistry.componentOf((EmbeddedCacheManager)cache.getCacheManager(), BlockingManager.class);
                }

                public CompletionStage<Void> suspend(ServerSuspendContext context) {
                    if (context.isStopping() || this.inUse(suspendedConfiguration) || cache.getAdvancedCache().getDistributionManager().getCacheTopology().getActualMembers().size() < 2) {
                        return SuspendableActivity.COMPLETED;
                    }
                    return this.blocking.runBlocking(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            Map map = listeners;
                            synchronized (map) {
                                for (Object listener : listeners.keySet()) {
                                    cache.removeListener(listener);
                                }
                            }
                            LOGGER.debugf("Restarting %s cache of %s container using suspended configuration", (Object)cache.getName(), (Object)cache.getCacheManager().getCacheManagerConfiguration().cacheManagerName());
                            CacheServiceInstaller.updateConfiguration(cache, suspendedConfiguration);
                        }
                    }, (Object)"suspend");
                }

                public CompletionStage<Void> resume(ServerResumeContext context) {
                    if (this.inUse(originalConfiguration)) {
                        return SuspendableActivity.COMPLETED;
                    }
                    return this.blocking.runBlocking(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            LOGGER.debugf("Restarting %s cache of %s container using original configuration", (Object)cache.getName(), (Object)cache.getCacheManager().getCacheManagerConfiguration().cacheManagerName());
                            CacheServiceInstaller.updateConfiguration(cache, originalConfiguration);
                            Map map = listeners;
                            synchronized (map) {
                                for (Map.Entry entry : listeners.entrySet()) {
                                    cache.addListener(entry.getKey(), (CacheEventFilter)entry.getValue(), null);
                                }
                            }
                        }
                    }, (Object)"resume");
                }

                boolean inUse(Configuration configuration) {
                    return ((BasicComponentRegistry)ComponentRegistry.componentOf((Cache)cache, BasicComponentRegistry.class)).getComponent(Installer.Configuration.class) == configuration;
                }
            });
        }

        private SuspendableCache(AdvancedCache<K, V> cache, SuspendableActivityRegistry activityRegistry, Map<Object, CacheEventFilter<? super K, ? super V>> listeners, SuspendableActivity activity) {
            super(cache.getAdvancedCache());
            this.activityRegistry = activityRegistry;
            this.listeners = listeners;
            this.activity = activity;
        }

        public void addListener(Object listener) {
            this.addListenerAsync(listener).toCompletableFuture().join();
        }

        public <C> void addListener(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter) {
            this.addListenerAsync(listener, filter, converter).toCompletableFuture().join();
        }

        public CompletionStage<Void> addListenerAsync(Object listener) {
            return super.addListenerAsync(listener, new CacheEventFilter<K, V>(){

                public boolean accept(K key, V oldValue, Metadata oldMetadata, V newValue, Metadata newMetadata, EventType eventType) {
                    return true;
                }
            }, null);
        }

        public <C> CompletionStage<Void> addListenerAsync(Object listener, CacheEventFilter<? super K, ? super V> filter, CacheEventConverter<? super K, ? super V, C> converter) {
            return super.addListenerAsync(listener, filter, converter).thenAccept(ignore -> this.listeners.put(listener, filter));
        }

        public void removeListener(Object listener) {
            this.removeListenerAsync(listener).toCompletableFuture().join();
        }

        public CompletionStage<Void> removeListenerAsync(Object listener) {
            return super.removeListenerAsync(listener).thenAccept(ignore -> this.listeners.remove(listener));
        }

        public AdvancedCache rewrap(AdvancedCache delegate) {
            return new SuspendableCache<K, V>(delegate, this.activityRegistry, this.listeners, this.activity);
        }

        public void start() {
            this.activityRegistry.registerActivity(this.activity, SuspendableActivityRegistry.SuspendPriority.LAST);
            super.start();
        }

        public void stop() {
            super.stop();
            this.activityRegistry.unregisterActivity(this.activity);
        }
    }
}

