/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.collector.impl;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.search.CollectorManager;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorExecutionContext;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorFactory;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorKey;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.NumericTermsCollector;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.NumericTermsCollectorManager;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.TermResults;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.LongMultiValuesSource;

public class NumericTermsCollectorFactory
implements CollectorFactory<NumericTermsCollector, TermResults, NumericTermsCollectorManager> {
    private final CollectorKey<NumericTermsCollector, TermResults> key = CollectorKey.create();
    private final LongMultiValuesSource valuesSource;
    private final List<CollectorFactory<?, ?, ?>> collectorFactories;

    public static CollectorFactory<NumericTermsCollector, TermResults, NumericTermsCollectorManager> instance(LongMultiValuesSource valuesSource, List<CollectorFactory<?, ?, ?>> collectorFactories) {
        return new NumericTermsCollectorFactory(valuesSource, collectorFactories);
    }

    public NumericTermsCollectorFactory(LongMultiValuesSource valuesSource, List<CollectorFactory<?, ?, ?>> collectorFactories) {
        this.valuesSource = valuesSource;
        this.collectorFactories = collectorFactories;
    }

    @Override
    public NumericTermsCollectorManager createCollectorManager(CollectorExecutionContext context) throws IOException {
        CollectorKey[] keys = new CollectorKey[this.collectorFactories.size()];
        CollectorManager[] managers = new CollectorManager[this.collectorFactories.size()];
        int index = 0;
        for (CollectorFactory<?, ?, ?> factory : this.collectorFactories) {
            keys[index] = factory.getCollectorKey();
            Object collectorManager = factory.createCollectorManager(context);
            managers[index] = collectorManager;
            ++index;
        }
        return new NumericTermsCollectorManager(this.valuesSource, keys, managers);
    }

    @Override
    public CollectorKey<NumericTermsCollector, TermResults> getCollectorKey() {
        return this.key;
    }
}

