/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.aggregation.impl;

import java.io.IOException;
import java.util.Set;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationExtractContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.lucene.search.aggregation.impl.LuceneSearchAggregation;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.hibernate.search.engine.search.aggregation.spi.CompositeAggregationBuilder;
import org.hibernate.search.engine.search.spi.ResultsCompositor;

public class LuceneCompositeAggregation<A>
implements LuceneSearchAggregation<A> {
    private final LuceneSearchIndexScope<?> scope;
    private final LuceneSearchAggregation<?>[] aggregations;
    private final ResultsCompositor<?, A> compositor;

    private LuceneCompositeAggregation(Builder<A> builder) {
        this.scope = builder.scope;
        this.aggregations = builder.inners;
        this.compositor = builder.compositor;
    }

    @Override
    public LuceneSearchAggregation.Extractor<A> request(AggregationRequestContext context) {
        LuceneSearchAggregation.Extractor[] extractors = new LuceneSearchAggregation.Extractor[this.aggregations.length];
        for (int i = 0; i < this.aggregations.length; ++i) {
            extractors[i] = this.aggregations[i].request(context);
        }
        return new CompositeExtractor(this.compositor, extractors);
    }

    @Override
    public Set<String> indexNames() {
        return this.scope.hibernateSearchIndexNames();
    }

    public static class Builder<A>
    implements CompositeAggregationBuilder<A> {
        private final LuceneSearchIndexScope<?> scope;
        private LuceneSearchAggregation<?>[] inners;
        private ResultsCompositor<?, A> compositor;

        public Builder(LuceneSearchIndexScope<?> scope) {
            this.scope = scope;
        }

        private Builder(LuceneSearchIndexScope<?> scope, LuceneSearchAggregation<?>[] inners, ResultsCompositor<?, A> compositor) {
            this.scope = scope;
            this.inners = inners;
            this.compositor = compositor;
        }

        public SearchAggregation<A> build() {
            return new LuceneCompositeAggregation(this);
        }

        public CompositeAggregationBuilder<A> innerAggregations(SearchAggregation<?>[] inners) {
            this.inners = new LuceneSearchAggregation[inners.length];
            for (int i = 0; i < inners.length; ++i) {
                this.inners[i] = LuceneSearchAggregation.from(this.scope, inners[i]);
            }
            return this;
        }

        public <V> CompositeAggregationBuilder<V> compositor(ResultsCompositor<?, V> compositor) {
            return new Builder<V>(this.scope, this.inners, compositor);
        }
    }

    private record CompositeExtractor<E, A>(ResultsCompositor<E, A> compositor, LuceneSearchAggregation.Extractor<?>[] extractors) implements LuceneSearchAggregation.Extractor<A>
    {
        @Override
        public A extract(AggregationExtractContext context) throws IOException {
            Object initial = this.compositor.createInitial();
            for (int i = 0; i < this.extractors.length; ++i) {
                initial = this.compositor.set(initial, i, this.extractors[i].extract(context));
            }
            return (A)this.compositor.finish(initial);
        }
    }
}

