/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.aggregation.impl;

import java.util.function.Function;
import org.hibernate.search.backend.lucene.logging.impl.QueryLog;
import org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl.CountDistinctValuesCollectorFactory;
import org.hibernate.search.backend.lucene.lowlevel.aggregation.collector.impl.CountValuesCollectorFactory;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorFactory;
import org.hibernate.search.backend.lucene.lowlevel.collector.impl.CollectorKey;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.JoiningLongMultiValuesSource;
import org.hibernate.search.backend.lucene.search.aggregation.impl.AggregationRequestContext;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexNodeContext;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexScope;
import org.hibernate.search.backend.lucene.search.common.impl.LuceneSearchIndexValueFieldContext;
import org.hibernate.search.backend.lucene.types.aggregation.impl.AbstractLuceneMetricNumericLongAggregation;
import org.hibernate.search.backend.lucene.types.aggregation.impl.AbstractLuceneNestableAggregation;
import org.hibernate.search.engine.search.aggregation.spi.CountValuesAggregationBuilder;
import org.hibernate.search.engine.search.common.spi.SearchQueryElementFactory;

public class LuceneCountValuesAggregation
extends AbstractLuceneMetricNumericLongAggregation {
    private final Function<JoiningLongMultiValuesSource, CollectorFactory<?, Long, ?>> collectorFactorySupplier;

    LuceneCountValuesAggregation(Builder builder) {
        super(builder);
        this.collectorFactorySupplier = builder.collectorFactorySupplier;
    }

    public static Factory factory() {
        return Factory.INSTANCE;
    }

    @Override
    CollectorKey<?, Long> fillCollectors(JoiningLongMultiValuesSource source, AggregationRequestContext context) {
        CollectorFactory<?, Long, ?> collectorFactory = this.collectorFactorySupplier.apply(source);
        CollectorKey<?, Long> collectorKey = collectorFactory.getCollectorKey();
        context.requireCollector(collectorFactory);
        return collectorKey;
    }

    protected static class Builder
    extends AbstractLuceneNestableAggregation.AbstractBuilder<Long>
    implements CountValuesAggregationBuilder {
        private Function<JoiningLongMultiValuesSource, CollectorFactory<?, Long, ?>> collectorFactorySupplier = CountValuesCollectorFactory::new;

        public Builder(LuceneSearchIndexScope<?> scope, LuceneSearchIndexValueFieldContext<?> field) {
            super(scope, field);
        }

        public void distinct(boolean distinct) {
            this.collectorFactorySupplier = distinct ? CountDistinctValuesCollectorFactory::new : CountValuesCollectorFactory::new;
        }

        @Override
        public AbstractLuceneMetricNumericLongAggregation build() {
            return new LuceneCountValuesAggregation(this);
        }
    }

    protected static class Factory
    implements SearchQueryElementFactory<CountValuesAggregationBuilder.TypeSelector, LuceneSearchIndexScope<?>, LuceneSearchIndexNodeContext> {
        private static final Factory INSTANCE = new Factory();

        private Factory() {
        }

        public CountValuesAggregationBuilder.TypeSelector create(LuceneSearchIndexScope<?> scope, LuceneSearchIndexNodeContext node) {
            return new TypeSelector(scope, node);
        }

        public void checkCompatibleWith(SearchQueryElementFactory<?, ?, ?> other) {
            if (!this.getClass().equals(other.getClass())) {
                throw QueryLog.INSTANCE.differentImplementationClassForQueryElement(this.getClass(), other.getClass());
            }
        }
    }

    private record TypeSelector(LuceneSearchIndexScope<?> scope, LuceneSearchIndexNodeContext node) implements CountValuesAggregationBuilder.TypeSelector
    {
        public CountValuesAggregationBuilder builder() {
            return new Builder(this.scope, (LuceneSearchIndexValueFieldContext<?>)this.node.toValueField());
        }
    }
}

