/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import java.math.BigInteger;
import org.hibernate.search.backend.lucene.logging.impl.MappingLog;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.DocValues;
import org.hibernate.search.backend.lucene.types.codec.impl.Indexing;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneBigIntegerFieldCodec;
import org.hibernate.search.backend.lucene.types.codec.impl.Storage;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneNumericIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.dsl.impl.LuceneIndexFieldTypeBuildContext;
import org.hibernate.search.engine.backend.types.converter.spi.DefaultStringConverters;
import org.hibernate.search.engine.backend.types.dsl.ScaledNumberIndexFieldTypeOptionsStep;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexFieldTypeDefaultsProvider;

class LuceneBigIntegerIndexFieldTypeOptionsStep
extends AbstractLuceneNumericIndexFieldTypeOptionsStep<LuceneBigIntegerIndexFieldTypeOptionsStep, BigInteger>
implements ScaledNumberIndexFieldTypeOptionsStep<LuceneBigIntegerIndexFieldTypeOptionsStep, BigInteger> {
    private final IndexFieldTypeDefaultsProvider defaultsProvider;
    private Integer decimalScale = null;

    LuceneBigIntegerIndexFieldTypeOptionsStep(LuceneIndexFieldTypeBuildContext buildContext, IndexFieldTypeDefaultsProvider defaultsProvider) {
        super(buildContext, BigInteger.class, DefaultStringConverters.BIG_INTEGER);
        this.defaultsProvider = defaultsProvider;
    }

    public LuceneBigIntegerIndexFieldTypeOptionsStep decimalScale(int decimalScale) {
        this.decimalScale = decimalScale;
        return this;
    }

    @Override
    protected LuceneBigIntegerIndexFieldTypeOptionsStep thisAsS() {
        return this;
    }

    @Override
    protected AbstractLuceneNumericFieldCodec<BigInteger, ?> createCodec(Indexing indexing, DocValues docValues, Storage storage, BigInteger indexNullAsValue) {
        int resolvedDecimalScale = this.resolveDecimalScale();
        if (resolvedDecimalScale > 0) {
            throw MappingLog.INSTANCE.invalidDecimalScale(resolvedDecimalScale, this.buildContext.getEventContext());
        }
        return new LuceneBigIntegerFieldCodec(indexing, docValues, storage, indexNullAsValue, resolvedDecimalScale);
    }

    private int resolveDecimalScale() {
        if (this.decimalScale != null) {
            return this.decimalScale;
        }
        if (this.defaultsProvider.decimalScale() != null) {
            return this.defaultsProvider.decimalScale();
        }
        throw MappingLog.INSTANCE.nullDecimalScale(this.buildContext.hints().missingDecimalScale(), this.buildContext.getEventContext());
    }
}

