/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.impl;

import java.io.IOException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TopDocs;
import org.hibernate.search.backend.lucene.logging.impl.QueryLog;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.MetadataFields;
import org.hibernate.search.backend.lucene.lowlevel.query.impl.MappedTypeNameQuery;
import org.hibernate.search.backend.lucene.lowlevel.query.impl.Queries;
import org.hibernate.search.backend.lucene.work.impl.LuceneSearcher;
import org.hibernate.search.backend.lucene.work.impl.ReadWork;
import org.hibernate.search.backend.lucene.work.impl.ReadWorkExecutionContext;
import org.hibernate.search.util.common.AssertionFailure;

class ExplainWork
implements ReadWork<Explanation> {
    private final LuceneSearcher<?, ?> searcher;
    private final String explainedDocumentTypeName;
    private final String explainedDocumentId;
    private final Query explainedDocumentFilter;

    ExplainWork(LuceneSearcher<?, ?> searcher, String explainedDocumentTypeName, String explainedDocumentId, Query explainedDocumentFilter) {
        this.searcher = searcher;
        this.explainedDocumentTypeName = explainedDocumentTypeName;
        this.explainedDocumentId = explainedDocumentId;
        this.explainedDocumentFilter = explainedDocumentFilter;
    }

    @Override
    public Explanation execute(ReadWorkExecutionContext context) {
        try {
            IndexSearcher indexSearcher = context.createSearcher();
            int luceneDocId = this.getLuceneDocId(context, indexSearcher);
            return this.searcher.explain(indexSearcher, luceneDocId);
        }
        catch (IOException e) {
            throw QueryLog.INSTANCE.ioExceptionOnQueryExecution(this.searcher.getLuceneQueryForExceptions(), e.getMessage(), context.getEventContext(), e);
        }
    }

    private int getLuceneDocId(ReadWorkExecutionContext context, IndexSearcher indexSearcher) throws IOException {
        Query explainedDocumentQuery = this.createExplainedDocumentQuery(context);
        TopDocs topDocs = indexSearcher.search(explainedDocumentQuery, 2);
        if (topDocs.scoreDocs.length < 1) {
            throw QueryLog.INSTANCE.explainUnknownDocument(this.explainedDocumentTypeName, this.explainedDocumentId);
        }
        if (topDocs.scoreDocs.length > 1) {
            throw new AssertionFailure("Multiple documents match query " + String.valueOf(explainedDocumentQuery) + ".");
        }
        return topDocs.scoreDocs[0].doc;
    }

    private Query createExplainedDocumentQuery(ReadWorkExecutionContext context) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder().add(Queries.mainDocumentQuery(), BooleanClause.Occur.FILTER).add(Queries.term(MetadataFields.idFieldName(), this.explainedDocumentId), BooleanClause.Occur.FILTER).add((Query)new MappedTypeNameQuery(context.getIndexReaderMetadataResolver(), this.explainedDocumentTypeName), BooleanClause.Occur.FILTER);
        if (this.explainedDocumentFilter != null) {
            builder.add(this.explainedDocumentFilter, BooleanClause.Occur.FILTER);
        }
        return builder.build();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName()).append("[").append("searcher=").append(this.searcher).append(", explainedDocumentIndexName=").append(this.explainedDocumentTypeName).append(", explainedDocumentId=").append(this.explainedDocumentId).append(", explainedDocumentFilter=").append(this.explainedDocumentFilter).append("]");
        return sb.toString();
    }
}

