/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages.perf;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;

public class MicrosClock {
    private static long offset = -1L;
    private static long NANOS_PER_SECOND = TimeUnit.SECONDS.toNanos(1L);
    private static Class vm;
    private static Method getNanoTimeAdjustment;
    private static final boolean AVAILABLE;

    private static boolean checkAvailable() {
        try {
            long now = MicrosClock.now();
            return now >= 0L;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean isAvailable() {
        return AVAILABLE;
    }

    public static long now() {
        try {
            long nanoAdjustment;
            long epochSecond = offset;
            if (vm == null) {
                vm = Class.forName("jdk.internal.misc.VM");
            }
            if (getNanoTimeAdjustment == null) {
                getNanoTimeAdjustment = vm.getMethod("getNanoTimeAdjustment", Long.TYPE);
            }
            if ((nanoAdjustment = ((Long)getNanoTimeAdjustment.invoke((Object)getNanoTimeAdjustment, epochSecond)).longValue()) == -1L) {
                epochSecond = System.currentTimeMillis() / 1000L - 1024L;
                nanoAdjustment = (Long)getNanoTimeAdjustment.invoke((Object)getNanoTimeAdjustment, epochSecond);
                if (nanoAdjustment == -1L) {
                    throw new InternalError("Offset " + epochSecond + " is not in range");
                }
                offset = epochSecond;
            }
            long secs = Math.addExact(epochSecond, Math.floorDiv(nanoAdjustment, NANOS_PER_SECOND));
            long secsInUs = TimeUnit.SECONDS.toMicros(secs);
            long nsOffset = (int)Math.floorMod(nanoAdjustment, NANOS_PER_SECOND);
            long usOffset = TimeUnit.NANOSECONDS.toMicros(nsOffset);
            return secsInUs + usOffset;
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    static {
        AVAILABLE = MicrosClock.checkAvailable();
    }
}

