/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.cli.commands.messages.perf;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;

public class PaddingDecimalFormat
extends DecimalFormat {
    private int minimumLength;
    private final StringBuilder pad;

    public PaddingDecimalFormat(String pattern, int minLength) {
        super(pattern);
        this.minimumLength = minLength;
        this.pad = new StringBuilder();
    }

    public PaddingDecimalFormat(String pattern, DecimalFormatSymbols symbols, int minLength) {
        super(pattern, symbols);
        this.minimumLength = minLength;
        this.pad = new StringBuilder();
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        int initLength = toAppendTo.length();
        super.format(number, toAppendTo, pos);
        return this.pad(toAppendTo, initLength);
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        int initLength = toAppendTo.length();
        super.format(number, toAppendTo, pos);
        return this.pad(toAppendTo, initLength);
    }

    private StringBuffer pad(StringBuffer toAppendTo, int initLength) {
        int numLength = toAppendTo.length() - initLength;
        int padLength = this.minimumLength - numLength;
        if (padLength > 0) {
            int initialPadLength;
            for (int i = initialPadLength = this.pad.length(); i < padLength; ++i) {
                this.pad.append(' ');
            }
            this.pad.setLength(padLength);
            toAppendTo.insert(initLength, this.pad);
        }
        return toAppendTo;
    }
}

