/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.bridge.builtin.impl;

import java.time.Period;
import java.util.Locale;
import org.hibernate.search.engine.cfg.spi.ParseUtils;
import org.hibernate.search.mapper.pojo.bridge.builtin.impl.AbstractConvertingDefaultBridge;
import org.hibernate.search.mapper.pojo.logging.impl.FormattingLog;

public final class DefaultPeriodBridge
extends AbstractConvertingDefaultBridge<Period, String> {
    private static final int PADDING = 11;
    private static final String INDEXED_FORMAT = "%+011d%+011d%+011d";
    public static final DefaultPeriodBridge INSTANCE = new DefaultPeriodBridge();

    private DefaultPeriodBridge() {
    }

    @Override
    protected String toString(Period value) {
        return value.toString();
    }

    @Override
    protected Period fromString(String value) {
        return ParseUtils.parsePeriod((String)value);
    }

    @Override
    protected String toConvertedValue(Period value) {
        return String.format(Locale.ROOT, INDEXED_FORMAT, value.getYears(), value.getMonths(), value.getDays());
    }

    @Override
    protected Period fromConvertedValue(String value) {
        try {
            int years = Integer.parseInt(value.substring(0, 11));
            int months = Integer.parseInt(value.substring(11, 22));
            int days = Integer.parseInt(value.substring(22));
            return Period.of(years, months, days);
        }
        catch (NumberFormatException e) {
            throw FormattingLog.INSTANCE.parseException(value, Period.class, e.getMessage(), e);
        }
    }
}

