/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.schema.management.impl;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.stream.Stream;
import org.hibernate.search.engine.common.schema.management.SchemaExport;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.mapper.pojo.logging.impl.MappingLog;
import org.hibernate.search.mapper.pojo.schema.management.SearchSchemaCollector;

public class FileSearchSchemaCollector
implements SearchSchemaCollector {
    private static final Path DEFAULT_BACKEND_PATH = Paths.get("backend", new String[0]);
    private final Path targetDirectory;

    public FileSearchSchemaCollector(Path targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    @Override
    public void indexSchema(Optional<String> backendName, String indexName, SchemaExport export) {
        Path target = this.targetDirectory.resolve(backendName.map(bn -> Paths.get("backends", bn)).orElse(DEFAULT_BACKEND_PATH)).resolve("indexes").resolve(indexName);
        try {
            export.toFiles(this.checkOrCreateTargetDirectory(target));
        }
        catch (IOException | RuntimeException e) {
            throw MappingLog.INSTANCE.unableToExportSchema(e.getMessage(), e, EventContexts.fromBackendName((String)backendName.orElse(null)).append(EventContexts.fromIndexName((String)indexName)));
        }
    }

    private Path checkOrCreateTargetDirectory(Path targetDirectory) throws IOException {
        if (Files.exists(targetDirectory, new LinkOption[0]) && (!Files.isDirectory(targetDirectory, new LinkOption[0]) || this.isNotEmpty(targetDirectory))) {
            throw MappingLog.INSTANCE.schemaExporterTargetIsNotEmptyDirectory(targetDirectory);
        }
        return Files.createDirectories(targetDirectory, new FileAttribute[0]);
    }

    private boolean isNotEmpty(Path targetDirectory) throws IOException {
        try (Stream<Path> stream = Files.list(targetDirectory);){
            boolean bl = stream.findAny().isPresent();
            return bl;
        }
    }
}

