/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.pojo.search.definition.binding.builtin;

import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.definition.ProjectionDefinitionContext;
import org.hibernate.search.engine.search.projection.definition.spi.AbstractProjectionDefinition;
import org.hibernate.search.mapper.pojo.search.definition.binding.ProjectionBinder;
import org.hibernate.search.mapper.pojo.search.definition.binding.ProjectionBindingContext;
import org.hibernate.search.util.common.spi.ToStringTreeAppender;

public final class EntityProjectionBinder
implements ProjectionBinder {
    private static final EntityProjectionBinder INSTANCE = new EntityProjectionBinder();

    public static EntityProjectionBinder create() {
        return INSTANCE;
    }

    private EntityProjectionBinder() {
    }

    @Override
    public void bind(ProjectionBindingContext context) {
        this.bind(context, context.constructorParameter().rawType());
    }

    private <T> void bind(ProjectionBindingContext context, Class<T> constructorParameterType) {
        context.definition(constructorParameterType, new Definition<T>(constructorParameterType));
    }

    private static class Definition<I>
    extends AbstractProjectionDefinition<I> {
        private final Class<I> requestedEntityType;

        private Definition(Class<I> requestedEntityType) {
            this.requestedEntityType = requestedEntityType;
        }

        protected String type() {
            return "entity";
        }

        public void appendTo(ToStringTreeAppender appender) {
            super.appendTo(appender);
            appender.attribute("requestedEntityType", this.requestedEntityType);
        }

        public SearchProjection<I> create(ProjectionDefinitionContext context) {
            return context.projection().entity(this.requestedEntityType).toProjection();
        }
    }
}

