/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.interceptor;

import java.util.Collection;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.phase.PhaseInterceptor;
import org.jboss.ws.common.utils.DelegateClassLoader;
import org.jboss.wsf.stack.cxf.interceptor.SecurityActions;

abstract class AbstractTCCLAwarePhaseInterceptor<M extends Message>
extends AbstractPhaseInterceptor<M> {
    final PhaseInterceptor<M> delegate;

    AbstractTCCLAwarePhaseInterceptor(PhaseInterceptor<M> delegate) {
        super(delegate.getId(), delegate.getPhase());
        this.delegate = delegate;
        this.addBefore(delegate.getBefore());
        this.addAfter(delegate.getAfter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleFault(M message) {
        ClassLoader original = SecurityActions.getContextClassLoader();
        try {
            if (original instanceof DelegateClassLoader) {
                DelegateClassLoader delegateCL = (DelegateClassLoader)original;
                SecurityActions.setContextClassLoader(delegateCL.getDelegate());
            }
            this.delegate.handleFault(message);
        }
        finally {
            SecurityActions.setContextClassLoader(original);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(M message) throws Fault {
        ClassLoader original = SecurityActions.getContextClassLoader();
        try {
            if (original instanceof DelegateClassLoader) {
                DelegateClassLoader delegateCL = (DelegateClassLoader)original;
                SecurityActions.setContextClassLoader(delegateCL.getDelegate());
            }
            this.delegate.handleMessage(message);
        }
        finally {
            SecurityActions.setContextClassLoader(original);
        }
    }

    public Collection<PhaseInterceptor<? extends Message>> getAdditionalInterceptors() {
        return this.delegate.getAdditionalInterceptors();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + " --- delegating to ---> " + this.delegate.toString();
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AbstractTCCLAwarePhaseInterceptor)) {
            return false;
        }
        return this.delegate.equals(((AbstractTCCLAwarePhaseInterceptor)((Object)obj)).delegate);
    }
}

