/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.spi.core.security.jaas;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.activemq.artemis.spi.core.security.jaas.UserPrincipal;

public class ServiceAccountPrincipal
extends UserPrincipal {
    private static final Pattern SA_NAME_PATTERN = Pattern.compile("system:serviceaccounts:([\\w-]+):([\\w-]+)");
    private String saName;
    private String namespace;

    public ServiceAccountPrincipal(String name) {
        super(name);
        Matcher matcher = SA_NAME_PATTERN.matcher(name);
        if (matcher.find()) {
            this.namespace = matcher.group(1);
            this.saName = matcher.group(2);
        }
    }

    public String getSaName() {
        return this.saName;
    }

    public String getNamespace() {
        return this.namespace;
    }
}

