/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.connectors;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.reactive.messaging.annotations.Blocking;
import io.smallrye.reactive.messaging.providers.connectors.ExecutionHolder;
import io.smallrye.reactive.messaging.providers.connectors.WorkerPoolConfig;
import io.smallrye.reactive.messaging.providers.helpers.Validation;
import io.smallrye.reactive.messaging.providers.i18n.ProviderExceptions;
import io.smallrye.reactive.messaging.providers.i18n.ProviderLogging;
import io.smallrye.reactive.messaging.providers.i18n.ProviderMessages;
import io.vertx.core.Context;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.WorkerExecutorInternal;
import io.vertx.mutiny.core.Vertx;
import io.vertx.mutiny.core.WorkerExecutor;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.BeforeDestroyed;
import jakarta.enterprise.event.Observes;
import jakarta.enterprise.event.Reception;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.inject.Inject;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Outgoing;

@ApplicationScoped
public class WorkerPoolRegistry {
    public static final String WORKER_CONFIG_PREFIX = "smallrye.messaging.worker";
    public static final String WORKER_CONCURRENCY = "max-concurrency";
    public static final String SHUTDOWN_TIMEOUT = "shutdown-timeout";
    public static final String SHUTDOWN_CHECK_INTERVAL = "shutdown-check-interval";
    public static final int DEFAULT_SHUTDOWN_TIMEOUT_MS = 60000;
    public static final int DEFAULT_SHUTDOWN_CHECK_INTERVAL_MS = 5000;
    @Inject
    Instance<ExecutionHolder> executionHolder;
    @Inject
    Instance<Config> configInstance;
    private final Map<String, WorkerPoolConfig> workerConfig = new HashMap<String, WorkerPoolConfig>();
    private final Map<String, WorkerExecutor> workerExecutors = new ConcurrentHashMap<String, WorkerExecutor>();
    private ExecutionHolder holder;
    private volatile boolean closed = false;

    public void terminate(@Observes(notifyObserver=Reception.IF_EXISTS) @Priority(value=100) @BeforeDestroyed(value=ApplicationScoped.class) Object event) {
        if (!this.workerExecutors.isEmpty()) {
            this.closed = true;
            if (!Infrastructure.canCallerThreadBeBlocked()) {
                for (WorkerExecutor executor : this.workerExecutors.values()) {
                    executor.closeAndForget();
                }
                return;
            }
            for (Map.Entry<String, WorkerExecutor> entry : this.workerExecutors.entrySet()) {
                ((WorkerExecutorInternal)entry.getValue().getDelegate()).getPool().executor().shutdown();
            }
            long start = System.nanoTime();
            boolean terminated = false;
            int loop = 1;
            long elapsed = 0L;
            while (!terminated) {
                terminated = true;
                for (Map.Entry<String, WorkerExecutor> entry : this.workerExecutors.entrySet()) {
                    WorkerExecutor workerExecutor = entry.getValue();
                    ExecutorService innerExecutor = ((WorkerExecutorInternal)workerExecutor.getDelegate()).getPool().executor();
                    WorkerPoolConfig poolConfig = this.workerConfig.get(entry.getKey());
                    long timeout = poolConfig.shutdownTimeout().toNanos();
                    long interval = poolConfig.shutdownCheckInterval().toNanos();
                    ProviderLogging.log.debugf("Await termination loop: %s, remaining: %s", loop++, timeout - elapsed);
                    try {
                        if (innerExecutor.awaitTermination(Math.min(timeout, interval), TimeUnit.NANOSECONDS)) continue;
                        elapsed = System.nanoTime() - start;
                        if (elapsed >= timeout) {
                            innerExecutor.shutdownNow();
                            workerExecutor.closeAndAwait();
                            continue;
                        }
                        terminated = false;
                    }
                    catch (InterruptedException ignored) {
                        terminated = false;
                    }
                }
            }
        }
    }

    @PostConstruct
    public void init() {
        if (this.executionHolder.isUnsatisfied()) {
            ProviderLogging.log.noExecutionHolderDisablingBlockingSupport();
        } else {
            this.holder = (ExecutionHolder)this.executionHolder.get();
        }
    }

    public <T> Uni<T> executeWork(io.vertx.mutiny.core.Context msgContext, Uni<T> uni, String workerName, boolean ordered) {
        if (this.closed) {
            throw new RejectedExecutionException("WorkerPoolRegistry is being shut down");
        }
        if (this.holder == null) {
            throw new UnsupportedOperationException("@Blocking disabled");
        }
        Objects.requireNonNull(uni, ProviderMessages.msg.actionNotProvided());
        if (workerName == null) {
            if (msgContext != null) {
                return msgContext.executeBlocking(uni, ordered);
            }
            return this.holder.vertx().executeBlocking(uni, ordered);
        }
        WorkerExecutor worker = this.getWorker(workerName);
        if (msgContext != null) {
            return WorkerPoolRegistry.uniOnMessageContext(worker.executeBlocking(uni, ordered), msgContext).onItemOrFailure().transformToUni((item, failure) -> Uni.createFrom().emitter(emitter -> {
                if (failure != null) {
                    msgContext.runOnContext(() -> emitter.fail(failure));
                } else {
                    msgContext.runOnContext(() -> emitter.complete(item));
                }
            }));
        }
        return worker.executeBlocking(uni, ordered);
    }

    private static <T> Uni<T> uniOnMessageContext(Uni<T> uni, io.vertx.mutiny.core.Context msgContext) {
        if (msgContext != null && !msgContext.equals((Object)Vertx.currentContext())) {
            return Uni.createFrom().deferred(() -> uni).runSubscriptionOn(r -> new ContextPreservingRunnable(r, msgContext).run());
        }
        return uni;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorkerExecutor getWorker(String workerName) {
        Objects.requireNonNull(workerName, ProviderMessages.msg.workerNameNotSpecified());
        if (this.workerExecutors.containsKey(workerName)) {
            return this.workerExecutors.get(workerName);
        }
        if (this.workerConfig.containsKey(workerName)) {
            WorkerExecutor executor = this.workerExecutors.get(workerName);
            if (executor == null) {
                WorkerPoolRegistry workerPoolRegistry = this;
                synchronized (workerPoolRegistry) {
                    executor = this.workerExecutors.get(workerName);
                    if (executor == null) {
                        int poolSize = this.workerConfig.get(workerName).maxConcurrency();
                        executor = this.holder.vertx().createSharedWorkerExecutor(workerName, poolSize);
                        ProviderLogging.log.workerPoolCreated(workerName, poolSize);
                        this.workerExecutors.put(workerName, executor);
                    }
                }
            }
            if (executor != null) {
                return executor;
            }
            throw ProviderExceptions.ex.runtimeForFailedWorker(workerName);
        }
        throw ProviderExceptions.ex.illegalArgumentForFailedWorker();
    }

    public <T> void analyzeWorker(AnnotatedType<T> annotatedType) {
        Objects.requireNonNull(annotatedType, ProviderMessages.msg.annotatedTypeWasEmpty());
        Set methods = annotatedType.getMethods();
        methods.stream().filter(m -> m.isAnnotationPresent(Blocking.class)).forEach(m -> this.defineWorker(m.getJavaMember()));
    }

    public void defineWorker(String className, String method, String poolName) {
        Objects.requireNonNull(className, ProviderMessages.msg.classNameWasEmpty());
        Objects.requireNonNull(method, ProviderMessages.msg.methodWasEmpty());
        if (!poolName.equals("<no-value>")) {
            if (Validation.isBlank(poolName)) {
                throw ProviderExceptions.ex.illegalArgumentForAnnotationNullOrBlank("@Blocking", className + "#" + method);
            }
            this.workerConfig.put(poolName, this.getWorkerPoolConfig(className, method, poolName));
        }
    }

    private WorkerPoolConfig getWorkerPoolConfig(String className, String method, String poolName) {
        Config config = (Config)this.configInstance.get();
        String maxConcurrencyConfigKey = "smallrye.messaging.worker." + poolName + ".max-concurrency";
        String shutdownTimeoutConfigKey = "smallrye.messaging.worker." + poolName + ".shutdown-timeout";
        String shutdownCheckIntervalConfigKey = "smallrye.messaging.worker." + poolName + ".shutdown-check-interval";
        int maxConcurrency = (Integer)config.getOptionalValue(maxConcurrencyConfigKey, Integer.class).orElseThrow(() -> ProviderExceptions.ex.illegalArgumentForWorkerConfigKey("@Blocking", className + "#" + method, maxConcurrencyConfigKey));
        int shutdownTimeout = config.getOptionalValue(shutdownTimeoutConfigKey, Integer.class).orElse(60000);
        int shutdownCheckInterval = config.getOptionalValue(shutdownCheckIntervalConfigKey, Integer.class).orElse(5000);
        return new WorkerPoolConfig(maxConcurrency, shutdownTimeout, shutdownCheckInterval);
    }

    private void defineWorker(Method method) {
        Objects.requireNonNull(method, ProviderMessages.msg.methodWasEmpty());
        Blocking blocking = method.getAnnotation(Blocking.class);
        String methodName = method.getName();
        String className = method.getDeclaringClass().getName();
        if (!method.isAnnotationPresent(Incoming.class) && !method.isAnnotationPresent(Outgoing.class)) {
            throw ProviderExceptions.ex.illegalBlockingSignature(className + "#" + String.valueOf(method));
        }
        this.defineWorker(className, methodName, blocking.value());
    }

    private static final class ContextPreservingRunnable
    implements Runnable {
        private final Runnable task;
        private final Context context;

        public ContextPreservingRunnable(Runnable task, io.vertx.mutiny.core.Context context) {
            this.task = task;
            this.context = context.getDelegate();
        }

        @Override
        public void run() {
            if (this.context instanceof ContextInternal) {
                ContextInternal contextInternal = (ContextInternal)this.context;
                ContextInternal previousContext = contextInternal.beginDispatch();
                try {
                    this.task.run();
                }
                finally {
                    contextInternal.endDispatch(previousContext);
                }
            } else {
                this.task.run();
            }
        }
    }
}

