/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.internal.constraintvalidators.hv.pl;

import jakarta.validation.ConstraintValidator;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import org.hibernate.validator.internal.constraintvalidators.hv.ModCheckBase;
import org.hibernate.validator.internal.util.ModUtil;

public abstract class PolishNumberValidator<T extends Annotation>
extends ModCheckBase
implements ConstraintValidator<T, CharSequence> {
    @Override
    public boolean isCheckDigitValid(List<Integer> digits, char checkDigit) {
        Collections.reverse(digits);
        int[] weights = this.getWeights(digits);
        if (weights.length != digits.size()) {
            return false;
        }
        int modResult = 11 - ModUtil.calculateModXCheckWithWeights(digits, 11, Integer.MAX_VALUE, weights);
        switch (modResult) {
            case 10: 
            case 11: {
                return this.checkTwoDigitModuloResult(checkDigit);
            }
        }
        return Character.isDigit(checkDigit) && modResult == this.extractDigit(checkDigit);
    }

    protected boolean checkTwoDigitModuloResult(char checkDigit) {
        return checkDigit == '0';
    }

    protected abstract int[] getWeights(List<Integer> var1);
}

