/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedMap;
import java.util.function.Function;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.FieldSetReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.util.AbstractMapMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.ComparatorMarshaller;

public class SortedMapMarshaller<K, V, T extends SortedMap<K, V>>
extends AbstractMapMarshaller<K, V, T> {
    private static final int COMPARATOR_INDEX = 2;
    private final Function<Comparator<? super K>, T> factory;

    public SortedMapMarshaller(Function<Comparator<? super K>, T> factory) {
        super(((SortedMap)factory.apply((Comparator<K>)ComparatorMarshaller.INSTANCE.createInitialValue())).getClass());
        this.factory = factory;
    }

    @Override
    public T readFrom(ProtoStreamReader reader) throws IOException {
        FieldSetReader<Object> comparatorReader = reader.createFieldSetReader(ComparatorMarshaller.INSTANCE, 2);
        Object comparator = ComparatorMarshaller.INSTANCE.createInitialValue();
        LinkedList<Map.Entry> entries = new LinkedList<Map.Entry>();
        while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            int index = WireType.getTagFieldNumber((int)tag);
            if (index == 1) {
                entries.add(reader.readObject(AbstractMap.SimpleEntry.class));
                continue;
            }
            if (comparatorReader.contains(index)) {
                comparator = (Comparator)comparatorReader.readField(comparator);
                continue;
            }
            reader.skipField(tag);
        }
        SortedMap map = (SortedMap)this.factory.apply((Comparator<K>)comparator);
        for (Map.Entry entry : entries) {
            map.put(entry.getKey(), entry.getValue());
        }
        return (T)map;
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, T map) throws IOException {
        super.writeTo(writer, map);
        Comparator comparator = map.comparator();
        if (comparator != ComparatorMarshaller.INSTANCE.createInitialValue()) {
            writer.createFieldSetWriter(ComparatorMarshaller.INSTANCE, 2).writeFields(comparator);
        }
    }
}

