/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.certificate;

import java.security.Key;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sshd.common.BaseBuilder;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.config.keys.OpenSshCertificate;
import org.apache.sshd.common.config.keys.OpenSshCertificateImpl;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.random.JceRandom;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.signature.SignatureFactory;
import org.apache.sshd.common.util.MapEntryUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;

public class OpenSshCertificateBuilder {
    protected static final Map<String, String> SIGNATURE_ALGORITHM_MAP = MapEntryUtils.MapBuilder.builder().put((Object)"ssh-rsa", (Object)"ssh-rsa-cert-v01@openssh.com").put((Object)"ssh-ed25519", (Object)"ssh-ed25519-cert-v01@openssh.com").put((Object)KeyPairProvider.ECDSA_SHA2_NISTP256, (Object)"ecdsa-sha2-nistp256-cert-v01@openssh.com").put((Object)KeyPairProvider.ECDSA_SHA2_NISTP384, (Object)"ecdsa-sha2-nistp384-cert-v01@openssh.com").put((Object)KeyPairProvider.ECDSA_SHA2_NISTP521, (Object)"ecdsa-sha2-nistp521-cert-v01@openssh.com").build();
    protected final OpenSshCertificate.Type type;
    protected PublicKey publicKey;
    protected long serial;
    protected String id;
    protected Collection<String> principals;
    protected final Map<String, String> criticalOptions = new HashMap<String, String>();
    protected final Map<String, String> extensions = new HashMap<String, String>();
    protected long validAfter = 0L;
    protected long validBefore = -1L;
    protected byte[] nonce;

    protected OpenSshCertificateBuilder(OpenSshCertificate.Type type) {
        this.type = type;
    }

    public static OpenSshCertificateBuilder userCertificate() {
        return new OpenSshCertificateBuilder(OpenSshCertificate.Type.USER);
    }

    public static OpenSshCertificateBuilder hostCertificate() {
        return new OpenSshCertificateBuilder(OpenSshCertificate.Type.HOST);
    }

    public OpenSshCertificateBuilder publicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
        return this;
    }

    public OpenSshCertificateBuilder serial(long serial) {
        this.serial = serial;
        return this;
    }

    public OpenSshCertificateBuilder id(String id) {
        this.id = id;
        return this;
    }

    public OpenSshCertificateBuilder principals(Collection<String> principals) {
        this.principals = principals;
        return this;
    }

    public OpenSshCertificateBuilder criticalOption(String name, String data) {
        String key = ValidateUtils.checkNotNullAndNotEmpty((String)name, (String)"Critical option name must be set");
        this.criticalOptions.put(key, data == null ? "" : data);
        return this;
    }

    public OpenSshCertificateBuilder criticalOptions(List<OpenSshCertificate.CertificateOption> criticalOptions) {
        this.criticalOptions.clear();
        for (OpenSshCertificate.CertificateOption option : criticalOptions) {
            String value;
            String key = ValidateUtils.checkNotNullAndNotEmpty((String)option.getName(), (String)"Critical option name must be set");
            String prev = this.criticalOptions.put(key, (value = option.getData()) == null ? "" : value);
            if (prev == null) continue;
            throw new IllegalArgumentException("Duplicate certificate option " + key);
        }
        return this;
    }

    public OpenSshCertificateBuilder criticalOptions(Map<String, String> criticalOptions) {
        this.criticalOptions.clear();
        criticalOptions.forEach((k, v) -> {
            String key = ValidateUtils.checkNotNullAndNotEmpty((String)k, (String)"Critical option name must be set");
            this.criticalOptions.put(key, v == null ? "" : v);
        });
        return this;
    }

    public OpenSshCertificateBuilder extension(String name, String data) {
        String key = ValidateUtils.checkNotNullAndNotEmpty((String)name, (String)"Extension name must be set");
        this.extensions.put(key, data == null ? "" : data);
        return this;
    }

    public OpenSshCertificateBuilder extensions(List<OpenSshCertificate.CertificateOption> extensions) {
        this.extensions.clear();
        for (OpenSshCertificate.CertificateOption option : extensions) {
            String value;
            String key = ValidateUtils.checkNotNullAndNotEmpty((String)option.getName(), (String)"Extension name must be set");
            String prev = this.extensions.put(key, (value = option.getData()) == null ? "" : value);
            if (prev == null) continue;
            throw new IllegalArgumentException("Duplicate certificate extension " + key);
        }
        return this;
    }

    public OpenSshCertificateBuilder extensions(Map<String, String> extensions) {
        this.extensions.clear();
        extensions.forEach((k, v) -> {
            String key = ValidateUtils.checkNotNullAndNotEmpty((String)k, (String)"Extension name must be set");
            this.extensions.put(key, v == null ? "" : v);
        });
        return this;
    }

    public OpenSshCertificateBuilder validAfter(long validAfter) {
        this.validAfter = validAfter;
        return this;
    }

    public OpenSshCertificateBuilder nonce(byte[] nonce) {
        this.nonce = nonce;
        return this;
    }

    public OpenSshCertificateBuilder validAfter(Instant validAfter) {
        if (validAfter == null) {
            return this.validAfter(0L);
        }
        if (Instant.EPOCH.compareTo(validAfter) <= 0) {
            return this.validAfter(validAfter.getEpochSecond());
        }
        throw new IllegalArgumentException("Valid-after cannot be < epoch");
    }

    public OpenSshCertificateBuilder validBefore(long validBefore) {
        this.validBefore = validBefore;
        return this;
    }

    public OpenSshCertificateBuilder validBefore(Instant validBefore) {
        if (validBefore == null) {
            return this.validBefore(-1L);
        }
        if (Instant.EPOCH.compareTo(validBefore) <= 0) {
            return this.validBefore(validBefore.getEpochSecond());
        }
        throw new IllegalArgumentException("Valid-before cannot be < epoch");
    }

    protected void validate() {
        if (this.nonce != null && this.nonce.length != 16 && this.nonce.length != 32) {
            throw new IllegalStateException("'nonce' must be 16 or 32 bytes");
        }
        if (this.type == null) {
            throw new IllegalStateException("'type' is required");
        }
        if (this.id == null) {
            throw new IllegalStateException("'id' is required");
        }
        if (this.publicKey == null) {
            throw new IllegalStateException("'publicKey' is required");
        }
    }

    public OpenSshCertificate sign(KeyPair caKeypair) throws Exception {
        return this.sign(caKeypair, null);
    }

    public OpenSshCertificate sign(KeyPair caKeypair, String signatureAlgorithm) throws Exception {
        NamedFactory factory;
        this.validate();
        String publicKeyType = KeyUtils.getKeyType((Key)this.publicKey);
        String certType = SIGNATURE_ALGORITHM_MAP.get(publicKeyType);
        if (certType == null) {
            throw new UnsupportedOperationException("unsupported public key type '" + publicKeyType + "' for OpenSSH Certificate");
        }
        OpenSshCertificateImpl cert = new OpenSshCertificateImpl();
        cert.setKeyType(certType);
        cert.setType(this.type);
        cert.setCertPubKey(this.publicKey);
        cert.setSerial(this.serial);
        cert.setId(this.id);
        if (this.principals != null && !this.principals.isEmpty()) {
            cert.setPrincipals(new ArrayList<String>(this.principals));
        }
        if (!this.criticalOptions.isEmpty()) {
            cert.setCriticalOptions(this.criticalOptions);
        }
        if (!this.extensions.isEmpty()) {
            cert.setExtensions(this.extensions);
        }
        cert.setValidAfter(this.validAfter);
        cert.setValidBefore(this.validBefore);
        cert.setCaPubKey(caKeypair.getPublic());
        if (this.nonce != null) {
            cert.setNonce(this.nonce);
        } else {
            SecureRandom rand = JceRandom.getGlobalInstance();
            byte[] tempNonce = new byte[32];
            rand.nextBytes(tempNonce);
            cert.setNonce(tempNonce);
        }
        String algo = KeyUtils.getKeyType((Key)caKeypair.getPublic());
        if (signatureAlgorithm != null) {
            ValidateUtils.checkTrue((boolean)KeyUtils.getAllEquivalentKeyTypes((String)algo).contains(signatureAlgorithm), (String)"Invalid CA signature algorithm %s for CA key type %s", (Object[])new Object[]{signatureAlgorithm, algo});
            algo = signatureAlgorithm;
            factory = BuiltinSignatures.fromFactoryName((String)algo);
        } else {
            factory = SignatureFactory.resolveSignatureFactory((String)algo, BaseBuilder.DEFAULT_SIGNATURE_PREFERENCE);
        }
        Signature signer = factory == null ? null : (Signature)factory.create();
        ValidateUtils.checkNotNull((Object)signer, (String)"No signer could be located for signature algorithm=%s", (Object)algo);
        ByteArrayBuffer toBeSignedBuf = new ByteArrayBuffer();
        toBeSignedBuf.putRawPublicKey((PublicKey)cert);
        byte[] toSign = toBeSignedBuf.getCompactData();
        signer.initSigner(null, caKeypair.getPrivate());
        signer.update(null, toSign);
        ByteArrayBuffer tmpBuffer = new ByteArrayBuffer();
        tmpBuffer.putString(factory.getName());
        tmpBuffer.putBytes(signer.sign(null));
        cert.setMessage(toSign);
        cert.setSignature(tmpBuffer.getCompactData());
        return cert;
    }
}

