/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.channels;

import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import java.util.concurrent.TimeUnit;
import org.xnio.Buffers;
import org.xnio.channels.Channels;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.WriteTimeoutException;

public class BlockingWritableByteChannel
implements GatheringByteChannel,
Flushable {
    private final StreamSinkChannel delegate;
    private volatile long writeTimeout;

    public BlockingWritableByteChannel(StreamSinkChannel delegate) {
        this.delegate = delegate;
    }

    public BlockingWritableByteChannel(StreamSinkChannel delegate, long writeTimeout, TimeUnit writeTimeoutUnit) {
        if (writeTimeout < 0L) {
            throw new IllegalArgumentException("Negative write timeout");
        }
        this.delegate = delegate;
        long calcTimeout = writeTimeoutUnit.toMillis(writeTimeout);
        this.writeTimeout = writeTimeout == 0L ? 0L : (calcTimeout < 1L ? 1L : calcTimeout);
    }

    public void setWriteTimeout(long writeTimeout, TimeUnit writeTimeoutUnit) {
        if (writeTimeout < 0L) {
            throw new IllegalArgumentException("Negative write timeout");
        }
        long calcTimeout = writeTimeoutUnit.toMillis(writeTimeout);
        this.writeTimeout = writeTimeout == 0L ? 0L : (calcTimeout < 1L ? 1L : calcTimeout);
    }

    @Override
    public long write(ByteBuffer[] srcs, int offset, int length) throws IOException {
        long res;
        StreamSinkChannel delegate = this.delegate;
        long writeTimeout = this.writeTimeout;
        if (writeTimeout == 0L) {
            while ((res = delegate.write(srcs, offset, length)) == 0L && Buffers.hasRemaining(srcs, offset, length)) {
                delegate.awaitWritable();
            }
        } else {
            long now = System.currentTimeMillis();
            long deadline = now + writeTimeout;
            while ((res = delegate.write(srcs, offset, length)) == 0L && Buffers.hasRemaining(srcs, offset, length)) {
                if (now >= deadline) {
                    throw new WriteTimeoutException("Write timed out");
                }
                delegate.awaitWritable(deadline - now, TimeUnit.MILLISECONDS);
            }
        }
        return res;
    }

    @Override
    public long write(ByteBuffer[] srcs) throws IOException {
        return this.write(srcs, 0, srcs.length);
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int res;
        StreamSinkChannel delegate = this.delegate;
        long writeTimeout = this.writeTimeout;
        if (writeTimeout == 0L) {
            while ((res = delegate.write(src)) == 0 && src.hasRemaining()) {
                delegate.awaitWritable();
            }
        } else {
            long now = System.currentTimeMillis();
            long deadline = now + writeTimeout;
            while ((res = delegate.write(src)) == 0 && src.hasRemaining()) {
                if (now >= deadline) {
                    throw new WriteTimeoutException("Write timed out");
                }
                delegate.awaitWritable(deadline - now, TimeUnit.MILLISECONDS);
            }
        }
        return res;
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public void flush() throws IOException {
        StreamSinkChannel delegate = this.delegate;
        long writeTimeout = this.writeTimeout;
        if (writeTimeout == 0L) {
            Channels.flushBlocking(delegate);
        } else {
            long now = System.currentTimeMillis();
            long deadline = now + writeTimeout;
            while (!delegate.flush()) {
                if (now >= deadline) {
                    throw new WriteTimeoutException("Flush timed out");
                }
                delegate.awaitWritable(deadline - now, TimeUnit.MILLISECONDS);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

