/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server.deployment;

import org.jboss.as.server.deployment.AttachableDependency;
import org.jboss.as.server.deployment.AttachmentKey;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.deployment.SimpleAttachable;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;

final class DeploymentPhaseContextImpl
extends SimpleAttachable
implements DeploymentPhaseContext {
    private final ServiceTarget serviceTarget;
    private final ServiceRegistry serviceRegistry;
    private final ServiceBuilder<?> nextPhaseBuilder;
    private final DeploymentUnit deploymentUnitContext;
    private final Phase phase;

    DeploymentPhaseContextImpl(ServiceTarget serviceTarget, ServiceRegistry serviceRegistry, ServiceBuilder<?> nextPhaseBuilder, DeploymentUnit deploymentUnitContext, Phase phase) {
        this.serviceTarget = serviceTarget;
        this.serviceRegistry = serviceRegistry;
        this.nextPhaseBuilder = nextPhaseBuilder;
        this.deploymentUnitContext = deploymentUnitContext;
        this.phase = phase;
    }

    @Override
    public ServiceName getPhaseServiceName() {
        return this.deploymentUnitContext.getServiceName().append(new String[]{this.phase.name()});
    }

    @Override
    public ServiceTarget getServiceTarget() {
        return this.serviceTarget;
    }

    @Override
    public ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Override
    public DeploymentUnit getDeploymentUnit() {
        return this.deploymentUnitContext;
    }

    @Override
    public Phase getPhase() {
        return this.phase;
    }

    @Override
    public <T> void addDependency(ServiceName serviceName, AttachmentKey<T> attachmentKey) {
        this.addToAttachmentList(Attachments.NEXT_PHASE_ATTACHABLE_DEPS, new AttachableDependency(attachmentKey, serviceName, false));
    }

    @Override
    public <T> void addDependency(ServiceName serviceName, Class<T> type, Injector<T> injector) {
        this.nextPhaseBuilder.addDependency(serviceName, type, injector);
    }

    @Override
    public <T> void addDeploymentDependency(ServiceName serviceName, AttachmentKey<T> attachmentKey) {
        this.addToAttachmentList(Attachments.NEXT_PHASE_ATTACHABLE_DEPS, new AttachableDependency(attachmentKey, serviceName, true));
    }
}

