/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.host.controller.mgmt;

import java.io.Closeable;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Executor;
import org.jboss.as.controller.HashUtil;
import org.jboss.as.domain.controller.DomainController;
import org.jboss.as.host.controller.logging.HostControllerLogger;
import org.jboss.as.host.controller.mgmt.DomainRemoteFileRequestAndHandler;
import org.jboss.as.process.protocol.ProtocolUtils;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.as.protocol.mgmt.ActiveOperation;
import org.jboss.as.protocol.mgmt.FlushableDataOutput;
import org.jboss.as.protocol.mgmt.ManagementProtocolHeader;
import org.jboss.as.protocol.mgmt.ManagementRequestContext;
import org.jboss.as.protocol.mgmt.ManagementRequestHandler;
import org.jboss.as.protocol.mgmt.ManagementRequestHandlerFactory;
import org.jboss.as.protocol.mgmt.ManagementRequestHeader;
import org.jboss.as.protocol.mgmt.ManagementResponseHeader;
import org.jboss.as.protocol.mgmt.RequestProcessingException;
import org.jboss.as.repository.ContentReference;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.as.repository.RemoteFileRequestAndHandler;
import org.jboss.dmr.ModelNode;

class MasterDomainControllerOperationHandlerImpl
implements ManagementRequestHandlerFactory {
    private final DomainController domainController;
    private final Executor asyncExecutor;

    public MasterDomainControllerOperationHandlerImpl(DomainController domainController, Executor asyncExecutor) {
        this.domainController = domainController;
        this.asyncExecutor = asyncExecutor;
    }

    public ManagementRequestHandler<?, ?> resolveHandler(ManagementRequestHandlerFactory.RequestHandlerChain handlers, ManagementRequestHeader header) {
        byte operationId = header.getOperationId();
        switch (operationId) {
            case 83: {
                handlers.registerActiveOperation(Integer.valueOf(header.getBatchId()), null);
                return new UnregisterOperation();
            }
            case 85: {
                handlers.registerActiveOperation(Integer.valueOf(header.getBatchId()), null);
                return new GetFileOperation();
            }
        }
        return handlers.resolveNext();
    }

    static abstract class AbstractHostRequestHandler
    implements ManagementRequestHandler<ModelNode, Void> {
        AbstractHostRequestHandler() {
        }

        abstract void handleRequest(String var1, DataInput var2, ManagementRequestContext<Void> var3) throws IOException;

        public void handleRequest(DataInput input, ActiveOperation.ResultHandler<ModelNode> resultHandler, ManagementRequestContext<Void> context) throws IOException {
            ProtocolUtils.expectHeader((DataInput)input, (int)32);
            String hostId = input.readUTF();
            this.handleRequest(hostId, input, context);
            resultHandler.done(null);
        }

        protected FlushableDataOutput writeGenericResponseHeader(ManagementRequestContext<Void> context) throws IOException {
            ManagementResponseHeader header = ManagementResponseHeader.create((ManagementProtocolHeader)context.getRequestHeader());
            return context.writeMessage((ManagementProtocolHeader)header);
        }
    }

    private class GetFileOperation
    extends AbstractHostRequestHandler {
        private final DomainRemoteFileRequestAndHandler remoteSupport;

        private GetFileOperation() {
            this.remoteSupport = new DomainRemoteFileRequestAndHandler(MasterDomainControllerOperationHandlerImpl.this.asyncExecutor);
        }

        @Override
        void handleRequest(String hostId, DataInput input, ManagementRequestContext<Void> context) throws IOException {
            RemoteFileRequestAndHandler.RootFileReader reader = new RemoteFileRequestAndHandler.RootFileReader(){

                public File readRootFile(byte rootId, String filePath) throws RequestProcessingException {
                    HostFileRepository localFileRepository = MasterDomainControllerOperationHandlerImpl.this.domainController.getLocalFileRepository();
                    switch (rootId) {
                        case 38: {
                            return localFileRepository.getFile(filePath);
                        }
                        case 39: {
                            return localFileRepository.getConfigurationFile(filePath);
                        }
                        case 40: {
                            byte[] hash = HashUtil.hexStringToByteArray((String)filePath);
                            return localFileRepository.getDeploymentRoot(new ContentReference(filePath, hash));
                        }
                    }
                    throw HostControllerLogger.ROOT_LOGGER.invalidRootId(rootId);
                }
            };
            this.remoteSupport.handleRequest(input, reader, context);
        }
    }

    private class UnregisterOperation
    extends AbstractHostRequestHandler {
        private UnregisterOperation() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        void handleRequest(String hostId, DataInput input, ManagementRequestContext<Void> context) throws IOException {
            MasterDomainControllerOperationHandlerImpl.this.domainController.unregisterRemoteHost(hostId, null, true);
            FlushableDataOutput os = this.writeGenericResponseHeader(context);
            try {
                os.write(36);
                os.close();
            }
            finally {
                StreamUtils.safeClose((Closeable)os);
            }
        }
    }
}

