/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.component;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.Iterator;
import org.jboss.as.ee.component.InjectionTarget;
import org.jboss.as.ee.component.ManagedReferenceMethodInjectionInterceptorFactory;
import org.jboss.as.ee.logging.EeLogger;
import org.jboss.as.naming.ManagedReferenceFactory;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndexUtil;
import org.jboss.as.server.deployment.reflect.DeploymentClassIndex;
import org.jboss.as.server.deployment.reflect.DeploymentReflectionIndex;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.msc.value.Value;

public final class MethodInjectionTarget
extends InjectionTarget {
    public MethodInjectionTarget(String className, String name, String paramType) {
        super(className, name, paramType);
    }

    @Override
    public boolean isStatic(DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        return Modifier.isStatic(this.getMethod(deploymentUnit).getModifiers());
    }

    @Override
    public InterceptorFactory createInjectionInterceptorFactory(Object targetContextKey, Object valueContextKey, Value<ManagedReferenceFactory> factoryValue, DeploymentUnit deploymentUnit, boolean optional) throws DeploymentUnitProcessingException {
        return new ManagedReferenceMethodInjectionInterceptorFactory(targetContextKey, valueContextKey, factoryValue, this.getMethod(deploymentUnit), optional);
    }

    public Method getMethod(DeploymentUnit deploymentUnit) throws DeploymentUnitProcessingException {
        Class clazz;
        String name = this.getName();
        String className = this.getClassName();
        String paramType = this.getDeclaredValueClassName();
        DeploymentReflectionIndex reflectionIndex = (DeploymentReflectionIndex)deploymentUnit.getAttachment(Attachments.REFLECTION_INDEX);
        DeploymentClassIndex index = (DeploymentClassIndex)deploymentUnit.getAttachment(Attachments.CLASS_INDEX);
        try {
            clazz = index.classIndex(className).getModuleClass();
        }
        catch (ClassNotFoundException e) {
            throw new DeploymentUnitProcessingException((Throwable)e);
        }
        Method method = this.getMethod(reflectionIndex, clazz);
        return method;
    }

    public Method getMethod(DeploymentReflectionIndex reflectionIndex, Class<?> clazz) throws DeploymentUnitProcessingException {
        Iterator iterator;
        ClassReflectionIndex classIndex = reflectionIndex.getClassIndex(clazz);
        Collection methods = null;
        String paramType = this.getDeclaredValueClassName();
        String name = this.getName();
        String className = this.getClassName();
        if (paramType != null) {
            methods = ClassReflectionIndexUtil.findMethods((DeploymentReflectionIndex)reflectionIndex, (ClassReflectionIndex)classIndex, (String)name, (String[])new String[]{paramType});
        }
        if (methods == null || methods.isEmpty()) {
            methods = ClassReflectionIndexUtil.findAllMethods((DeploymentReflectionIndex)reflectionIndex, (ClassReflectionIndex)classIndex, (String)name, (int)1);
        }
        if (!(iterator = methods.iterator()).hasNext()) {
            throw EeLogger.ROOT_LOGGER.methodNotFound(name, paramType, className);
        }
        Method method = (Method)iterator.next();
        if (iterator.hasNext()) {
            throw EeLogger.ROOT_LOGGER.multipleMethodsFound(name, paramType, className);
        }
        return method;
    }
}

