/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.aop.aspectj.autoproxy;

import org.springframework.aop.aspectj.annotation.AspectMetadata;
import org.springframework.aop.aspectj.annotation.MetadataAwareAspectInstanceFactory;
import org.springframework.beans.factory.BeanFactory;

public class BeanFactoryAspectInstanceFactory
implements MetadataAwareAspectInstanceFactory {
    private final BeanFactory beanFactory;
    private final String name;
    private final AspectMetadata am;
    private int instantiations;

    public BeanFactoryAspectInstanceFactory(BeanFactory beanFactory, String name) {
        this(beanFactory, name, beanFactory.getType(name));
    }

    public BeanFactoryAspectInstanceFactory(BeanFactory beanFactory, String name, Class type) {
        this.beanFactory = beanFactory;
        this.name = name;
        this.am = new AspectMetadata(type, name);
    }

    public synchronized Object getAspectInstance() {
        ++this.instantiations;
        return this.beanFactory.getBean(this.name);
    }

    public AspectMetadata getAspectMetadata() {
        return this.am;
    }

    public int getInstantiationCount() {
        return this.instantiations;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": bean name='" + this.name + "'; " + "instantiations=" + this.instantiations;
    }
}

