/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.view.tiles;

import java.io.File;
import java.io.IOException;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.tiles.ComponentContext;
import org.apache.struts.tiles.ControllerSupport;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.util.NestedServletException;
import org.springframework.web.util.WebUtils;

public abstract class ComponentControllerSupport
extends ControllerSupport {
    private WebApplicationContext webApplicationContext;
    private MessageSourceAccessor messageSourceAccessor;

    public final void perform(ComponentContext componentContext, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws ServletException, IOException {
        try {
            this.execute(componentContext, request, response, servletContext);
        }
        catch (ServletException ex) {
            throw ex;
        }
        catch (IOException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new NestedServletException("Execution of component controller failed", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void execute(ComponentContext componentContext, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws Exception {
        ComponentControllerSupport componentControllerSupport = this;
        synchronized (componentControllerSupport) {
            if (this.webApplicationContext == null) {
                this.webApplicationContext = RequestContextUtils.getWebApplicationContext((ServletRequest)request, servletContext);
                this.messageSourceAccessor = new MessageSourceAccessor((MessageSource)this.webApplicationContext);
            }
        }
        this.doPerform(componentContext, request, response);
    }

    protected void initApplicationContext() throws BeansException {
    }

    protected final ApplicationContext getApplicationContext() {
        return this.webApplicationContext;
    }

    protected final WebApplicationContext getWebApplicationContext() {
        return this.webApplicationContext;
    }

    protected final MessageSourceAccessor getMessageSourceAccessor() {
        return this.messageSourceAccessor;
    }

    protected final ServletContext getServletContext() {
        return this.webApplicationContext.getServletContext();
    }

    protected final File getTempDir() {
        return WebUtils.getTempDir((ServletContext)this.getServletContext());
    }

    protected abstract void doPerform(ComponentContext var1, HttpServletRequest var2, HttpServletResponse var3) throws Exception;
}

