/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class SampleMain {
    @Option(name="-r", usage="recursively run something")
    private boolean recursive;
    @Option(name="-o", usage="output to this file", metaVar="OUTPUT")
    private File out = new File(".");
    @Option(name="-str")
    private String str = "(default value)";
    @Option(name="-n", usage="repeat <n> times\nusage can have new lines in it and also it can be verrrrrrrrrrrrrrrrrry long")
    private int num = -1;
    @Argument
    private List<String> arguments = new ArrayList<String>();

    public static void main(String[] args) throws IOException {
        new SampleMain().doMain(args);
    }

    public void doMain(String[] args) throws IOException {
        CmdLineParser parser = new CmdLineParser(this);
        try {
            parser.parseArgument(args);
            if (this.arguments.isEmpty()) {
                throw new CmdLineException("No argument is given");
            }
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("java SampleMain [options...] arguments...");
            parser.printUsage(System.err);
            return;
        }
        System.out.println(this.out);
        if (this.recursive) {
            System.out.println("-r flag is set");
        }
        System.out.println("-str was " + this.str);
        if (this.num >= 0) {
            System.out.println("-n was " + this.num);
        }
        System.out.println("other arguments are:");
        for (String s : this.arguments) {
            System.out.println(s);
        }
    }
}

