/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wts.tools.htmlmacro;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Stack;
import org.apache.commons.jelly.XMLOutput;
import org.dom4j.io.HTMLWriter;
import org.dom4j.io.OutputFormat;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class HTMLOutput
extends XMLOutput {
    public static XMLOutput create(OutputStream os, String encoding) throws UnsupportedEncodingException {
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setEncoding(encoding);
        format.setTrimText(false);
        return HTMLOutput.createXMLOutput(new HTMLWriter(os, format){
            private Charset charset;
            private CharsetEncoder encoder;
            private Stack<State> states = new Stack();

            protected Writer createWriter(OutputStream outStream, String encoding) throws UnsupportedEncodingException {
                try {
                    this.charset = Charset.forName(encoding);
                    this.encoder = this.charset.newEncoder();
                }
                catch (UnsupportedCharsetException e) {
                    throw new UnsupportedEncodingException(encoding);
                }
                return new BufferedWriter(new OutputStreamWriter(outStream, this.charset));
            }

            public void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
                super.startElement(namespaceURI, localName, qName, attributes);
                this.states.push(new State());
                if (this.isPreformattedTag(qName)) {
                    OutputFormat currentFormat = this.getOutputFormat();
                    currentFormat.setNewlines(false);
                    currentFormat.setTrimText(false);
                    currentFormat.setIndent("");
                }
            }

            public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
                super.endElement(namespaceURI, localName, qName);
                this.states.pop().restore();
            }

            protected boolean shouldEncodeChar(char c) {
                return super.shouldEncodeChar(c) || c == '\u00a0' || !this.encoder.canEncode(c);
            }

            class State {
                private final boolean newLines;
                private final boolean trimText;
                private final String indent;

                State() {
                    OutputFormat currentFormat = this.getOutputFormat();
                    this.newLines = currentFormat.isNewlines();
                    this.trimText = currentFormat.isTrimText();
                    this.indent = currentFormat.getIndent();
                }

                void restore() {
                    OutputFormat currentFormat = this.getOutputFormat();
                    currentFormat.setNewlines(this.newLines);
                    currentFormat.setTrimText(this.trimText);
                    currentFormat.setIndent(this.indent);
                }
            }
        });
    }
}

