/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wts.tools.htmlmacro;

import com.sun.wts.tools.htmlmacro.HTMLOutput;
import com.sun.wts.tools.htmlmacro.JellyContextEx;
import com.sun.wts.tools.htmlmacro.TagLibraryImpl;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.XMLOutput;
import org.apache.commons.jelly.expression.ConstantExpression;
import org.apache.commons.jelly.impl.TagScript;
import org.apache.commons.jelly.tags.core.JellyTag;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlMacroTask
extends Task {
    private final Path classpath = new Path(null);
    private final List<File> tags = new ArrayList<File>();
    private boolean html = true;
    private List<FileSet> documents = new ArrayList<FileSet>();
    private File destdir;
    private String encoding = "us-ascii";
    private Map<String, String> properties = new HashMap<String, String>();

    public void setDestdir(File destdir) {
        this.destdir = destdir;
    }

    public void setClasspath(Path cp) {
        this.classpath.createPath().append(cp);
    }

    public Path createClasspath() {
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference r) {
        this.classpath.createPath().setRefid(r);
    }

    public void addConfiguredProperty(Environment.Variable v) {
        if (v.getKey() == null) {
            return;
        }
        this.properties.put(v.getKey(), v.getValue());
    }

    public void addConfiguredTags(FileSet fs) {
        this.populateFiles(fs, this.tags);
    }

    public void addConfiguredDocuments(FileSet fs) {
        this.documents.add(fs);
    }

    public void setXhtml(boolean value) {
        this.html = !value;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    private void populateFiles(FileSet fs, List<File> r) {
        DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
        String[] includedFiles = ds.getIncludedFiles();
        File baseDir = ds.getBasedir();
        for (String value : includedFiles) {
            r.add(new File(baseDir, value));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws BuildException {
        this.classpath.setProject(this.getProject());
        this.destdir.mkdirs();
        JellyContext context = this.html ? new JellyContextEx() : new JellyContext();
        context.getVariables().putAll(this.getProject().getProperties());
        context.getVariables().putAll(this.properties);
        context.getVariables().putAll(System.getProperties());
        context.setClassLoader(new AntClassLoader(this.getClass().getClassLoader(), this.getProject(), this.classpath, true));
        context.registerTagLibrary("", new TagLibraryImpl(this, context, this.tags));
        for (FileSet document : this.documents) {
            DirectoryScanner ds = document.getDirectoryScanner(this.getProject());
            String[] includedFiles = ds.getIncludedFiles();
            File baseDir = ds.getBasedir();
            try {
                for (String value : includedFiles) {
                    File src = new File(baseDir, value);
                    this.log("Processing " + src, 2);
                    context.getVariables().put("fileName", src.getName());
                    TagScript root = TagScript.newInstance(JellyTag.class);
                    Script child = context.compileScript(src.toURL());
                    root.setTagBody(child);
                    ((TagScript)child).setParent(root);
                    root.addAttribute("trim", new ConstantExpression(false));
                    Charset cs = Charset.defaultCharset();
                    FileOutputStream out = new FileOutputStream(new File(this.destdir, value));
                    try {
                        XMLOutput xo = HTMLOutput.create(out, this.encoding);
                        root.run(context, xo);
                        xo.close();
                    }
                    finally {
                        out.close();
                    }
                }
            }
            catch (JellyException e) {
                throw new BuildException(e);
            }
            catch (IOException e) {
                throw new BuildException(e);
            }
        }
    }
}

