/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jelly.parser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.EmptyStackException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.collections.ArrayStack;
import org.apache.commons.jelly.JellyContext;
import org.apache.commons.jelly.JellyException;
import org.apache.commons.jelly.Script;
import org.apache.commons.jelly.Tag;
import org.apache.commons.jelly.TagLibrary;
import org.apache.commons.jelly.expression.CompositeExpression;
import org.apache.commons.jelly.expression.ConstantExpression;
import org.apache.commons.jelly.expression.Expression;
import org.apache.commons.jelly.expression.ExpressionFactory;
import org.apache.commons.jelly.expression.jexl.JexlExpressionFactory;
import org.apache.commons.jelly.impl.CompositeTextScriptBlock;
import org.apache.commons.jelly.impl.ExpressionScript;
import org.apache.commons.jelly.impl.ScriptBlock;
import org.apache.commons.jelly.impl.StaticTag;
import org.apache.commons.jelly.impl.StaticTagScript;
import org.apache.commons.jelly.impl.TagFactory;
import org.apache.commons.jelly.impl.TagScript;
import org.apache.commons.jelly.impl.TextScript;
import org.apache.commons.jelly.parser.DefaultNamespaceFilter;
import org.apache.commons.jelly.util.ClassLoaderUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser
extends DefaultHandler {
    private static Properties jellyProperties;
    private JellyContext context = new JellyContext();
    private ExpressionFactory expressionFactory;
    private ScriptBlock script;
    private TagScript tagScript;
    private ArrayStack scriptStack = new ArrayStack();
    private ArrayList tagScriptStack = new ArrayList();
    private StringBuffer textBuffer;
    protected ClassLoader classLoader = null;
    protected boolean useContextClassLoader = false;
    protected ErrorHandler errorHandler = null;
    protected static SAXParserFactory factory;
    protected SAXParser parser = null;
    protected XMLReader reader = null;
    protected Locator locator = null;
    protected Map namespaces = new HashMap();
    private Map elementNamespaces;
    private String fileName;
    protected boolean validating = false;
    private boolean configured;
    private String defaultNamespaceURI = null;
    private Log log = LogFactory.getLog(class$org$apache$commons$jelly$parser$XMLParser == null ? (class$org$apache$commons$jelly$parser$XMLParser = XMLParser.class$("org.apache.commons.jelly.parser.XMLParser")) : class$org$apache$commons$jelly$parser$XMLParser);
    static /* synthetic */ Class class$org$apache$commons$jelly$parser$XMLParser;

    public XMLParser() {
    }

    public XMLParser(SAXParser parser) {
        this.parser = parser;
    }

    public XMLParser(XMLReader reader) {
        this.reader = reader;
    }

    public Script parse(File file) throws IOException, SAXException {
        return this.parse(file.toURL());
    }

    public Script parse(URL url) throws IOException, SAXException {
        this.ensureConfigured();
        this.fileName = url.toString();
        InputSource source = new InputSource(url.toString());
        this.getXMLReader().parse(source);
        return this.script;
    }

    public Script parse(InputSource input) throws IOException, SAXException {
        this.ensureConfigured();
        this.fileName = input.getSystemId();
        this.getXMLReader().parse(input);
        return this.script;
    }

    public Script parse(InputStream input) throws IOException, SAXException {
        this.ensureConfigured();
        this.fileName = this.getCurrentURI();
        this.getXMLReader().parse(new InputSource(input));
        return this.script;
    }

    public Script parse(Reader reader) throws IOException, SAXException {
        this.ensureConfigured();
        this.fileName = this.getCurrentURI();
        this.getXMLReader().parse(new InputSource(reader));
        return this.script;
    }

    public Script parse(String uri) throws IOException, SAXException {
        this.ensureConfigured();
        this.fileName = uri;
        this.getXMLReader().parse(uri);
        return this.script;
    }

    public String findNamespaceURI(String prefix) {
        ArrayStack stack = (ArrayStack)this.namespaces.get(prefix);
        if (stack == null) {
            return null;
        }
        try {
            return (String)stack.peek();
        }
        catch (EmptyStackException e) {
            return null;
        }
    }

    public JellyContext getContext() {
        return this.context;
    }

    public void setContext(JellyContext context) {
        this.context = context;
    }

    public void setDefaultNamespaceURI(String namespace) {
        this.defaultNamespaceURI = namespace;
    }

    public ClassLoader getClassLoader() {
        return ClassLoaderUtils.getClassLoader(this.classLoader, this.useContextClassLoader, this.getClass());
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean getUseContextClassLoader() {
        return this.useContextClassLoader;
    }

    public void setUseContextClassLoader(boolean use) {
        this.useContextClassLoader = use;
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public Log getLogger() {
        return this.log;
    }

    public void setLogger(Log log) {
        this.log = log;
    }

    public ExpressionFactory getExpressionFactory() {
        if (this.expressionFactory == null) {
            this.expressionFactory = this.createExpressionFactory();
        }
        return this.expressionFactory;
    }

    public void setExpressionFactory(ExpressionFactory expressionFactory) {
        this.expressionFactory = expressionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SAXParser getParser() {
        if (this.parser != null) {
            return this.parser;
        }
        XMLParser xMLParser = this;
        synchronized (xMLParser) {
            try {
                if (factory == null) {
                    factory = SAXParserFactory.newInstance();
                }
                factory.setNamespaceAware(true);
                factory.setValidating(this.validating);
                this.parser = factory.newSAXParser();
                return this.parser;
            }
            catch (Exception e) {
                this.log.error("XMLParser.getParser: ", e);
                return null;
            }
        }
    }

    public XMLReader getReader() {
        try {
            return this.getXMLReader();
        }
        catch (SAXException e) {
            this.log.error("Cannot get XMLReader", e);
            return null;
        }
    }

    public synchronized XMLReader getXMLReader() throws SAXException {
        if (this.reader == null) {
            this.reader = this.getParser().getXMLReader();
            if (this.defaultNamespaceURI != null) {
                this.reader = new DefaultNamespaceFilter(this.defaultNamespaceURI, this.reader);
            }
        }
        this.reader.setContentHandler(this);
        this.reader.setDTDHandler(this);
        this.reader.setErrorHandler(this);
        return this.reader;
    }

    public boolean getValidating() {
        return this.validating;
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public ScriptBlock getScript() {
        return this.script;
    }

    public void startDocument() throws SAXException {
        this.script = new ScriptBlock();
        this.textBuffer = new StringBuffer();
        this.tagScript = null;
        this.scriptStack.clear();
        this.tagScriptStack.clear();
    }

    public void endDocument() throws SAXException {
        this.textBuffer = null;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes list) throws SAXException {
        try {
            TagScript newTagScript;
            if (namespaceURI == null) {
                namespaceURI = "";
            }
            if ((newTagScript = this.createTag(namespaceURI, localName, list)) == null) {
                newTagScript = this.createStaticTag(namespaceURI, localName, qName, list);
            }
            this.tagScript = newTagScript;
            this.tagScriptStack.add(this.tagScript);
            if (this.tagScript != null) {
                if (this.locator != null) {
                    this.tagScript.setLocator(this.locator);
                }
                this.tagScript.setFileName(this.fileName);
                this.tagScript.setElementName(qName);
                this.tagScript.setLocalName(localName);
                if (this.textBuffer.length() > 0) {
                    this.addTextScript(this.textBuffer.toString());
                    this.textBuffer.setLength(0);
                }
                this.script.addScript(this.tagScript);
                this.scriptStack.push(this.script);
                this.script = new ScriptBlock();
                this.tagScript.setTagBody(this.script);
            } else {
                this.textBuffer.append("<");
                this.textBuffer.append(qName);
                int size = list.getLength();
                for (int i = 0; i < size; ++i) {
                    this.textBuffer.append(" ");
                    this.textBuffer.append(list.getQName(i));
                    this.textBuffer.append("=");
                    this.textBuffer.append("\"");
                    this.textBuffer.append(list.getValue(i));
                    this.textBuffer.append("\"");
                }
                this.textBuffer.append(">");
            }
        }
        catch (SAXException e) {
            throw e;
        }
        catch (Exception e) {
            this.log.error("Caught exception: " + e, e);
            throw new SAXException("Runtime Exception: " + e, e);
        }
    }

    public void characters(char[] buffer, int start, int length) throws SAXException {
        this.textBuffer.append(buffer, start, length);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            this.tagScript = (TagScript)this.tagScriptStack.remove(this.tagScriptStack.size() - 1);
            if (this.tagScript != null) {
                if (this.textBuffer.length() > 0) {
                    this.addTextScript(this.textBuffer.toString());
                    this.textBuffer.setLength(0);
                }
                this.script = (ScriptBlock)this.scriptStack.pop();
            } else {
                this.textBuffer.append("</");
                this.textBuffer.append(qName);
                this.textBuffer.append(">");
            }
            this.tagScript = this.tagScriptStack.isEmpty() ? null : (TagScript)this.tagScriptStack.get(this.tagScriptStack.size() - 1);
        }
        catch (Exception e) {
            this.log.error("Caught exception: " + e, e);
            throw new SAXException("Runtime Exception: " + e, e);
        }
    }

    public void startPrefixMapping(String prefix, String namespaceURI) throws SAXException {
        ArrayStack stack = (ArrayStack)this.namespaces.get(prefix);
        if (stack == null) {
            stack = new ArrayStack();
            this.namespaces.put(prefix, stack);
        }
        stack.push(namespaceURI);
        if (this.elementNamespaces == null) {
            this.elementNamespaces = new HashMap();
        }
        this.elementNamespaces.put(prefix, namespaceURI);
    }

    public void endPrefixMapping(String prefix) throws SAXException {
        ArrayStack stack = (ArrayStack)this.namespaces.get(prefix);
        if (stack == null) {
            return;
        }
        try {
            stack.pop();
            if (stack.empty()) {
                this.namespaces.remove(prefix);
            }
        }
        catch (EmptyStackException e) {
            throw this.createSAXException("endPrefixMapping popped too many times");
        }
    }

    public void ignorableWhitespace(char[] buffer, int start, int len) throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void notationDecl(String name, String publicId, String systemId) {
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notation) {
    }

    public void error(SAXParseException exception) throws SAXException {
        this.log.error("Parse Error at line " + exception.getLineNumber() + " column " + exception.getColumnNumber() + ": " + exception.getMessage(), exception);
        if (this.errorHandler == null) {
            throw exception;
        }
        this.errorHandler.error(exception);
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        this.log.error("Parse Fatal Error at line " + exception.getLineNumber() + " column " + exception.getColumnNumber() + ": " + exception.getMessage(), exception);
        if (this.errorHandler == null) {
            throw exception;
        }
        this.errorHandler.fatalError(exception);
    }

    public void warning(SAXParseException exception) throws SAXException {
        this.log.error("Parse Warning at line " + exception.getLineNumber() + " column " + exception.getColumnNumber() + ": " + exception.getMessage(), exception);
        if (this.errorHandler != null) {
            this.errorHandler.warning(exception);
        }
    }

    private void ensureConfigured() {
        if (!this.configured) {
            this.configure();
            this.configured = true;
        }
    }

    protected void configure() {
        Properties properties = this.getJellyProperties();
        Iterator<Map.Entry<Object, Object>> iter = properties.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> entry = iter.next();
            String uri = (String)entry.getKey();
            String className = (String)entry.getValue();
            String libraryURI = "jelly:" + uri;
            if (this.context.isTagLibraryRegistered(libraryURI)) continue;
            this.context.registerTagLibrary(libraryURI, className);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Properties getJellyProperties() {
        if (jellyProperties == null) {
            jellyProperties = new Properties();
            InputStream in = null;
            URL url = this.getClassLoader().getResource("org/apache/commons/jelly/jelly.properties");
            if (url != null) {
                this.log.debug("Loading Jelly default tag libraries from: " + url);
                try {
                    in = url.openStream();
                    jellyProperties.load(in);
                }
                catch (IOException e) {
                    this.log.error("Could not load jelly properties from: " + url + ". Reason: " + e, e);
                }
                finally {
                    block14: {
                        try {
                            in.close();
                        }
                        catch (Exception e) {
                            if (!this.log.isDebugEnabled()) break block14;
                            this.log.debug("error closing jelly.properties", e);
                        }
                    }
                }
            }
        }
        return jellyProperties;
    }

    protected TagScript createTag(String namespaceURI, String localName, Attributes list) throws SAXException {
        try {
            TagLibrary taglib = this.context.getTagLibrary(namespaceURI);
            if (taglib == null && namespaceURI != null && namespaceURI.startsWith("jelly:")) {
                String uri = namespaceURI.substring(6);
                try {
                    Class<?> taglibClass = this.getClassLoader().loadClass(uri);
                    taglib = (TagLibrary)taglibClass.newInstance();
                    this.context.registerTagLibrary(namespaceURI, taglib);
                }
                catch (ClassNotFoundException e) {
                    throw this.createSAXException("Could not load class: " + uri + " so taglib instantiation failed", e);
                }
                catch (IllegalAccessException e) {
                    throw this.createSAXException("Constructor for class is not accessible: " + uri + " so taglib instantiation failed", e);
                }
                catch (InstantiationException e) {
                    throw this.createSAXException("Class could not be instantiated: " + uri + " so taglib instantiation failed", e);
                }
                catch (ClassCastException e) {
                    throw this.createSAXException("Class is not a TagLibrary: " + uri + " so taglib instantiation failed", e);
                }
            }
            if (taglib != null) {
                TagScript script = taglib.createTagScript(localName, list);
                if (script != null) {
                    this.configureTagScript(script);
                    script.setSaxAttributes(new AttributesImpl(list));
                    int size = list.getLength();
                    for (int i = 0; i < size; ++i) {
                        String attributeName = list.getLocalName(i);
                        String attributeValue = list.getValue(i);
                        Expression expression = taglib.createExpression(this.getExpressionFactory(), script, attributeName, attributeValue);
                        if (expression == null) {
                            expression = this.createConstantExpression(localName, attributeName, attributeValue);
                        }
                        script.addAttribute(attributeName, expression);
                    }
                }
                return script;
            }
            return null;
        }
        catch (Exception e) {
            this.log.warn("Could not create taglib or URI: " + namespaceURI + " tag name: " + localName, e);
            throw this.createSAXException(e);
        }
    }

    protected TagScript createStaticTag(final String namespaceURI, final String localName, final String qName, Attributes list) throws SAXException {
        try {
            StaticTag tag = new StaticTag(namespaceURI, localName, qName);
            StaticTagScript script = new StaticTagScript(new TagFactory(){

                public Tag createTag(String name, Attributes attributes) {
                    return new StaticTag(namespaceURI, localName, qName);
                }
            });
            this.configureTagScript(script);
            int size = list.getLength();
            for (int i = 0; i < size; ++i) {
                String attributeValue = list.getValue(i);
                Expression expression = CompositeExpression.parse(attributeValue, this.getExpressionFactory());
                String attrQName = list.getQName(i);
                script.addAttribute(attrQName, expression);
            }
            return script;
        }
        catch (Exception e) {
            this.log.warn("Could not create static tag for URI: " + namespaceURI + " tag name: " + localName, e);
            throw this.createSAXException(e);
        }
    }

    protected void configureTagScript(TagScript aTagScript) {
        aTagScript.setParent(this.tagScript);
        if (this.elementNamespaces != null) {
            aTagScript.setTagNamespacesMap(this.elementNamespaces);
            this.elementNamespaces = null;
        }
    }

    protected void addTextScript(String text) throws JellyException {
        Expression expression = CompositeExpression.parse(text, this.getExpressionFactory());
        this.addExpressionScript(this.script, expression);
    }

    protected void addExpressionScript(ScriptBlock script, Expression expression) {
        if (expression instanceof ConstantExpression) {
            ConstantExpression constantExpression = (ConstantExpression)expression;
            Object value = constantExpression.getValue();
            if (value != null) {
                script.addScript(new TextScript(value.toString()));
            }
        } else if (expression instanceof CompositeExpression) {
            CompositeTextScriptBlock newBlock = new CompositeTextScriptBlock();
            script.addScript(newBlock);
            CompositeExpression compositeExpression = (CompositeExpression)expression;
            Iterator iter = compositeExpression.getExpressions().iterator();
            while (iter.hasNext()) {
                this.addExpressionScript(newBlock, (Expression)iter.next());
            }
        } else {
            script.addScript(new ExpressionScript(expression));
        }
    }

    protected Expression createConstantExpression(String tagName, String attributeName, String attributeValue) {
        return new ConstantExpression(attributeValue);
    }

    protected ExpressionFactory createExpressionFactory() {
        return new JexlExpressionFactory();
    }

    protected String getCurrentURI() {
        URL url = this.getContext().getCurrentURL();
        return url != null ? url.toString() : null;
    }

    protected SAXException createSAXException(String message, Exception e) {
        this.log.warn("Underlying exception: " + e);
        e.printStackTrace();
        if (this.locator != null) {
            String error = "Error at (" + this.locator.getLineNumber() + ", " + this.locator.getColumnNumber() + "): " + message;
            if (e != null) {
                return new SAXParseException(error, this.locator, e);
            }
            return new SAXParseException(error, this.locator);
        }
        this.log.error("No Locator!");
        if (e != null) {
            return new SAXException(message, e);
        }
        return new SAXException(message);
    }

    protected SAXException createSAXException(Exception e) {
        return this.createSAXException(e.getMessage(), e);
    }

    protected SAXException createSAXException(String message) {
        return this.createSAXException(message, null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        factory = null;
    }
}

