/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl.util.introspection;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.jexl.util.AbstractExecutor;
import org.apache.commons.jexl.util.ArrayIterator;
import org.apache.commons.jexl.util.BooleanPropertyExecutor;
import org.apache.commons.jexl.util.EnumerationIterator;
import org.apache.commons.jexl.util.GetExecutor;
import org.apache.commons.jexl.util.PropertyExecutor;
import org.apache.commons.jexl.util.introspection.Info;
import org.apache.commons.jexl.util.introspection.Introspector;
import org.apache.commons.jexl.util.introspection.Uberspect;
import org.apache.commons.jexl.util.introspection.UberspectLoggable;
import org.apache.commons.jexl.util.introspection.VelMethod;
import org.apache.commons.jexl.util.introspection.VelPropertyGet;
import org.apache.commons.jexl.util.introspection.VelPropertySet;
import org.apache.commons.logging.Log;

public class UberspectImpl
implements Uberspect,
UberspectLoggable {
    private Log rlog;
    private static Introspector introspector;
    static /* synthetic */ Class class$0;

    public void init() throws Exception {
    }

    public void setRuntimeLogger(Log runtimeLogger) {
        this.rlog = runtimeLogger;
        introspector = new Introspector(this.rlog);
    }

    public Iterator getIterator(Object obj, Info i) throws Exception {
        if (obj.getClass().isArray()) {
            return new ArrayIterator(obj);
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).iterator();
        }
        if (obj instanceof Map) {
            return ((Map)obj).values().iterator();
        }
        if (obj instanceof Iterator) {
            this.rlog.warn("Warning! The iterative  is an Iterator in the #foreach() loop at [" + i.getLine() + "," + i.getColumn() + "]" + " in template " + i.getTemplateName() + ". Because it's not resetable," + " if used in more than once, this may lead to" + " unexpected results.");
            return (Iterator)obj;
        }
        if (obj instanceof Enumeration) {
            this.rlog.warn("Warning! The iterative  is an Enumeration in the #foreach() loop at [" + i.getLine() + "," + i.getColumn() + "]" + " in template " + i.getTemplateName() + ". Because it's not resetable," + " if used in more than once, this may lead to" + " unexpected results.");
            return new EnumerationIterator((Enumeration)obj);
        }
        this.rlog.warn("Could not determine type of iterator in #foreach loop  at [" + i.getLine() + "," + i.getColumn() + "]" + " in template " + i.getTemplateName());
        return null;
    }

    public VelMethod getMethod(Object obj, String methodName, Object[] args, Info i) throws Exception {
        if (obj == null) {
            return null;
        }
        Method m = introspector.getMethod(obj.getClass(), methodName, args);
        return m != null ? new VelMethodImpl(m) : null;
    }

    public VelPropertyGet getPropertyGet(Object obj, String identifier, Info i) throws Exception {
        Class<?> claz = obj.getClass();
        AbstractExecutor executor = new PropertyExecutor(this.rlog, introspector, claz, identifier);
        if (!executor.isAlive()) {
            executor = new BooleanPropertyExecutor(this.rlog, introspector, claz, identifier);
        }
        if (!executor.isAlive()) {
            executor = new GetExecutor(this.rlog, introspector, claz, identifier);
        }
        return executor != null ? new VelGetterImpl(executor) : null;
    }

    public VelPropertySet getPropertySet(Object obj, String identifier, Object arg, Info i) throws Exception {
        VelMethod vm;
        block11: {
            Class<?> claz = obj.getClass();
            vm = null;
            try {
                Object[] params = new Object[]{arg};
                try {
                    vm = this.getMethod(obj, "set" + identifier, params, i);
                    if (vm == null) {
                        throw new NoSuchMethodException();
                    }
                }
                catch (NoSuchMethodException nsme2) {
                    StringBuffer sb = new StringBuffer("set");
                    sb.append(identifier);
                    if (Character.isLowerCase(sb.charAt(3))) {
                        sb.setCharAt(3, Character.toUpperCase(sb.charAt(3)));
                    } else {
                        sb.setCharAt(3, Character.toLowerCase(sb.charAt(3)));
                    }
                    vm = this.getMethod(obj, sb.toString(), params, i);
                    if (vm == null) {
                        throw new NoSuchMethodException();
                    }
                }
            }
            catch (NoSuchMethodException nsme) {
                Object[] params;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.util.Map");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (!clazz.isAssignableFrom(claz) || (vm = this.getMethod(obj, "put", params = new Object[]{new Object(), new Object()}, i)) == null) break block11;
                return new VelSetterImpl(vm, identifier);
            }
        }
        return vm != null ? new VelSetterImpl(vm) : null;
    }

    public class VelMethodImpl
    implements VelMethod {
        Method method = null;

        public VelMethodImpl(Method m) {
            this.method = m;
        }

        private VelMethodImpl() {
        }

        public Object invoke(Object o, Object[] params) throws Exception {
            try {
                return this.method.invoke(o, params);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw e;
            }
        }

        public boolean isCacheable() {
            return true;
        }

        public String getMethodName() {
            return this.method.getName();
        }

        public Class getReturnType() {
            return this.method.getReturnType();
        }
    }

    public class VelGetterImpl
    implements VelPropertyGet {
        AbstractExecutor ae = null;

        public VelGetterImpl(AbstractExecutor exec) {
            this.ae = exec;
        }

        private VelGetterImpl() {
        }

        public Object invoke(Object o) throws Exception {
            return this.ae.execute(o);
        }

        public boolean isCacheable() {
            return true;
        }

        public String getMethodName() {
            return this.ae.getMethod().getName();
        }
    }

    public class VelSetterImpl
    implements VelPropertySet {
        VelMethod vm = null;
        String putKey = null;

        public VelSetterImpl(VelMethod velmethod) {
            this.vm = velmethod;
        }

        public VelSetterImpl(VelMethod velmethod, String key) {
            this.vm = velmethod;
            this.putKey = key;
        }

        private VelSetterImpl() {
        }

        public Object invoke(Object o, Object value) throws Exception {
            ArrayList<Object> al = new ArrayList<Object>();
            if (this.putKey != null) {
                al.add(this.putKey);
                al.add(value);
            } else {
                al.add(value);
            }
            return this.vm.invoke(o, al.toArray());
        }

        public boolean isCacheable() {
            return true;
        }

        public String getMethodName() {
            return this.vm.getMethodName();
        }
    }
}

