/*
 * Decompiled with CFR 0.152.
 */
package org.kohsuke.soimp;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.taskdefs.Delete;
import org.apache.tools.ant.types.FileSet;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.kohsuke.soimp.Listener;
import org.kohsuke.soimp.Mode;
import org.kohsuke.soimp.Proc;
import org.kohsuke.soimp.ProcessingException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Soimp
extends Task {
    @Argument
    List<String> pathArgs = new ArrayList<String>();
    private File wsDir;
    private String remoteURL;
    @Option(name="-x", usage="specifies the svn command executable to run")
    String svn = "svn";
    @Option(name="-m", usage="specifies the commit message")
    String commitMessage = "imported by soimp";
    @Option(name="-p", usage="create the repository by 'svn mkdir' if necessary")
    boolean create = false;
    private Listener listener = Listener.CONSOLE;

    public static void main(String[] args) throws IOException, ProcessingException {
        System.exit(new Soimp().runCLI(args));
    }

    public void setSvn(String svn) {
        this.svn = svn;
    }

    public void setCommitMessage(String commitMessage) {
        this.commitMessage = commitMessage;
    }

    public void setCreate(boolean create) {
        this.create = create;
    }

    public void setDir(File dir) {
        this.wsDir = dir;
    }

    public void setRepository(String repository) {
        this.remoteURL = repository;
    }

    public int runCLI(String[] args) throws IOException, ProcessingException {
        CmdLineParser p = new CmdLineParser(this);
        try {
            p.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            this.printUsage(p);
            return -1;
        }
        if (this.pathArgs.size() > 2 || this.pathArgs.isEmpty()) {
            this.printUsage(p);
            return -1;
        }
        File src = new File(this.pathArgs.get(0));
        if (!src.exists()) {
            System.err.println("No such directory " + src);
            return -1;
        }
        if (this.pathArgs.size() == 1) {
            this.svnUpdate(src);
        } else {
            this.svnImport(src, this.pathArgs.get(1));
        }
        return 0;
    }

    @Override
    public void execute() throws BuildException {
        String svnExe = this.getProject().getProperty("svn.executable");
        if (svnExe != null) {
            this.svn = svnExe;
        }
        this.listener = new Listener(){

            public void info(String line) {
                Soimp.this.log(line, 2);
            }
        };
        if (this.wsDir == null) {
            throw new BuildException("Required @dir is missing");
        }
        if (!this.wsDir.exists()) {
            throw new BuildException("No such directory " + this.wsDir);
        }
        try {
            if (this.remoteURL == null) {
                this.svnUpdate(this.wsDir);
            } else {
                this.svnImport(this.wsDir, this.remoteURL);
            }
        }
        catch (ProcessingException e) {
            throw new BuildException(e);
        }
        catch (IOException e) {
            throw new BuildException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void svnImport(File src, String repository) throws IOException, ProcessingException {
        File tmp = File.createTempFile("soimp", "tmp");
        tmp.delete();
        tmp.mkdir();
        this.listener.info("Using " + tmp);
        Project p = new Project();
        try {
            if (this.create) {
                this.createRepository(new URL(repository));
            }
            this.exec(this.svn + " co " + repository + " .", tmp, "failed to check out");
            FileSet fs = new FileSet();
            fs.setProject(p);
            fs.setDir(src);
            Copy cpTask = new Copy();
            cpTask.setProject(p);
            cpTask.setOverwrite(true);
            cpTask.setTodir(tmp);
            cpTask.addFileset(fs);
            cpTask.execute();
            this.svnUpdate(tmp);
            this.exec(this.svn + " commit -m \"" + this.commitMessage + "\"", tmp, "Failed to commit");
        }
        finally {
            Delete delTask = new Delete();
            delTask.setProject(p);
            delTask.setDir(tmp);
            delTask.execute();
        }
    }

    private void createRepository(URL repository) throws IOException, ProcessingException {
        if (repository.getPath().equals("/")) {
            throw new ProcessingException("Illegal repository name");
        }
        try {
            this.exec(this.svn + " proplist " + repository, new File("."), "N/A");
        }
        catch (ProcessingException e) {
            URL parent = repository.getPath().endsWith("/") ? new URL(repository, "..") : new URL(repository, ".");
            this.createRepository(parent);
            this.listener.info(repository + " doesn't exist. creating");
            this.exec(this.svn + " mkdir -m \"" + this.commitMessage + "\" " + repository, new File("."), "Failed to create directory");
        }
    }

    private void printUsage(CmdLineParser p) {
        System.err.println("Usage: soimp [options ...] <PATH> <URL>");
        System.err.println("Works like 'svn import PATH URL', but overwrites remote files by local files.");
        p.printUsage(System.err);
    }

    public void svnUpdate(File ws) throws ProcessingException, IOException {
        String line;
        String log = this.exec(this.svn + " status", ws, "Failed to stat the workspace");
        ArrayList<String> newFiles = new ArrayList<String>();
        ArrayList<String> deletedFiles = new ArrayList<String>();
        BufferedReader in = new BufferedReader(new StringReader(log));
        while ((line = in.readLine()) != null) {
            Mode m = Mode.parse(line.charAt(0));
            String file = line.substring(1).trim();
            if (m == null) continue;
            switch (m) {
                case NEW: {
                    newFiles.add(file);
                    break;
                }
                case DELETED: {
                    deletedFiles.add(file);
                }
            }
        }
        this.runSvnBatch("add", ws, newFiles);
        this.runSvnBatch("remove", ws, deletedFiles);
    }

    private void runSvnBatch(String subCmd, File ws, List<String> files) throws IOException, ProcessingException {
        while (!files.isEmpty()) {
            StringBuilder cmd = new StringBuilder(this.svn + ' ' + subCmd);
            for (int i = 0; i < 20 && !files.isEmpty(); ++i) {
                cmd.append(' ').append(files.remove(0));
            }
            this.exec(cmd.toString(), ws, "Failed to " + subCmd);
        }
    }

    private String exec(String cmd, File ws, String errorMessage) throws IOException, ProcessingException {
        this.listener.info("Executing: " + cmd);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int r = new Proc(cmd, null, (OutputStream)baos, ws).join();
        if (r != 0) {
            this.listener.info(baos.toString());
            throw new ProcessingException(errorMessage);
        }
        return baos.toString();
    }
}

