/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd;

import com.thaiopensource.datatype.xsd.DatatypeBase;
import com.thaiopensource.datatype.xsd.DatatypeLibraryImpl;
import com.thaiopensource.datatype.xsd.DecimalDatatype;
import com.thaiopensource.datatype.xsd.LengthRestrictDatatype;
import com.thaiopensource.datatype.xsd.MaxExclusiveRestrictDatatype;
import com.thaiopensource.datatype.xsd.MaxInclusiveRestrictDatatype;
import com.thaiopensource.datatype.xsd.MaxLengthRestrictDatatype;
import com.thaiopensource.datatype.xsd.MinExclusiveRestrictDatatype;
import com.thaiopensource.datatype.xsd.MinInclusiveRestrictDatatype;
import com.thaiopensource.datatype.xsd.MinLengthRestrictDatatype;
import com.thaiopensource.datatype.xsd.PatternRestrictDatatype;
import com.thaiopensource.datatype.xsd.PrecisionRestrictDatatype;
import com.thaiopensource.datatype.xsd.ScaleRestrictDatatype;
import com.thaiopensource.datatype.xsd.regex.RegexSyntaxException;
import com.thaiopensource.util.Localizer;
import org.relaxng.datatype.Datatype;
import org.relaxng.datatype.DatatypeBuilder;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

class DatatypeBuilderImpl
implements DatatypeBuilder {
    static final Localizer localizer = new Localizer(class$com$thaiopensource$datatype$xsd$DatatypeBuilderImpl == null ? (class$com$thaiopensource$datatype$xsd$DatatypeBuilderImpl = DatatypeBuilderImpl.class$("com.thaiopensource.datatype.xsd.DatatypeBuilderImpl")) : class$com$thaiopensource$datatype$xsd$DatatypeBuilderImpl);
    private DatatypeBase base;
    private final DatatypeLibraryImpl library;
    static /* synthetic */ Class class$com$thaiopensource$datatype$xsd$DatatypeBuilderImpl;

    DatatypeBuilderImpl(DatatypeLibraryImpl library, DatatypeBase base) throws DatatypeException {
        this.library = library;
        this.base = base;
    }

    public void addParameter(String name, String value, ValidationContext context) throws DatatypeException {
        if (name.equals("pattern")) {
            this.addPatternParam(value);
        } else if (name.equals("minInclusive")) {
            this.addMinInclusiveParam(value, context);
        } else if (name.equals("maxInclusive")) {
            this.addMaxInclusiveParam(value, context);
        } else if (name.equals("minExclusive")) {
            this.addMinExclusiveParam(value, context);
        } else if (name.equals("maxExclusive")) {
            this.addMaxExclusiveParam(value, context);
        } else if (name.equals("length")) {
            this.addLengthParam(value);
        } else if (name.equals("minLength")) {
            this.addMinLengthParam(value);
        } else if (name.equals("maxLength")) {
            this.addMaxLengthParam(value);
        } else if (name.equals("fractionDigits")) {
            this.addScaleParam(value);
        } else if (name.equals("totalDigits")) {
            this.addPrecisionParam(value);
        } else if (name.equals("enumeration")) {
            DatatypeBuilderImpl.error("enumeration_param");
        } else if (name.equals("whiteSpace")) {
            DatatypeBuilderImpl.error("whiteSpace_param");
        } else {
            DatatypeBuilderImpl.error("unrecognized_param", name);
        }
    }

    private void addPatternParam(String value) throws DatatypeException {
        try {
            this.base = new PatternRestrictDatatype(this.base, this.library.getRegexEngine().compile(value));
        }
        catch (RegexSyntaxException e) {
            int pos = e.getPosition();
            if (pos == -1) {
                pos = -1;
            }
            DatatypeBuilderImpl.error("invalid_regex", e.getMessage(), pos);
        }
    }

    private void addMinInclusiveParam(String value, ValidationContext context) throws DatatypeException {
        this.base = new MinInclusiveRestrictDatatype(this.base, this.getLimit(value, context));
    }

    private void addMaxInclusiveParam(String value, ValidationContext context) throws DatatypeException {
        this.base = new MaxInclusiveRestrictDatatype(this.base, this.getLimit(value, context));
    }

    private void addMinExclusiveParam(String value, ValidationContext context) throws DatatypeException {
        this.base = new MinExclusiveRestrictDatatype(this.base, this.getLimit(value, context));
    }

    private void addMaxExclusiveParam(String value, ValidationContext context) throws DatatypeException {
        this.base = new MaxExclusiveRestrictDatatype(this.base, this.getLimit(value, context));
    }

    private Object getLimit(String str, ValidationContext context) throws DatatypeException {
        Object value;
        if (this.base.getOrderRelation() == null) {
            DatatypeBuilderImpl.error("not_ordered");
        }
        if ((value = this.base.createValue(str, context)) == null) {
            DatatypeBuilderImpl.error("invalid_limit", str);
        }
        return value;
    }

    private void addLengthParam(String value) throws DatatypeException {
        this.base = new LengthRestrictDatatype(this.base, this.getLength(value));
    }

    private void addMinLengthParam(String value) throws DatatypeException {
        this.base = new MinLengthRestrictDatatype(this.base, this.getLength(value));
    }

    private void addMaxLengthParam(String value) throws DatatypeException {
        this.base = new MaxLengthRestrictDatatype(this.base, this.getLength(value));
    }

    private int getLength(String str) throws DatatypeException {
        int len;
        if (this.base.getMeasure() == null) {
            DatatypeBuilderImpl.error("no_length");
        }
        if ((len = this.convertNonNegativeInteger(str)) < 0) {
            DatatypeBuilderImpl.error("value_not_non_negative_integer");
        }
        return len;
    }

    private void addScaleParam(String str) throws DatatypeException {
        int scale;
        if (!(this.base.getPrimitive() instanceof DecimalDatatype)) {
            DatatypeBuilderImpl.error("scale_not_derived_from_decimal");
        }
        if ((scale = this.convertNonNegativeInteger(str)) < 0) {
            DatatypeBuilderImpl.error("value_not_non_negative_integer");
        }
        this.base = new ScaleRestrictDatatype(this.base, scale);
    }

    private void addPrecisionParam(String str) throws DatatypeException {
        int scale;
        if (!(this.base.getPrimitive() instanceof DecimalDatatype)) {
            DatatypeBuilderImpl.error("precision_not_derived_from_decimal");
        }
        if ((scale = this.convertNonNegativeInteger(str)) <= 0) {
            DatatypeBuilderImpl.error("value_not_positive_integer");
        }
        this.base = new PrecisionRestrictDatatype(this.base, scale);
    }

    public Datatype createDatatype() {
        return this.base;
    }

    private static void error(String key) throws DatatypeException {
        throw new DatatypeException(localizer.message(key));
    }

    private static void error(String key, String arg) throws DatatypeException {
        throw new DatatypeException(localizer.message(key, arg));
    }

    private static void error(String key, String arg, int pos) throws DatatypeException {
        throw new DatatypeException(pos, localizer.message(key, arg));
    }

    private int convertNonNegativeInteger(String str) {
        DecimalDatatype decimal = new DecimalDatatype();
        if (!decimal.lexicallyAllows(str = str.trim())) {
            return -1;
        }
        if ((str = decimal.getValue(str, null).toString()).charAt(0) == '-' || str.indexOf(46) >= 0) {
            return -1;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            return Integer.MAX_VALUE;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

