/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.datatype.xsd.regex.jdk1_4;

import com.thaiopensource.datatype.xsd.regex.RegexSyntaxException;
import com.thaiopensource.datatype.xsd.regex.jdk1_4.Categories;
import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.Utf16;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class Translator {
    private final String regExp;
    private int pos = 0;
    private final int length;
    private char curChar;
    private boolean eos = false;
    private final StringBuffer result = new StringBuffer();
    private static final String categories = "LMNPZSC";
    private static final CharClass[] categoryCharClasses = new CharClass["LMNPZSC".length()];
    private static final String subCategories = "LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn";
    private static final CharClass[] subCategoryCharClasses = new CharClass["LuLlLtLmLoMnMcMeNdNlNoPcPdPsPePiPfPoZsZlZpSmScSkSoCcCfCoCn".length() / 2];
    private static final int NONBMP_MIN = 65536;
    private static final int NONBMP_MAX = 0x10FFFF;
    private static final char SURROGATE2_MIN = '\udc00';
    private static final char SURROGATE2_MAX = '\udfff';
    static final Localizer localizer = new Localizer(class$com$thaiopensource$datatype$xsd$regex$jdk1_4$Translator == null ? (class$com$thaiopensource$datatype$xsd$regex$jdk1_4$Translator = Translator.class$("com.thaiopensource.datatype.xsd.regex.jdk1_4.Translator")) : class$com$thaiopensource$datatype$xsd$regex$jdk1_4$Translator);
    private static final String[] blockNames = new String[]{"BasicLatin", "Latin-1Supplement", "LatinExtended-A", "LatinExtended-B", "IPAExtensions", "SpacingModifierLetters", "CombiningDiacriticalMarks", "Greek", "Cyrillic", "Armenian", "Hebrew", "Arabic", "Syriac", "Thaana", "Devanagari", "Bengali", "Gurmukhi", "Gujarati", "Oriya", "Tamil", "Telugu", "Kannada", "Malayalam", "Sinhala", "Thai", "Lao", "Tibetan", "Myanmar", "Georgian", "HangulJamo", "Ethiopic", "Cherokee", "UnifiedCanadianAboriginalSyllabics", "Ogham", "Runic", "Khmer", "Mongolian", "LatinExtendedAdditional", "GreekExtended", "GeneralPunctuation", "SuperscriptsandSubscripts", "CurrencySymbols", "CombiningMarksforSymbols", "LetterlikeSymbols", "NumberForms", "Arrows", "MathematicalOperators", "MiscellaneousTechnical", "ControlPictures", "OpticalCharacterRecognition", "EnclosedAlphanumerics", "BoxDrawing", "BlockElements", "GeometricShapes", "MiscellaneousSymbols", "Dingbats", "BraillePatterns", "CJKRadicalsSupplement", "KangxiRadicals", "IdeographicDescriptionCharacters", "CJKSymbolsandPunctuation", "Hiragana", "Katakana", "Bopomofo", "HangulCompatibilityJamo", "Kanbun", "BopomofoExtended", "EnclosedCJKLettersandMonths", "CJKCompatibility", "CJKUnifiedIdeographsExtensionA", "CJKUnifiedIdeographs", "YiSyllables", "YiRadicals", "HangulSyllables", "CJKCompatibilityIdeographs", "AlphabeticPresentationForms", "ArabicPresentationForms-A", "CombiningHalfMarks", "CJKCompatibilityForms", "SmallFormVariants", "ArabicPresentationForms-B", "Specials", "HalfwidthandFullwidthForms", "Specials"};
    private static final String[] specialBlockNames = new String[]{"OldItalic", "Gothic", "Deseret", "ByzantineMusicalSymbols", "MusicalSymbols", "MathematicalAlphanumericSymbols", "CJKUnifiedIdeographsExtensionB", "CJKCompatibilityIdeographsSupplement", "Tags", "PrivateUse", "HighSurrogates", "HighPrivateUseSurrogates", "LowSurrogates"};
    private static final CharClass[] specialBlockCharClasses = new CharClass[]{new CharRange(66304, 66351), new CharRange(66352, 66383), new CharRange(66560, 66639), new CharRange(118784, 119039), new CharRange(119040, 119295), new CharRange(119808, 120831), new CharRange(131072, 173782), new CharRange(194560, 195103), new CharRange(917504, 917631), new Union(new CharClass[]{new CharRange(57344, 63743), new CharRange(983040, 1048573), new CharRange(0x100000, 1114109)}), Empty.getInstance(), Empty.getInstance(), Empty.getInstance()};
    private static final CharClass DOT = new Complement(new Union(new CharClass[]{new SingleChar('\n'), new SingleChar('\r')}));
    private static final CharClass ESC_d = new Property("Nd");
    private static final CharClass ESC_D = new Complement(ESC_d);
    private static final CharClass ESC_W = new Union(new CharClass[]{new Property("P"), new Property("Z"), new Property("C")});
    private static final CharClass ESC_w = new Complement(ESC_W);
    private static final CharClass ESC_s = new Union(new CharClass[]{new SingleChar(' '), new SingleChar('\n'), new SingleChar('\r'), new SingleChar('\t')});
    private static final CharClass ESC_S = new Complement(ESC_s);
    private static final CharClass ESC_i = Translator.makeCharClass("LlLuLoLtNl", ":_\u02bb\u02bc\u02bd\u02be\u02bf\u02c0\u02c1\u0559\u06e5\u06e6\u212e", "\u00aa\u00ba\u0132\u0133\u013f\u0140\u0149\u0149\u017f\u017f\u01c4\u01cc\u01f1\u01f3\u01f6\u01f9\u0218\u0233\u02a9\u02ad\u03d7\u03d7\u03db\u03db\u03dd\u03dd\u03df\u03df\u03e1\u03e1\u0400\u0400\u040d\u040d\u0450\u0450\u045d\u045d\u048c\u048f\u04ec\u04ed\u0587\u0587\u06b8\u06b9\u06bf\u06bf\u06cf\u06cf\u06fa\u07a5\u0950\u0950\u0ad0\u0ad0\u0d85\u0dc6\u0e2f\u0e2f\u0eaf\u0eaf\u0edc\u0f00\u0f6a\u1055\u1101\u1101\u1104\u1104\u1108\u1108\u110a\u110a\u110d\u110d\u1113\u113b\u113d\u113d\u113f\u113f\u1141\u114b\u114d\u114d\u114f\u114f\u1151\u1153\u1156\u1158\u1162\u1162\u1164\u1164\u1166\u1166\u1168\u1168\u116a\u116c\u116f\u1171\u1174\u1174\u1176\u119d\u119f\u11a2\u11a9\u11aa\u11ac\u11ad\u11b0\u11b6\u11b9\u11b9\u11bb\u11bb\u11c3\u11ea\u11ec\u11ef\u11f1\u11f8\u1200\u18a8\u207f\u2124\u2128\u2128\u212c\u212d\u212f\u217f\u2183\u3006\u3038\u303a\u3131\u4db5\ua000\ua48c\uf900\uffdc");
    private static final CharClass ESC_I = new Complement(ESC_i);
    private static final CharClass ESC_c = Translator.makeCharClass("LlLuLoLtNlMcMeMnLmNd", "-.:_\u00b7\u0387\u212e", "\u00aa\u00b5\u00ba\u00ba\u0132\u0133\u013f\u0140\u0149\u0149\u017f\u017f\u01c4\u01cc\u01f1\u01f3\u01f6\u01f9\u0218\u0233\u02a9\u02b8\u02e0\u02ee\u0346\u034e\u0362\u037a\u03d7\u03d7\u03db\u03db\u03dd\u03dd\u03df\u03df\u03e1\u03e1\u0400\u0400\u040d\u040d\u0450\u0450\u045d\u045d\u0488\u048f\u04ec\u04ed\u0587\u0587\u0653\u0655\u06b8\u06b9\u06bf\u06bf\u06cf\u06cf\u06fa\u07b0\u0950\u0950\u0ad0\u0ad0\u0d82\u0df3\u0e2f\u0e2f\u0eaf\u0eaf\u0edc\u0f00\u0f6a\u0f6a\u0f96\u0f96\u0fae\u0fb0\u0fb8\u0fb8\u0fba\u1059\u1101\u1101\u1104\u1104\u1108\u1108\u110a\u110a\u110d\u110d\u1113\u113b\u113d\u113d\u113f\u113f\u1141\u114b\u114d\u114d\u114f\u114f\u1151\u1153\u1156\u1158\u1162\u1162\u1164\u1164\u1166\u1166\u1168\u1168\u116a\u116c\u116f\u1171\u1174\u1174\u1176\u119d\u119f\u11a2\u11a9\u11aa\u11ac\u11ad\u11b0\u11b6\u11b9\u11b9\u11bb\u11bb\u11c3\u11ea\u11ec\u11ef\u11f1\u11f8\u1200\u18a9\u207f\u207f\u20dd\u20e0\u20e2\u2124\u2128\u2128\u212c\u212d\u212f\u217f\u2183\u2183\u3006\u3006\u3038\u303a\u3131\u4db5\ua000\ua48c\uf900\uffdc");
    private static final CharClass ESC_C = new Complement(ESC_c);
    private static final char EOS = '\u0000';
    static final int NONE = -1;
    static final int SOME = 0;
    static final int ALL = 1;
    static final String SURROGATES1_CLASS = "[\ud800-\udbff]";
    static final String SURROGATES2_CLASS = "[\udc00-\udfff]";
    static final String NOT_ALLOWED_CLASS = "[\u0000&&[^\u0000]]";
    private static final char UNICODE_3_1_ADD_Lu = '\u03f4';
    private static final char UNICODE_3_1_ADD_Ll = '\u03f5';
    private static final char UNICODE_3_1_CHANGE_No_to_Nl_MIN = '\u16ee';
    private static final char UNICODE_3_1_CHANGE_No_to_Nl_MAX = '\u16f0';
    private static final String CATEGORY_Pi = "\u00ab\u2018\u201b\u201c\u201f\u2039";
    private static final String CATEGORY_Pf = "\u00bb\u2019\u201d\u203a";
    static /* synthetic */ Class class$com$thaiopensource$datatype$xsd$regex$jdk1_4$Translator;

    private Translator(String regExp) {
        this.regExp = regExp;
        this.length = regExp.length();
        this.advance();
    }

    public static String translate(String regexp) throws RegexSyntaxException {
        Translator tr = new Translator(regexp);
        tr.translateTop();
        return tr.result.toString();
    }

    private void advance() {
        if (this.pos < this.length) {
            this.curChar = this.regExp.charAt(this.pos++);
        } else {
            ++this.pos;
            this.curChar = '\u0000';
            this.eos = true;
        }
    }

    private void translateTop() throws RegexSyntaxException {
        this.translateRegExp();
        if (!this.eos) {
            throw this.makeException("expected_eos");
        }
    }

    private void translateRegExp() throws RegexSyntaxException {
        this.translateBranch();
        while (this.curChar == '|') {
            this.copyCurChar();
            this.translateBranch();
        }
    }

    private void translateBranch() throws RegexSyntaxException {
        while (this.translateAtom()) {
            this.translateQuantifier();
        }
    }

    private void translateQuantifier() throws RegexSyntaxException {
        switch (this.curChar) {
            case '*': 
            case '+': 
            case '?': {
                this.copyCurChar();
                return;
            }
            case '{': {
                this.copyCurChar();
                this.translateQuantity();
                this.expect('}');
                this.copyCurChar();
            }
        }
    }

    private void translateQuantity() throws RegexSyntaxException {
        block7: {
            String lower = this.parseQuantExact();
            int lowerValue = -1;
            try {
                lowerValue = Integer.parseInt(lower);
                this.result.append(lower);
            }
            catch (NumberFormatException e) {
                this.result.append(Integer.MAX_VALUE);
            }
            if (this.curChar == ',') {
                this.copyCurChar();
                if (this.curChar != '}') {
                    String upper = this.parseQuantExact();
                    try {
                        int upperValue = Integer.parseInt(upper);
                        this.result.append(upper);
                        if (lowerValue < 0 || upperValue < lowerValue) {
                            throw this.makeException("invalid_quantity_range");
                        }
                    }
                    catch (NumberFormatException e) {
                        this.result.append(Integer.MAX_VALUE);
                        if (lowerValue >= 0 || new BigDecimal(lower).compareTo(new BigDecimal(upper)) <= 0) break block7;
                        throw this.makeException("invalid_quantity_range");
                    }
                }
            }
        }
    }

    private String parseQuantExact() throws RegexSyntaxException {
        StringBuffer buf = new StringBuffer();
        do {
            if ("0123456789".indexOf(this.curChar) < 0) {
                throw this.makeException("expected_digit");
            }
            buf.append(this.curChar);
            this.advance();
        } while (this.curChar != ',' && this.curChar != '}');
        return buf.toString();
    }

    private void copyCurChar() {
        this.result.append(this.curChar);
        this.advance();
    }

    private boolean translateAtom() throws RegexSyntaxException {
        switch (this.curChar) {
            case '\u0000': {
                if (!this.eos) break;
            }
            case ')': 
            case '*': 
            case '+': 
            case '?': 
            case ']': 
            case '{': 
            case '|': 
            case '}': {
                return false;
            }
            case '(': {
                this.copyCurChar();
                this.translateRegExp();
                this.expect(')');
                this.copyCurChar();
                return true;
            }
            case '\\': {
                this.advance();
                this.parseEsc().output(this.result);
                return true;
            }
            case '[': {
                this.advance();
                this.parseCharClassExpr().output(this.result);
                return true;
            }
            case '.': {
                DOT.output(this.result);
                this.advance();
                return true;
            }
            case '$': 
            case '^': {
                this.result.append('\\');
            }
        }
        this.copyCurChar();
        return true;
    }

    private static CharClass makeCharClass(String categories, String includes, String excludeRanges) {
        int i;
        Vector<SimpleCharClass> includeList = new Vector<SimpleCharClass>();
        int len = categories.length();
        for (i = 0; i < len; i += 2) {
            includeList.add(new Property(categories.substring(i, i + 2)));
        }
        len = includes.length();
        for (i = 0; i < len; ++i) {
            int j;
            for (j = i + 1; j < len && includes.charAt(j) - includes.charAt(i) == j - i; ++j) {
            }
            if (i == --j - 1) {
                --j;
            }
            if (i == j) {
                includeList.add(new SingleChar(includes.charAt(i)));
            } else {
                includeList.add(new CharRange(includes.charAt(i), includes.charAt(j)));
            }
            i = j;
        }
        Vector<SimpleCharClass> excludeList = new Vector<SimpleCharClass>();
        int len2 = excludeRanges.length();
        for (int i2 = 0; i2 < len2; i2 += 2) {
            char max;
            char min = excludeRanges.charAt(i2);
            if (min == (max = excludeRanges.charAt(i2 + 1))) {
                excludeList.add(new SingleChar(min));
                continue;
            }
            if (min == max - '\u0001') {
                excludeList.add(new SingleChar(min));
                excludeList.add(new SingleChar(max));
                continue;
            }
            excludeList.add(new CharRange(min, max));
        }
        return new Subtraction(new Union(includeList), new Union(excludeList));
    }

    private CharClass parseEsc() throws RegexSyntaxException {
        switch (this.curChar) {
            case 'n': {
                this.advance();
                return new SingleChar('\n');
            }
            case 'r': {
                this.advance();
                return new SingleChar('\r');
            }
            case 't': {
                this.advance();
                return new SingleChar('\t');
            }
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '{': 
            case '|': 
            case '}': {
                break;
            }
            case 's': {
                this.advance();
                return ESC_s;
            }
            case 'S': {
                this.advance();
                return ESC_S;
            }
            case 'i': {
                this.advance();
                return ESC_i;
            }
            case 'I': {
                this.advance();
                return ESC_I;
            }
            case 'c': {
                this.advance();
                return ESC_c;
            }
            case 'C': {
                this.advance();
                return ESC_C;
            }
            case 'd': {
                this.advance();
                return ESC_d;
            }
            case 'D': {
                this.advance();
                return ESC_D;
            }
            case 'w': {
                this.advance();
                return ESC_w;
            }
            case 'W': {
                this.advance();
                return ESC_W;
            }
            case 'p': {
                this.advance();
                return this.parseProp();
            }
            case 'P': {
                this.advance();
                return new Complement(this.parseProp());
            }
            default: {
                throw this.makeException("bad_escape");
            }
        }
        SingleChar tem = new SingleChar(this.curChar);
        this.advance();
        return tem;
    }

    private CharClass parseProp() throws RegexSyntaxException {
        this.expect('{');
        int start = this.pos;
        while (true) {
            this.advance();
            if (this.curChar == '}') break;
            if (Translator.isAsciiAlnum(this.curChar) || this.curChar == '-') continue;
            this.expect('}');
        }
        String propertyName = this.regExp.substring(start, this.pos - 1);
        this.advance();
        switch (propertyName.length()) {
            case 0: {
                throw this.makeException("empty_property_name");
            }
            case 2: {
                int sci = subCategories.indexOf(propertyName);
                if (sci < 0 || sci % 2 == 1) {
                    throw this.makeException("bad_category");
                }
                return Translator.getSubCategoryCharClass(sci / 2);
            }
            case 1: {
                int ci = categories.indexOf(propertyName.charAt(0));
                if (ci < 0) {
                    throw this.makeException("bad_category", propertyName);
                }
                return Translator.getCategoryCharClass(ci);
            }
        }
        if (propertyName.startsWith("Is")) {
            String blockName = propertyName.substring(2);
            for (int i = 0; i < specialBlockNames.length; ++i) {
                if (!blockName.equals(specialBlockNames[i])) continue;
                return specialBlockCharClasses[i];
            }
            if (!Translator.isBlock(blockName)) {
                throw this.makeException("bad_block_name", blockName);
            }
            return new Property("In" + blockName);
        }
        throw this.makeException("bad_property_name", propertyName);
    }

    private static boolean isBlock(String name) {
        for (int i = 0; i < blockNames.length; ++i) {
            if (!name.equals(blockNames[i])) continue;
            return true;
        }
        return false;
    }

    private static boolean isAsciiAlnum(char c) {
        if ('a' <= c && c <= 'z') {
            return true;
        }
        if ('A' <= c && c <= 'Z') {
            return true;
        }
        return '0' <= c && c <= '9';
    }

    private void expect(char c) throws RegexSyntaxException {
        if (this.curChar != c) {
            throw this.makeException("expected", new String(new char[]{c}));
        }
    }

    private CharClass parseCharClassExpr() throws RegexSyntaxException {
        boolean compl;
        if (this.curChar == '^') {
            this.advance();
            compl = true;
        } else {
            compl = false;
        }
        Vector<CharClass> members = new Vector<CharClass>();
        do {
            CharClass lower = this.parseCharClassEscOrXmlChar();
            members.add(lower);
            if (this.curChar != '-') continue;
            this.advance();
            if (this.curChar == '[') break;
            CharClass upper = this.parseCharClassEscOrXmlChar();
            if (lower.singleChar() < 0 || upper.singleChar() < 0) {
                throw this.makeException("multi_range");
            }
            if (lower.singleChar() > upper.singleChar()) {
                throw this.makeException("invalid_range");
            }
            members.set(members.size() - 1, new CharRange(lower.singleChar(), upper.singleChar()));
            if (this.curChar != '-') continue;
            this.advance();
            this.expect('[');
            break;
        } while (this.curChar != ']');
        CharClass result = members.size() == 1 ? (CharClass)members.get(0) : new Union(members);
        if (compl) {
            result = new Complement(result);
        }
        if (this.curChar == '[') {
            this.advance();
            result = new Subtraction(result, this.parseCharClassExpr());
            this.expect(']');
        }
        this.advance();
        return result;
    }

    private CharClass parseCharClassEscOrXmlChar() throws RegexSyntaxException {
        SimpleCharClass tem;
        switch (this.curChar) {
            case '\u0000': {
                if (!this.eos) break;
                this.expect(']');
                break;
            }
            case '\\': {
                this.advance();
                return this.parseEsc();
            }
            case '-': 
            case '[': 
            case ']': {
                throw this.makeException("should_quote", new String(new char[]{this.curChar}));
            }
        }
        if (Utf16.isSurrogate(this.curChar)) {
            if (!Utf16.isSurrogate1(this.curChar)) {
                throw this.makeException("invalid_surrogate");
            }
            char c1 = this.curChar;
            this.advance();
            if (!Utf16.isSurrogate2(this.curChar)) {
                throw this.makeException("invalid_surrogate");
            }
            tem = new WideSingleChar(Utf16.scalarValue(c1, this.curChar));
        } else {
            tem = new SingleChar(this.curChar);
        }
        this.advance();
        return tem;
    }

    private RegexSyntaxException makeException(String key) {
        return new RegexSyntaxException(localizer.message(key), this.pos - 1);
    }

    private RegexSyntaxException makeException(String key, String arg) {
        return new RegexSyntaxException(localizer.message(key, arg), this.pos - 1);
    }

    private static boolean isJavaMetaChar(char c) {
        switch (c) {
            case '$': 
            case '&': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '-': 
            case '.': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': 
            case '^': 
            case '{': 
            case '|': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    private static synchronized CharClass getCategoryCharClass(int ci) {
        if (categoryCharClasses[ci] == null) {
            Translator.categoryCharClasses[ci] = Translator.computeCategoryCharClass(categories.charAt(ci));
        }
        return categoryCharClasses[ci];
    }

    private static synchronized CharClass getSubCategoryCharClass(int sci) {
        if (subCategoryCharClasses[sci] == null) {
            Translator.subCategoryCharClasses[sci] = Translator.computeSubCategoryCharClass(subCategories.substring(sci * 2, (sci + 1) * 2));
        }
        return subCategoryCharClasses[sci];
    }

    private static CharClass computeCategoryCharClass(char code) {
        Vector<CharClass> classes = new Vector<CharClass>();
        classes.add(new Property(new String(new char[]{code})));
        int ci = "NoLoMnCfLlNlLuMcNdSoSmCo".indexOf(code);
        while (ci >= 0) {
            int[] addRanges = Categories.CATEGORY_RANGES[ci / 2];
            for (int i = 0; i < addRanges.length; i += 2) {
                classes.add(new CharRange(addRanges[i], addRanges[i + 1]));
            }
            ci = "NoLoMnCfLlNlLuMcNdSoSmCo".indexOf(code, ci + 1);
        }
        if (code == 'P') {
            classes.add(Translator.makeCharClass("\u00ab\u2018\u201b\u201c\u201f\u2039\u00bb\u2019\u201d\u203a"));
        }
        if (code == 'L') {
            classes.add(new SingleChar('\u03f5'));
            classes.add(new SingleChar('\u03f4'));
        }
        if (code == 'C') {
            classes.add(new Subtraction(new Property("Cn"), new Union(new CharClass[]{new SingleChar('\u03f4'), new SingleChar('\u03f5')})));
            Vector<CharRange> assignedRanges = new Vector<CharRange>();
            for (int i = 0; i < Categories.CATEGORY_RANGES.length; ++i) {
                for (int j = 0; j < Categories.CATEGORY_RANGES[i].length; j += 2) {
                    assignedRanges.add(new CharRange(Categories.CATEGORY_RANGES[i][j], Categories.CATEGORY_RANGES[i][j + 1]));
                }
            }
            classes.add(new Subtraction(new CharRange(65536, 0x10FFFF), new Union(assignedRanges)));
        }
        if (classes.size() == 1) {
            return (CharClass)classes.get(0);
        }
        return new Union(classes);
    }

    private static CharClass computeSubCategoryCharClass(String name) {
        Property base = new Property(name);
        int sci = "NoLoMnCfLlNlLuMcNdSoSmCo".indexOf(name);
        if (sci < 0) {
            if (name.equals("Cn")) {
                Vector<SimpleCharClass> assignedRanges = new Vector<SimpleCharClass>();
                assignedRanges.add(new SingleChar('\u03f4'));
                assignedRanges.add(new SingleChar('\u03f5'));
                for (int i = 0; i < Categories.CATEGORY_RANGES.length; ++i) {
                    for (int j = 0; j < Categories.CATEGORY_RANGES[i].length; j += 2) {
                        assignedRanges.add(new CharRange(Categories.CATEGORY_RANGES[i][j], Categories.CATEGORY_RANGES[i][j + 1]));
                    }
                }
                return new Subtraction(new Union(new CharClass[]{base, new CharRange(65536, 0x10FFFF)}), new Union(assignedRanges));
            }
            if (name.equals("Pi")) {
                return Translator.makeCharClass(CATEGORY_Pi);
            }
            if (name.equals("Pf")) {
                return Translator.makeCharClass(CATEGORY_Pf);
            }
            return base;
        }
        Vector<SimpleCharClass> classes = new Vector<SimpleCharClass>();
        classes.add(base);
        int[] addRanges = Categories.CATEGORY_RANGES[sci / 2];
        for (int i = 0; i < addRanges.length; i += 2) {
            classes.add(new CharRange(addRanges[i], addRanges[i + 1]));
        }
        if (name.equals("Lu")) {
            classes.add(new SingleChar('\u03f4'));
        } else if (name.equals("Ll")) {
            classes.add(new SingleChar('\u03f5'));
        } else if (name.equals("Nl")) {
            classes.add(new CharRange(5870, 5872));
        } else if (name.equals("No")) {
            return new Subtraction(new Union(classes), new CharRange(5870, 5872));
        }
        return new Union(classes);
    }

    private static CharClass makeCharClass(String members) {
        Vector<SingleChar> list = new Vector<SingleChar>();
        int len = members.length();
        for (int i = 0; i < len; ++i) {
            list.add(new SingleChar(members.charAt(i)));
        }
        return new Union(list);
    }

    public static void main(String[] args) throws RegexSyntaxException {
        String s = Translator.translate(args[0]);
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c >= ' ' && c <= '~') {
                System.err.print(c);
                continue;
            }
            System.err.print("\\u");
            for (int shift = 12; shift >= 0; shift -= 4) {
                System.err.print("0123456789ABCDEF".charAt(c >> shift & 0xF));
            }
        }
        System.err.println();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class Complement
    extends CharClass {
        private final CharClass cc;

        Complement(CharClass cc) {
            super(-cc.getContainsBmp(), -cc.getContainsNonBmp());
            this.cc = cc;
        }

        void outputBmp(StringBuffer buf) {
            this.cc.outputComplementBmp(buf);
        }

        void outputComplementBmp(StringBuffer buf) {
            this.cc.outputBmp(buf);
        }

        void addNonBmpRanges(List ranges) {
            Vector tem = new Vector();
            this.cc.addNonBmpRanges(tem);
            Complement.sortRangeList(tem);
            int c = 65536;
            int len = tem.size();
            for (int i = 0; i < len; ++i) {
                Range r = (Range)tem.get(i);
                if (r.getMin() > c) {
                    ranges.add(new Range(c, r.getMin() - 1));
                }
                c = r.getMax() + 1;
            }
            if (c != 0x110000) {
                ranges.add(new Range(c, 0x10FFFF));
            }
        }
    }

    static class Union
    extends CharClass {
        private final List members;

        Union(CharClass[] v) {
            this(Union.toList(v));
        }

        private static List toList(CharClass[] v) {
            Vector<CharClass> members = new Vector<CharClass>();
            for (int i = 0; i < v.length; ++i) {
                members.add(v[i]);
            }
            return members;
        }

        Union(List members) {
            super(Union.computeContainsBmp(members), Union.computeContainsNonBmp(members));
            this.members = members;
        }

        void outputBmp(StringBuffer buf) {
            buf.append('[');
            int len = this.members.size();
            for (int i = 0; i < len; ++i) {
                CharClass cc = (CharClass)this.members.get(i);
                if (cc.getContainsBmp() == -1) continue;
                if (cc instanceof SimpleCharClass) {
                    ((SimpleCharClass)cc).inClassOutputBmp(buf);
                    continue;
                }
                cc.outputBmp(buf);
            }
            buf.append(']');
        }

        void outputComplementBmp(StringBuffer buf) {
            CharClass cc;
            int i;
            boolean first = true;
            int len = this.members.size();
            for (i = 0; i < len; ++i) {
                cc = (CharClass)this.members.get(i);
                if (cc.getContainsBmp() == -1 || !(cc instanceof SimpleCharClass)) continue;
                if (first) {
                    buf.append("[^");
                    first = false;
                }
                ((SimpleCharClass)cc).inClassOutputBmp(buf);
            }
            for (i = 0; i < len; ++i) {
                cc = (CharClass)this.members.get(i);
                if (cc.getContainsBmp() == -1 || cc instanceof SimpleCharClass) continue;
                if (first) {
                    buf.append('[');
                    first = false;
                } else {
                    buf.append("&&");
                }
                cc.outputComplementBmp(buf);
            }
            if (first) {
                buf.append("[\u0000-\uffff]");
            } else {
                buf.append(']');
            }
        }

        void addNonBmpRanges(List ranges) {
            int len = this.members.size();
            for (int i = 0; i < len; ++i) {
                ((CharClass)this.members.get(i)).addNonBmpRanges(ranges);
            }
        }

        private static int computeContainsBmp(List members) {
            int ret = -1;
            int len = members.size();
            for (int i = 0; i < len; ++i) {
                ret = Math.max(ret, ((CharClass)members.get(i)).getContainsBmp());
            }
            return ret;
        }

        private static int computeContainsNonBmp(List members) {
            int ret = -1;
            int len = members.size();
            for (int i = 0; i < len; ++i) {
                ret = Math.max(ret, ((CharClass)members.get(i)).getContainsNonBmp());
            }
            return ret;
        }
    }

    static class Subtraction
    extends CharClass {
        private final CharClass cc1;
        private final CharClass cc2;

        Subtraction(CharClass cc1, CharClass cc2) {
            super(Math.min(cc1.getContainsBmp(), -cc2.getContainsBmp()), Math.min(cc1.getContainsNonBmp(), -cc2.getContainsNonBmp()));
            this.cc1 = cc1;
            this.cc2 = cc2;
        }

        void outputBmp(StringBuffer buf) {
            buf.append('[');
            this.cc1.outputBmp(buf);
            buf.append("&&");
            this.cc2.outputComplementBmp(buf);
            buf.append(']');
        }

        void outputComplementBmp(StringBuffer buf) {
            buf.append('[');
            this.cc1.outputComplementBmp(buf);
            this.cc2.outputBmp(buf);
            buf.append(']');
        }

        void addNonBmpRanges(List ranges) {
            Vector posList = new Vector();
            this.cc1.addNonBmpRanges(posList);
            Vector negList = new Vector();
            this.cc2.addNonBmpRanges(negList);
            Subtraction.sortRangeList(posList);
            Subtraction.sortRangeList(negList);
            Iterator negIter = negList.iterator();
            Range negRange = negIter.hasNext() ? (Range)negIter.next() : null;
            int len = posList.size();
            for (int i = 0; i < len; ++i) {
                Range posRange = (Range)posList.get(i);
                while (negRange != null && negRange.getMax() < posRange.getMin()) {
                    if (negIter.hasNext()) {
                        negRange = (Range)negIter.next();
                        continue;
                    }
                    negRange = null;
                }
                int min = posRange.getMin();
                while (negRange != null && negRange.getMin() <= posRange.getMax()) {
                    if (min < negRange.getMin()) {
                        ranges.add(new Range(min, negRange.getMin() - 1));
                    }
                    if ((min = negRange.getMax() + 1) > posRange.getMax()) break;
                    if (negIter.hasNext()) {
                        negRange = (Range)negIter.next();
                        continue;
                    }
                    negRange = null;
                }
                if (min > posRange.getMax()) continue;
                ranges.add(new Range(min, posRange.getMax()));
            }
        }
    }

    static class Property
    extends SimpleCharClass {
        private final String name;

        Property(String name) {
            super(0, -1);
            this.name = name;
        }

        void outputBmp(StringBuffer buf) {
            this.inClassOutputBmp(buf);
        }

        void inClassOutputBmp(StringBuffer buf) {
            buf.append("\\p{");
            buf.append(this.name);
            buf.append('}');
        }

        void outputComplementBmp(StringBuffer buf) {
            buf.append("\\P{");
            buf.append(this.name);
            buf.append('}');
        }
    }

    static class CharRange
    extends SimpleCharClass {
        private final int lower;
        private final int upper;

        CharRange(int lower, int upper) {
            super(lower < 65536 ? 0 : -1, upper >= 65536 ? 0 : -1);
            this.lower = lower;
            this.upper = upper;
        }

        void inClassOutputBmp(StringBuffer buf) {
            if (this.lower >= 65536) {
                throw new RuntimeException("BMP output botch");
            }
            if (Translator.isJavaMetaChar((char)this.lower)) {
                buf.append('\\');
            }
            buf.append((char)this.lower);
            buf.append('-');
            if (this.upper < 65536) {
                if (Translator.isJavaMetaChar((char)this.upper)) {
                    buf.append('\\');
                }
                buf.append((char)this.upper);
            } else {
                buf.append('\uffff');
            }
        }

        void addNonBmpRanges(List ranges) {
            if (this.upper >= 65536) {
                ranges.add(new Range(this.lower < 65536 ? 65536 : this.lower, this.upper));
            }
        }
    }

    static class Empty
    extends SimpleCharClass {
        private static final Empty instance = new Empty();

        private Empty() {
            super(-1, -1);
        }

        static Empty getInstance() {
            return instance;
        }

        void inClassOutputBmp(StringBuffer buf) {
            throw new RuntimeException("BMP output botch");
        }
    }

    static class WideSingleChar
    extends SimpleCharClass {
        private final int c;

        WideSingleChar(int c) {
            super(-1, 0);
            this.c = c;
        }

        void inClassOutputBmp(StringBuffer buf) {
            throw new RuntimeException("BMP output botch");
        }

        int singleChar() {
            return this.c;
        }

        void addNonBmpRanges(List ranges) {
            ranges.add(new Range(this.c, this.c));
        }
    }

    static class SingleChar
    extends SimpleCharClass {
        private final char c;

        SingleChar(char c) {
            super(0, -1);
            this.c = c;
        }

        int singleChar() {
            return this.c;
        }

        void outputBmp(StringBuffer buf) {
            this.inClassOutputBmp(buf);
        }

        void inClassOutputBmp(StringBuffer buf) {
            if (Translator.isJavaMetaChar(this.c)) {
                buf.append('\\');
            }
            buf.append(this.c);
        }
    }

    static abstract class SimpleCharClass
    extends CharClass {
        SimpleCharClass(int containsBmp, int containsNonBmp) {
            super(containsBmp, containsNonBmp);
        }

        void outputBmp(StringBuffer buf) {
            buf.append('[');
            this.inClassOutputBmp(buf);
            buf.append(']');
        }

        void outputComplementBmp(StringBuffer buf) {
            if (this.getContainsBmp() == -1) {
                buf.append("[\u0000-\uffff]");
            } else {
                buf.append("[^");
                this.inClassOutputBmp(buf);
                buf.append(']');
            }
        }

        abstract void inClassOutputBmp(StringBuffer var1);
    }

    static abstract class CharClass {
        private final int containsBmp;
        private final int containsNonBmp;

        protected CharClass(int containsBmp, int containsNonBmp) {
            this.containsBmp = containsBmp;
            this.containsNonBmp = containsNonBmp;
        }

        int getContainsBmp() {
            return this.containsBmp;
        }

        int getContainsNonBmp() {
            return this.containsNonBmp;
        }

        final void output(StringBuffer buf) {
            switch (this.containsNonBmp) {
                case -1: {
                    if (this.containsBmp == -1) {
                        buf.append(Translator.NOT_ALLOWED_CLASS);
                        break;
                    }
                    this.outputBmp(buf);
                    break;
                }
                case 1: {
                    buf.append('(');
                    if (this.containsBmp == -1) {
                        buf.append(Translator.SURROGATES1_CLASS);
                        buf.append(Translator.SURROGATES2_CLASS);
                    } else {
                        this.outputBmp(buf);
                        buf.append(Translator.SURROGATES2_CLASS);
                        buf.append('?');
                    }
                    buf.append(')');
                    break;
                }
                case 0: {
                    buf.append('(');
                    boolean needSep = false;
                    if (this.containsBmp != -1) {
                        needSep = true;
                        this.outputBmp(buf);
                    }
                    Vector ranges = new Vector();
                    this.addNonBmpRanges(ranges);
                    CharClass.sortRangeList(ranges);
                    String hi = CharClass.highSurrogateRanges(ranges);
                    if (hi.length() > 0) {
                        if (needSep) {
                            buf.append('|');
                        } else {
                            needSep = true;
                        }
                        buf.append('[');
                        int len = hi.length();
                        for (int i = 0; i < len; i += 2) {
                            char max;
                            char min = hi.charAt(i);
                            if (min == (max = hi.charAt(i + 1))) {
                                buf.append(min);
                                continue;
                            }
                            buf.append(min);
                            buf.append('-');
                            buf.append(max);
                        }
                        buf.append(']');
                        buf.append(Translator.SURROGATES2_CLASS);
                    }
                    String lo = CharClass.lowSurrogateRanges(ranges);
                    int len = lo.length();
                    for (int i = 0; i < len; i += 3) {
                        if (needSep) {
                            buf.append('|');
                        } else {
                            needSep = true;
                        }
                        buf.append(lo.charAt(i));
                        char min = lo.charAt(i + 1);
                        char max = lo.charAt(i + 2);
                        if (min == max && (i + 3 >= len || lo.charAt(i + 3) != lo.charAt(i))) {
                            buf.append(min);
                            continue;
                        }
                        buf.append('[');
                        while (true) {
                            if (min == max) {
                                buf.append(min);
                            } else {
                                buf.append(min);
                                buf.append('-');
                                buf.append(max);
                            }
                            if (i + 3 >= len || lo.charAt(i + 3) != lo.charAt(i)) break;
                            min = lo.charAt((i += 3) + 1);
                            max = lo.charAt(i + 2);
                        }
                        buf.append(']');
                    }
                    if (!needSep) {
                        buf.append(Translator.NOT_ALLOWED_CLASS);
                    }
                    buf.append(')');
                }
            }
        }

        static String highSurrogateRanges(List ranges) {
            StringBuffer highRanges = new StringBuffer();
            int len = ranges.size();
            for (int i = 0; i < len; ++i) {
                Range r = (Range)ranges.get(i);
                char min1 = Utf16.surrogate1(r.getMin());
                char min2 = Utf16.surrogate2(r.getMin());
                char max1 = Utf16.surrogate1(r.getMax());
                char max2 = Utf16.surrogate2(r.getMax());
                if (min2 != '\udc00') {
                    min1 = (char)(min1 + '\u0001');
                }
                if (max2 != '\udfff') {
                    max1 = (char)(max1 - '\u0001');
                }
                if (max1 < min1) continue;
                highRanges.append(min1);
                highRanges.append(max1);
            }
            return highRanges.toString();
        }

        static String lowSurrogateRanges(List ranges) {
            StringBuffer lowRanges = new StringBuffer();
            int len = ranges.size();
            for (int i = 0; i < len; ++i) {
                Range r = (Range)ranges.get(i);
                char min1 = Utf16.surrogate1(r.getMin());
                char min2 = Utf16.surrogate2(r.getMin());
                char max1 = Utf16.surrogate1(r.getMax());
                char max2 = Utf16.surrogate2(r.getMax());
                if (min1 == max1) {
                    if (min2 == '\udc00' && max2 == '\udfff') continue;
                    lowRanges.append(min1);
                    lowRanges.append(min2);
                    lowRanges.append(max2);
                    continue;
                }
                if (min2 != '\udc00') {
                    lowRanges.append(min1);
                    lowRanges.append(min2);
                    lowRanges.append('\udfff');
                }
                if (max2 == '\udfff') continue;
                lowRanges.append(max1);
                lowRanges.append('\udc00');
                lowRanges.append(max2);
            }
            return lowRanges.toString();
        }

        abstract void outputBmp(StringBuffer var1);

        abstract void outputComplementBmp(StringBuffer var1);

        int singleChar() {
            return -1;
        }

        void addNonBmpRanges(List ranges) {
        }

        static void sortRangeList(List ranges) {
            Collections.sort(ranges);
            int toIndex = 0;
            int fromIndex = 0;
            int len = ranges.size();
            while (fromIndex < len) {
                Range r2;
                Range r = (Range)ranges.get(fromIndex);
                int min = r.getMin();
                int max = r.getMax();
                while (++fromIndex < len && (r2 = (Range)ranges.get(fromIndex)).getMin() <= max + 1) {
                    if (r2.getMax() <= max) continue;
                    max = r2.getMax();
                }
                if (max != r.getMax()) {
                    r = new Range(min, max);
                }
                ranges.set(toIndex++, r);
            }
            while (len > toIndex) {
                ranges.remove(--len);
            }
        }
    }

    static final class Range
    implements Comparable {
        private final int min;
        private final int max;

        Range(int min, int max) {
            this.min = min;
            this.max = max;
        }

        int getMin() {
            return this.min;
        }

        int getMax() {
            return this.max;
        }

        public int compareTo(Object o) {
            Range other = (Range)o;
            if (this.min < other.min) {
                return -1;
            }
            if (this.min > other.min) {
                return 1;
            }
            if (this.max > other.max) {
                return -1;
            }
            if (this.max < other.max) {
                return 1;
            }
            return 0;
        }
    }
}

