/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.parse.compact;

import com.thaiopensource.relaxng.parse.Annotations;
import com.thaiopensource.relaxng.parse.BuildException;
import com.thaiopensource.relaxng.parse.CommentList;
import com.thaiopensource.relaxng.parse.Context;
import com.thaiopensource.relaxng.parse.DataPatternBuilder;
import com.thaiopensource.relaxng.parse.Div;
import com.thaiopensource.relaxng.parse.ElementAnnotationBuilder;
import com.thaiopensource.relaxng.parse.Grammar;
import com.thaiopensource.relaxng.parse.GrammarSection;
import com.thaiopensource.relaxng.parse.IllegalSchemaException;
import com.thaiopensource.relaxng.parse.Include;
import com.thaiopensource.relaxng.parse.IncludedGrammar;
import com.thaiopensource.relaxng.parse.Location;
import com.thaiopensource.relaxng.parse.ParsedElementAnnotation;
import com.thaiopensource.relaxng.parse.ParsedNameClass;
import com.thaiopensource.relaxng.parse.ParsedPattern;
import com.thaiopensource.relaxng.parse.SchemaBuilder;
import com.thaiopensource.relaxng.parse.Scope;
import com.thaiopensource.relaxng.parse.compact.CompactSyntaxConstants;
import com.thaiopensource.relaxng.parse.compact.CompactSyntaxTokenManager;
import com.thaiopensource.relaxng.parse.compact.EscapeSyntaxException;
import com.thaiopensource.relaxng.parse.compact.ParseException;
import com.thaiopensource.relaxng.parse.compact.Token;
import com.thaiopensource.relaxng.parse.compact.UCode_UCodeESC_CharStream;
import com.thaiopensource.util.Localizer;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.LocatorImpl;

public class CompactSyntax
implements Context,
CompactSyntaxConstants {
    private static final int IN_ELEMENT = 0;
    private static final int IN_ATTRIBUTE = 1;
    private static final int IN_ANY_NAME = 2;
    private static final int IN_NS_NAME = 4;
    private String defaultNamespace = SchemaBuilder.INHERIT_NS;
    private String compatibilityPrefix = null;
    private SchemaBuilder sb;
    private String sourceUri;
    private ErrorHandler eh;
    private final Hashtable namespaceTable = new Hashtable();
    private final Hashtable datatypesTable = new Hashtable();
    private boolean hadError = false;
    private static final Localizer localizer = new Localizer(class$com$thaiopensource$relaxng$parse$compact$CompactSyntax == null ? (class$com$thaiopensource$relaxng$parse$compact$CompactSyntax = CompactSyntax.class$("com.thaiopensource.relaxng.parse.compact.CompactSyntax")) : class$com$thaiopensource$relaxng$parse$compact$CompactSyntax);
    private final Hashtable attributeNameTable = new Hashtable();
    private boolean annotationsIncludeElements = false;
    private CommentList topLevelComments;
    private Token lastCommentSourceToken = null;
    public CompactSyntaxTokenManager token_source;
    UCode_UCodeESC_CharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[71];
    private final int[] jj_la1_0 = new int[]{-1676803070, 30, 2, 226, 28, 224, 224, 0, 0, 0, -1945115162, -1945115162, 1026, 90112, 90112, -1945115424, 24576, 32768, 0, -1676803072, 0x100000, 0x200000, 0x400000, 0x700000, 0x700000, 0x3800000, 0, 0x3800000, -1643125536, 0, 0x100000, 0x100000, -1643125536, -1676679968, 0x2000000, 0x40000000, 0x40000000, 226, 224, 32, 28, 2048, 98, 96, 32768, 0x40000000, 0x40000000, 2048, 0, 0, 0, -1945115424, -1945115424, -1945115422, 0, 0, 0, 0, -1945115424, 2, -1945115424, -1945115424, 0, -1945115424, 256, -1945115424, 256, 256, 256, 256, -1945115424};
    private final int[] jj_la1_1 = new int[]{113248543, 0, 0, 46139648, 0, 0xC00000, 0, 2304, 512, 2304, 113246239, 113246239, 2304, 0, 0, 12582943, 0, 0x4000000, 0x8000000, 113246239, 0, 0, 0, 0, 0, 0, 0x8000000, 0, 62914591, 0x8000000, 0, 0, 62914591, 46137375, 0x1000000, 0, 0, 0xC00900, 0xC00000, 0xC00000, 0, 0, 0xC00900, 0xC00000, 0, 0, 0, 0, 0x4000000, 33554456, 0xC00000, 12582943, 12582943, 12585247, 2304, 512, 2304, 2304, 46137375, 0, 46137375, 46137375, 0x2C00000, 113246239, 0, 113246239, 0, 0, 0, 0, 31};
    private final JJCalls[] jj_2_rtns = new JJCalls[8];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;
    static /* synthetic */ Class class$com$thaiopensource$relaxng$parse$compact$CompactSyntax;

    public CompactSyntax(Reader r, String sourceUri, SchemaBuilder sb, ErrorHandler eh) {
        this(r);
        this.sourceUri = sourceUri;
        this.sb = sb;
        this.eh = eh;
        this.topLevelComments = sb.makeCommentList();
    }

    ParsedPattern parse(Scope scope) throws IllegalSchemaException {
        try {
            ParsedPattern p = this.Input(scope);
            if (!this.hadError) {
                return p;
            }
        }
        catch (ParseException e) {
            this.error("syntax_error", e.currentToken.next);
        }
        catch (EscapeSyntaxException e) {
            this.reportEscapeSyntaxException(e);
        }
        throw new IllegalSchemaException();
    }

    ParsedPattern parseInclude(IncludedGrammar g) throws IllegalSchemaException {
        try {
            ParsedPattern p = this.IncludedGrammar(g);
            if (!this.hadError) {
                return p;
            }
        }
        catch (ParseException e) {
            this.error("syntax_error", e.currentToken.next);
        }
        catch (EscapeSyntaxException e) {
            this.reportEscapeSyntaxException(e);
        }
        throw new IllegalSchemaException();
    }

    private void checkNsName(int context, LocatedString ns) {
        if ((context & 4) != 0) {
            this.error("ns_name_except_contains_ns_name", ns.getToken());
        }
    }

    private void checkAnyName(int context, Token t) {
        if ((context & 4) != 0) {
            this.error("ns_name_except_contains_any_name", t);
        }
        if ((context & 2) != 0) {
            this.error("any_name_except_contains_any_name", t);
        }
    }

    private void error(String key, Token tok) {
        this.doError(localizer.message(key), tok);
    }

    private void error(String key, String arg, Token tok) {
        this.doError(localizer.message(key, arg), tok);
    }

    private void error(String key, String arg1, String arg2, Token tok) {
        this.doError(localizer.message(key, arg1, arg2), tok);
    }

    private void doError(String message, Token tok) {
        this.hadError = true;
        if (this.eh != null) {
            LocatorImpl loc = new LocatorImpl();
            loc.setLineNumber(tok.beginLine);
            loc.setColumnNumber(tok.beginColumn);
            loc.setSystemId(this.sourceUri);
            try {
                this.eh.error(new SAXParseException(message, loc));
            }
            catch (SAXException se) {
                throw new BuildException(se);
            }
        }
    }

    private void reportEscapeSyntaxException(EscapeSyntaxException e) {
        if (this.eh != null) {
            LocatorImpl loc = new LocatorImpl();
            loc.setLineNumber(e.getLineNumber());
            loc.setColumnNumber(e.getColumnNumber());
            loc.setSystemId(this.sourceUri);
            try {
                this.eh.error(new SAXParseException(localizer.message(e.getKey()), loc));
            }
            catch (SAXException se) {
                throw new BuildException(se);
            }
        }
    }

    private static String unquote(String s) {
        if (s.length() >= 6 && s.charAt(0) == s.charAt(1)) {
            s = s.replace('\u0000', '\n');
            return s.substring(3, s.length() - 3);
        }
        return s.substring(1, s.length() - 1);
    }

    Location makeLocation(Token t) {
        return this.sb.makeLocation(this.sourceUri, t.beginLine, t.beginColumn);
    }

    private static ParsedPattern[] addPattern(ParsedPattern[] patterns, int i, ParsedPattern p) {
        if (i >= patterns.length) {
            ParsedPattern[] oldPatterns = patterns;
            patterns = new ParsedPattern[oldPatterns.length * 2];
            System.arraycopy(oldPatterns, 0, patterns, 0, oldPatterns.length);
        }
        patterns[i] = p;
        return patterns;
    }

    String getCompatibilityPrefix() {
        if (this.compatibilityPrefix == null) {
            this.compatibilityPrefix = "a";
            while (this.namespaceTable.get(this.compatibilityPrefix) != null) {
                this.compatibilityPrefix = this.compatibilityPrefix + "a";
            }
        }
        return this.compatibilityPrefix;
    }

    public String resolveNamespacePrefix(String prefix) {
        String result = (String)this.namespaceTable.get(prefix);
        if (result.length() == 0) {
            return null;
        }
        return result;
    }

    public Enumeration prefixes() {
        return this.namespaceTable.keys();
    }

    public String getBaseUri() {
        return this.sourceUri;
    }

    public boolean isUnparsedEntity(String entityName) {
        return false;
    }

    public boolean isNotation(String notationName) {
        return false;
    }

    public Context copy() {
        return this;
    }

    private Context getContext() {
        return this;
    }

    private CommentList getComments() {
        return this.getComments(this.getTopLevelComments());
    }

    private CommentList getTopLevelComments() {
        CommentList tem = this.topLevelComments;
        this.topLevelComments = null;
        return tem;
    }

    private void noteTopLevelComments() {
        this.topLevelComments = this.getComments(this.topLevelComments);
    }

    private void topLevelComments(GrammarSection section) {
        section.topLevelComment(this.getComments(null));
    }

    private CommentList getComments(CommentList comments) {
        Token nextToken = this.getToken(1);
        if (this.lastCommentSourceToken != nextToken) {
            if (this.lastCommentSourceToken == null) {
                this.lastCommentSourceToken = this.token;
            }
            do {
                this.lastCommentSourceToken = this.lastCommentSourceToken.next;
                Token t = this.lastCommentSourceToken.specialToken;
                if (t == null) continue;
                while (t.specialToken != null) {
                    t = t.specialToken;
                }
                if (comments == null) {
                    comments = this.sb.makeCommentList();
                }
                while (t != null) {
                    String s = CompactSyntax.mungeComment(t.image);
                    Location loc = this.makeLocation(t);
                    if (t.next != null && t.next.kind == 44) {
                        StringBuffer buf = new StringBuffer(s);
                        do {
                            t = t.next;
                            buf.append('\n');
                            buf.append(CompactSyntax.mungeComment(t.image));
                        } while (t.next != null && t.next.kind == 44);
                        s = buf.toString();
                    }
                    comments.addComment(s, loc);
                    t = t.next;
                }
            } while (this.lastCommentSourceToken != nextToken);
        }
        return comments;
    }

    private ParsedPattern afterComments(ParsedPattern p) {
        CommentList comments = this.getComments(null);
        if (comments == null) {
            return p;
        }
        return this.sb.commentAfter(p, comments);
    }

    private ParsedNameClass afterComments(ParsedNameClass nc) {
        CommentList comments = this.getComments(null);
        if (comments == null) {
            return nc;
        }
        return this.sb.commentAfter(nc, comments);
    }

    private static String mungeComment(String image) {
        int i;
        for (i = image.indexOf(35) + 1; i < image.length() && image.charAt(i) == '#'; ++i) {
        }
        if (i < image.length() && image.charAt(i) == ' ') {
            ++i;
        }
        return image.substring(i);
    }

    private Annotations getCommentsAsAnnotations() {
        CommentList comments = this.getComments();
        if (comments == null) {
            return null;
        }
        return this.sb.makeAnnotations(comments, this.getContext());
    }

    private Annotations addCommentsToChildAnnotations(Annotations a) {
        CommentList comments = this.getComments();
        if (comments == null) {
            return a;
        }
        if (a == null) {
            a = this.sb.makeAnnotations(null, this.getContext());
        }
        a.addComment(comments);
        return a;
    }

    private Annotations addCommentsToLeadingAnnotations(Annotations a) {
        CommentList comments = this.getComments();
        if (comments == null) {
            return a;
        }
        if (a == null) {
            return this.sb.makeAnnotations(comments, this.getContext());
        }
        a.addLeadingComment(comments);
        return a;
    }

    private Annotations getTopLevelCommentsAsAnnotations() {
        CommentList comments = this.getTopLevelComments();
        if (comments == null) {
            return null;
        }
        return this.sb.makeAnnotations(comments, this.getContext());
    }

    private void clearAttributeList() {
        this.attributeNameTable.clear();
    }

    private void addAttribute(Annotations a, String ns, String localName, String prefix, String value, Token tok) {
        String key = ns + "#" + localName;
        if (this.attributeNameTable.get(key) != null) {
            this.error("duplicate_attribute", ns, localName, tok);
        } else {
            this.attributeNameTable.put(key, key);
            a.addAttribute(ns, localName, prefix, value, this.makeLocation(tok));
        }
    }

    private void checkExcept(Token[] except) {
        if (except[0] != null) {
            this.error("except_missing_parentheses", except[0]);
        }
    }

    private String lookupPrefix(String prefix, Token t) {
        String ns = (String)this.namespaceTable.get(prefix);
        if (ns == null) {
            this.error("undeclared_prefix", prefix, t);
            return "#error";
        }
        return ns;
    }

    private String lookupDatatype(String prefix, Token t) {
        String ns = (String)this.datatypesTable.get(prefix);
        if (ns == null) {
            this.error("undeclared_prefix", prefix, t);
            return "";
        }
        return ns;
    }

    private String resolve(String str) {
        try {
            return new URL(new URL(this.sourceUri), str).toString();
        }
        catch (MalformedURLException malformedURLException) {
            return str;
        }
    }

    /*
     * WARNING - void declaration
     */
    public final ParsedPattern Input(Scope scope) throws ParseException {
        void var2_2;
        ParsedPattern p;
        this.Preamble();
        if (this.jj_2_1(Integer.MAX_VALUE)) {
            p = this.TopLevelGrammar(scope);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 10: 
                case 17: 
                case 18: 
                case 19: 
                case 26: 
                case 27: 
                case 28: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 40: 
                case 43: 
                case 54: 
                case 55: 
                case 57: 
                case 58: {
                    p = this.Expr(true, scope, null, null);
                    p = this.afterComments(p);
                    this.jj_consume_token(0);
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return var2_2;
    }

    public final void TopLevelLookahead() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 57: {
                this.jj_consume_token(57);
                this.jj_consume_token(1);
                break;
            }
            case 54: 
            case 55: {
                this.Identifier();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        this.jj_consume_token(1);
                        break block0;
                    }
                    case 2: {
                        this.jj_consume_token(2);
                        break block0;
                    }
                    case 3: {
                        this.jj_consume_token(3);
                        break block0;
                    }
                    case 4: {
                        this.jj_consume_token(4);
                        break block0;
                    }
                }
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 5: 
            case 6: 
            case 7: {
                this.LookaheadGrammarKeyword();
                break;
            }
            case 1: {
                this.LookaheadBody();
                this.LookaheadAfterAnnotations();
                break;
            }
            case 40: 
            case 43: {
                this.LookaheadDocumentation();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: {
                        this.LookaheadBody();
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                    }
                }
                this.LookaheadAfterAnnotations();
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void LookaheadAfterAnnotations() throws ParseException {
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 54: 
            case 55: {
                this.Identifier();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 2: {
                        this.jj_consume_token(2);
                        break block0;
                    }
                    case 3: {
                        this.jj_consume_token(3);
                        break block0;
                    }
                    case 4: {
                        this.jj_consume_token(4);
                        break block0;
                    }
                }
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            case 5: 
            case 6: 
            case 7: {
                this.LookaheadGrammarKeyword();
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void LookaheadGrammarKeyword() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                this.jj_consume_token(5);
                break;
            }
            case 6: {
                this.jj_consume_token(6);
                break;
            }
            case 7: {
                this.jj_consume_token(7);
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void LookaheadDocumentation() throws ParseException {
        block10: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 40: {
                    this.jj_consume_token(40);
                    break;
                }
                case 43: {
                    this.jj_consume_token(43);
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 41: {
                        break;
                    }
                    default: {
                        this.jj_la1[8] = this.jj_gen;
                        break block11;
                    }
                }
                this.jj_consume_token(41);
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 40: 
                case 43: {
                    continue block10;
                }
            }
            break;
        }
        this.jj_la1[9] = this.jj_gen;
    }

    public final void LookaheadBody() throws ParseException {
        block12: {
            this.jj_consume_token(1);
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 2: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 10: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 26: 
                    case 27: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 54: 
                    case 55: 
                    case 57: 
                    case 58: {
                        break;
                    }
                    default: {
                        this.jj_la1[10] = this.jj_gen;
                        break block12;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 57: {
                        this.jj_consume_token(57);
                        continue block11;
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 10: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 26: 
                    case 27: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 54: 
                    case 55: {
                        this.UnprefixedName();
                        continue block11;
                    }
                    case 2: {
                        this.jj_consume_token(2);
                        continue block11;
                    }
                    case 58: {
                        this.jj_consume_token(58);
                        continue block11;
                    }
                    case 8: {
                        this.jj_consume_token(8);
                        continue block11;
                    }
                    case 1: {
                        this.LookaheadBody();
                        continue block11;
                    }
                }
                break;
            }
            this.jj_la1[11] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.jj_consume_token(9);
    }

    /*
     * WARNING - void declaration
     */
    public final ParsedPattern IncludedGrammar(IncludedGrammar g) throws ParseException {
        void var2_2;
        Annotations a;
        this.Preamble();
        if (this.jj_2_2(Integer.MAX_VALUE)) {
            a = this.GrammarBody(g, g, this.getTopLevelCommentsAsAnnotations());
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 10: 
                case 40: 
                case 43: {
                    a = this.Annotations();
                    this.jj_consume_token(10);
                    this.jj_consume_token(11);
                    a = this.GrammarBody(g, g, a);
                    this.topLevelComments(g);
                    this.jj_consume_token(12);
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        ParsedPattern p = this.afterComments(g.endIncludedGrammar(this.sb.makeLocation(this.sourceUri, 1, 1), (Annotations)var2_2));
        this.jj_consume_token(0);
        return p;
    }

    public final ParsedPattern TopLevelGrammar(Scope scope) throws ParseException {
        Annotations a = this.getTopLevelCommentsAsAnnotations();
        Grammar g = this.sb.makeGrammar(scope);
        a = this.GrammarBody(g, g, a);
        ParsedPattern p = this.afterComments(g.endGrammar(this.sb.makeLocation(this.sourceUri, 1, 1), a));
        this.jj_consume_token(0);
        return p;
    }

    public final void Preamble() throws ParseException {
        block9: {
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: 
                    case 14: 
                    case 16: {
                        break;
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                        break block9;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: 
                    case 14: {
                        this.NamespaceDecl();
                        continue block7;
                    }
                    case 16: {
                        this.DatatypesDecl();
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[14] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        this.namespaceTable.put("xml", "http://www.w3.org/XML/1998/namespace");
        if (this.datatypesTable.get("xsd") == null) {
            this.datatypesTable.put("xsd", "http://www.w3.org/2001/XMLSchema-datatypes");
        }
    }

    public final void NamespaceDecl() throws ParseException {
        LocatedString prefix = null;
        boolean isDefault = false;
        this.noteTopLevelComments();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: {
                this.jj_consume_token(13);
                prefix = this.UnprefixedName();
                break;
            }
            case 14: {
                this.jj_consume_token(14);
                isDefault = true;
                this.jj_consume_token(13);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: 
                    case 6: 
                    case 7: 
                    case 10: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 26: 
                    case 27: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 54: 
                    case 55: {
                        prefix = this.UnprefixedName();
                        break block0;
                    }
                }
                this.jj_la1[15] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(2);
        String namespaceName = this.NamespaceName();
        if (isDefault) {
            this.defaultNamespace = namespaceName;
        }
        if (prefix != null) {
            if (prefix.getString().equals("xmlns")) {
                this.error("xmlns_prefix", prefix.getToken());
            } else if (prefix.getString().equals("xml")) {
                if (!namespaceName.equals("http://www.w3.org/XML/1998/namespace")) {
                    this.error("xml_prefix_bad_uri", prefix.getToken());
                }
            } else if (namespaceName.equals("http://www.w3.org/XML/1998/namespace")) {
                this.error("xml_uri_bad_prefix", prefix.getToken());
            } else {
                if (namespaceName.equals("http://relaxng.org/ns/compatibility/annotations/1.0")) {
                    this.compatibilityPrefix = prefix.getString();
                }
                this.namespaceTable.put(prefix.getString(), namespaceName);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final String NamespaceName() throws ParseException {
        void var1_1;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 58: {
                String r = this.Literal();
                break;
            }
            case 15: {
                this.jj_consume_token(15);
                String r = SchemaBuilder.INHERIT_NS;
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return var1_1;
    }

    public final void DatatypesDecl() throws ParseException {
        this.noteTopLevelComments();
        this.jj_consume_token(16);
        LocatedString prefix = this.UnprefixedName();
        this.jj_consume_token(2);
        String uri = this.Literal();
        this.datatypesTable.put(prefix.getString(), uri);
    }

    public final ParsedPattern AnnotatedPrimaryExpr(boolean topLevel, Scope scope, Token[] except) throws ParseException {
        Annotations a = this.Annotations();
        ParsedPattern p = this.PrimaryExpr(topLevel, scope, a, except);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 59: {
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                    break block3;
                }
            }
            Token t = this.jj_consume_token(59);
            ParsedElementAnnotation e = this.AnnotationElement(false);
            if (topLevel) {
                this.error("top_level_follow_annotation", t);
                continue;
            }
            p = this.sb.annotateAfter(p, e);
        }
        return p;
    }

    /*
     * WARNING - void declaration
     */
    public final ParsedPattern PrimaryExpr(boolean topLevel, Scope scope, Annotations a, Token[] except) throws ParseException {
        void var5_5;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 26: {
                ParsedPattern p = this.ElementExpr(scope, a);
                break;
            }
            case 27: {
                ParsedPattern p = this.AttributeExpr(scope, a);
                break;
            }
            case 10: {
                ParsedPattern p = this.GrammarExpr(scope, a);
                break;
            }
            case 33: {
                ParsedPattern p = this.ExternalRefExpr(scope, a);
                break;
            }
            case 31: {
                ParsedPattern p = this.ListExpr(scope, a);
                break;
            }
            case 32: {
                ParsedPattern p = this.MixedExpr(scope, a);
                break;
            }
            case 28: {
                ParsedPattern p = this.ParenExpr(topLevel, scope, a);
                break;
            }
            case 54: 
            case 55: {
                ParsedPattern p = this.IdentifierExpr(scope, a);
                break;
            }
            case 34: {
                ParsedPattern p = this.ParentExpr(scope, a);
                break;
            }
            case 35: 
            case 36: 
            case 57: {
                ParsedPattern p = this.DataExpr(topLevel, scope, a, except);
                break;
            }
            case 58: {
                ParsedPattern p = this.ValueExpr(topLevel, a);
                break;
            }
            case 18: {
                ParsedPattern p = this.TextExpr(a);
                break;
            }
            case 17: {
                ParsedPattern p = this.EmptyExpr(a);
                break;
            }
            case 19: {
                ParsedPattern p = this.NotAllowedExpr(a);
                break;
            }
            default: {
                this.jj_la1[19] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return var5_5;
    }

    public final ParsedPattern EmptyExpr(Annotations a) throws ParseException {
        Token t = this.jj_consume_token(17);
        return this.sb.makeEmpty(this.makeLocation(t), a);
    }

    public final ParsedPattern TextExpr(Annotations a) throws ParseException {
        Token t = this.jj_consume_token(18);
        return this.sb.makeText(this.makeLocation(t), a);
    }

    public final ParsedPattern NotAllowedExpr(Annotations a) throws ParseException {
        Token t = this.jj_consume_token(19);
        return this.sb.makeNotAllowed(this.makeLocation(t), a);
    }

    public final ParsedPattern Expr(boolean topLevel, Scope scope, Token t, Annotations a) throws ParseException {
        ParsedPattern p;
        ParsedPattern[] patterns = new ParsedPattern[2];
        int nPatterns = 1;
        boolean[] hadOccur = new boolean[1];
        Token[] except = new Token[1];
        patterns[0] = p = this.UnaryExpr(topLevel, scope, hadOccur, except);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: 
            case 21: 
            case 22: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 20: {
                        this.checkExcept(except);
                        block17: while (true) {
                            t = this.jj_consume_token(20);
                            p = this.UnaryExpr(topLevel, scope, null, except);
                            patterns = CompactSyntax.addPattern(patterns, nPatterns++, p);
                            this.checkExcept(except);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 20: {
                                    continue block17;
                                }
                            }
                            break;
                        }
                        this.jj_la1[20] = this.jj_gen;
                        p = this.sb.makeChoice(patterns, nPatterns, this.makeLocation(t), a);
                        break block0;
                    }
                    case 21: {
                        block18: while (true) {
                            t = this.jj_consume_token(21);
                            p = this.UnaryExpr(topLevel, scope, null, except);
                            patterns = CompactSyntax.addPattern(patterns, nPatterns++, p);
                            this.checkExcept(except);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 21: {
                                    continue block18;
                                }
                            }
                            break;
                        }
                        this.jj_la1[21] = this.jj_gen;
                        p = this.sb.makeInterleave(patterns, nPatterns, this.makeLocation(t), a);
                        break block0;
                    }
                    case 22: {
                        block19: while (true) {
                            t = this.jj_consume_token(22);
                            p = this.UnaryExpr(topLevel, scope, null, except);
                            patterns = CompactSyntax.addPattern(patterns, nPatterns++, p);
                            this.checkExcept(except);
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 22: {
                                    continue block19;
                                }
                            }
                            break;
                        }
                        this.jj_la1[22] = this.jj_gen;
                        p = this.sb.makeGroup(patterns, nPatterns, this.makeLocation(t), a);
                        break block0;
                    }
                }
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
            }
        }
        if (nPatterns == 1 && a != null) {
            p = hadOccur[0] ? this.sb.annotate(p, a) : this.sb.makeGroup(patterns, nPatterns, this.makeLocation(t), a);
        }
        return p;
    }

    public final ParsedPattern UnaryExpr(boolean topLevel, Scope scope, boolean[] hadOccur, Token[] except) throws ParseException {
        ParsedPattern p = this.AnnotatedPrimaryExpr(topLevel, scope, except);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 23: 
            case 24: 
            case 25: {
                Token t;
                if (hadOccur != null) {
                    hadOccur[0] = true;
                }
                p = this.afterComments(p);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 23: {
                        t = this.jj_consume_token(23);
                        this.checkExcept(except);
                        p = this.sb.makeOneOrMore(p, this.makeLocation(t), null);
                        break;
                    }
                    case 24: {
                        t = this.jj_consume_token(24);
                        this.checkExcept(except);
                        p = this.sb.makeOptional(p, this.makeLocation(t), null);
                        break;
                    }
                    case 25: {
                        t = this.jj_consume_token(25);
                        this.checkExcept(except);
                        p = this.sb.makeZeroOrMore(p, this.makeLocation(t), null);
                        break;
                    }
                    default: {
                        this.jj_la1[25] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 59: {
                            break;
                        }
                        default: {
                            this.jj_la1[26] = this.jj_gen;
                            break block0;
                        }
                    }
                    t = this.jj_consume_token(59);
                    ParsedElementAnnotation e = this.AnnotationElement(false);
                    if (topLevel) {
                        this.error("top_level_follow_annotation", t);
                        continue;
                    }
                    p = this.sb.annotateAfter(p, e);
                }
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
            }
        }
        return p;
    }

    public final ParsedPattern ElementExpr(Scope scope, Annotations a) throws ParseException {
        Token t = this.jj_consume_token(26);
        ParsedNameClass nc = this.NameClass(0, null);
        this.jj_consume_token(11);
        ParsedPattern p = this.Expr(false, scope, null, null);
        p = this.afterComments(p);
        this.jj_consume_token(12);
        return this.sb.makeElement(nc, p, this.makeLocation(t), a);
    }

    public final ParsedPattern AttributeExpr(Scope scope, Annotations a) throws ParseException {
        Token t = this.jj_consume_token(27);
        ParsedNameClass nc = this.NameClass(1, null);
        this.jj_consume_token(11);
        ParsedPattern p = this.Expr(false, scope, null, null);
        p = this.afterComments(p);
        this.jj_consume_token(12);
        return this.sb.makeAttribute(nc, p, this.makeLocation(t), a);
    }

    /*
     * WARNING - void declaration
     */
    public final ParsedNameClass NameClass(int context, Annotations[] pa) throws ParseException {
        void var4_4;
        Annotations a = this.Annotations();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 54: 
            case 55: 
            case 57: {
                ParsedNameClass nc = this.PrimaryNameClass(context, a);
                nc = this.AnnotateAfter(nc);
                nc = this.NameClassAlternatives(context, nc, pa);
                break;
            }
            case 25: {
                ParsedNameClass nc = this.AnyNameExceptClass(context, a, pa);
                break;
            }
            case 56: {
                ParsedNameClass nc = this.NsNameExceptClass(context, a, pa);
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return var4_4;
    }

    public final ParsedNameClass AnnotateAfter(ParsedNameClass nc) throws ParseException {
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 59: {
                    break;
                }
                default: {
                    this.jj_la1[29] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(59);
            ParsedElementAnnotation e = this.AnnotationElement(false);
            nc = this.sb.annotateAfter(nc, e);
        }
        return nc;
    }

    public final ParsedNameClass NameClassAlternatives(int context, ParsedNameClass nc, Annotations[] pa) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 20: {
                Annotations a;
                Token t;
                ParsedNameClass[] nameClasses = new ParsedNameClass[2];
                nameClasses[0] = nc;
                int nNameClasses = 1;
                block6: while (true) {
                    t = this.jj_consume_token(20);
                    nc = this.BasicNameClass(context);
                    nc = this.AnnotateAfter(nc);
                    if (nNameClasses >= nameClasses.length) {
                        ParsedNameClass[] oldNameClasses = nameClasses;
                        nameClasses = new ParsedNameClass[oldNameClasses.length * 2];
                        System.arraycopy(oldNameClasses, 0, nameClasses, 0, oldNameClasses.length);
                    }
                    nameClasses[nNameClasses++] = nc;
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 20: {
                            continue block6;
                        }
                    }
                    break;
                }
                this.jj_la1[30] = this.jj_gen;
                if (pa == null) {
                    a = null;
                } else {
                    a = pa[0];
                    pa[0] = null;
                }
                nc = this.sb.makeChoice(nameClasses, nNameClasses, this.makeLocation(t), a);
                break;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
            }
        }
        return nc;
    }

    /*
     * WARNING - void declaration
     */
    public final ParsedNameClass BasicNameClass(int context) throws ParseException {
        void var3_3;
        Annotations a = this.Annotations();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 28: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 54: 
            case 55: 
            case 57: {
                ParsedNameClass nc = this.PrimaryNameClass(context, a);
                break;
            }
            case 25: 
            case 56: {
                ParsedNameClass nc = this.OpenNameClass(context, a);
                break;
            }
            default: {
                this.jj_la1[32] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public final ParsedNameClass PrimaryNameClass(int context, Annotations a) throws ParseException {
        void var3_3;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 54: 
            case 55: {
                ParsedNameClass nc = this.UnprefixedNameClass(context, a);
                break;
            }
            case 57: {
                ParsedNameClass nc = this.PrefixedNameClass(a);
                break;
            }
            case 28: {
                ParsedNameClass nc = this.ParenNameClass(context, a);
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return var3_3;
    }

    public final ParsedNameClass OpenNameClass(int context, Annotations a) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 56: {
                LocatedString ns = this.NsName();
                this.checkNsName(context, ns);
                return this.sb.makeNsName(ns.getString(), ns.getLocation(), a);
            }
            case 25: {
                Token t = this.jj_consume_token(25);
                this.checkAnyName(context, t);
                return this.sb.makeAnyName(this.makeLocation(t), a);
            }
        }
        this.jj_la1[34] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final ParsedNameClass UnprefixedNameClass(int context, Annotations a) throws ParseException {
        LocatedString name = this.UnprefixedName();
        String ns = (context & 1) == 1 ? "" : this.defaultNamespace;
        return this.sb.makeName(ns, name.getString(), null, name.getLocation(), a);
    }

    public final ParsedNameClass PrefixedNameClass(Annotations a) throws ParseException {
        Token t = this.jj_consume_token(57);
        String qn = t.image;
        int colon = qn.indexOf(58);
        String prefix = qn.substring(0, colon);
        return this.sb.makeName(this.lookupPrefix(prefix, t), qn.substring(colon + 1), prefix, this.makeLocation(t), a);
    }

    public final ParsedNameClass NsNameExceptClass(int context, Annotations a, Annotations[] pa) throws ParseException {
        ParsedNameClass nc;
        LocatedString ns = this.NsName();
        this.checkNsName(context, ns);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                nc = this.ExceptNameClass(context | 4);
                nc = this.sb.makeNsName(ns.getString(), nc, ns.getLocation(), a);
                nc = this.AnnotateAfter(nc);
                break;
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
                nc = this.sb.makeNsName(ns.getString(), ns.getLocation(), a);
                nc = this.AnnotateAfter(nc);
                nc = this.NameClassAlternatives(context, nc, pa);
            }
        }
        return nc;
    }

    public final LocatedString NsName() throws ParseException {
        Token t = this.jj_consume_token(56);
        String qn = t.image;
        String prefix = qn.substring(0, qn.length() - 2);
        return new LocatedString(this.lookupPrefix(prefix, t), t);
    }

    public final ParsedNameClass AnyNameExceptClass(int context, Annotations a, Annotations[] pa) throws ParseException {
        ParsedNameClass nc;
        Token t = this.jj_consume_token(25);
        this.checkAnyName(context, t);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                nc = this.ExceptNameClass(context | 2);
                nc = this.sb.makeAnyName(nc, this.makeLocation(t), a);
                nc = this.AnnotateAfter(nc);
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
                nc = this.sb.makeAnyName(this.makeLocation(t), a);
                nc = this.AnnotateAfter(nc);
                nc = this.NameClassAlternatives(context, nc, pa);
            }
        }
        return nc;
    }

    public final ParsedNameClass ParenNameClass(int context, Annotations a) throws ParseException {
        Annotations[] pa = new Annotations[]{a};
        Token t = this.jj_consume_token(28);
        ParsedNameClass nc = this.NameClass(context, pa);
        nc = this.afterComments(nc);
        this.jj_consume_token(29);
        if (pa[0] != null) {
            nc = this.sb.makeChoice(new ParsedNameClass[]{nc}, 1, this.makeLocation(t), pa[0]);
        }
        return nc;
    }

    public final ParsedNameClass ExceptNameClass(int context) throws ParseException {
        this.jj_consume_token(30);
        ParsedNameClass nc = this.BasicNameClass(context);
        return nc;
    }

    public final ParsedPattern ListExpr(Scope scope, Annotations a) throws ParseException {
        Token t = this.jj_consume_token(31);
        this.jj_consume_token(11);
        ParsedPattern p = this.Expr(false, scope, null, null);
        p = this.afterComments(p);
        this.jj_consume_token(12);
        return this.sb.makeList(p, this.makeLocation(t), a);
    }

    public final ParsedPattern MixedExpr(Scope scope, Annotations a) throws ParseException {
        Token t = this.jj_consume_token(32);
        this.jj_consume_token(11);
        ParsedPattern p = this.Expr(false, scope, null, null);
        p = this.afterComments(p);
        this.jj_consume_token(12);
        return this.sb.makeMixed(p, this.makeLocation(t), a);
    }

    public final ParsedPattern GrammarExpr(Scope scope, Annotations a) throws ParseException {
        Token t = this.jj_consume_token(10);
        Grammar g = this.sb.makeGrammar(scope);
        this.jj_consume_token(11);
        a = this.GrammarBody(g, g, a);
        this.topLevelComments(g);
        this.jj_consume_token(12);
        return g.endGrammar(this.makeLocation(t), a);
    }

    public final ParsedPattern ParenExpr(boolean topLevel, Scope scope, Annotations a) throws ParseException {
        Token t = this.jj_consume_token(28);
        ParsedPattern p = this.Expr(topLevel, scope, t, a);
        p = this.afterComments(p);
        this.jj_consume_token(29);
        return p;
    }

    public final Annotations GrammarBody(GrammarSection section, Scope scope, Annotations a) throws ParseException {
        while (this.jj_2_3(2)) {
            ParsedElementAnnotation e = this.AnnotationElementNotKeyword();
            if (a == null) {
                a = this.sb.makeAnnotations(null, this.getContext());
            }
            a.addElement(e);
        }
        block4: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 40: 
                case 43: 
                case 54: 
                case 55: {
                    break;
                }
                default: {
                    this.jj_la1[37] = this.jj_gen;
                    break block4;
                }
            }
            this.GrammarComponent(section, scope);
        }
        return a;
    }

    public final void GrammarComponent(GrammarSection section, Scope scope) throws ParseException {
        Annotations a = this.Annotations();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 54: 
            case 55: {
                this.Definition(section, scope, a);
                break;
            }
            case 7: {
                this.Include(section, scope, a);
                break;
            }
            case 6: {
                this.Div(section, scope, a);
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        while (this.jj_2_4(2)) {
            ParsedElementAnnotation e = this.AnnotationElementNotKeyword();
            section.topLevelAnnotation(e);
        }
    }

    public final void Definition(GrammarSection section, Scope scope, Annotations a) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 54: 
            case 55: {
                this.Define(section, scope, a);
                break;
            }
            case 5: {
                this.Start(section, scope, a);
                break;
            }
            default: {
                this.jj_la1[39] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void Start(GrammarSection section, Scope scope, Annotations a) throws ParseException {
        Token t = this.jj_consume_token(5);
        GrammarSection.Combine combine = this.AssignOp();
        ParsedPattern p = this.Expr(false, scope, null, null);
        section.define(GrammarSection.START, combine, p, this.makeLocation(t), a);
    }

    public final void Define(GrammarSection section, Scope scope, Annotations a) throws ParseException {
        LocatedString name = this.Identifier();
        GrammarSection.Combine combine = this.AssignOp();
        ParsedPattern p = this.Expr(false, scope, null, null);
        section.define(name.getString(), combine, p, name.getLocation(), a);
    }

    public final GrammarSection.Combine AssignOp() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 2: {
                this.jj_consume_token(2);
                return null;
            }
            case 4: {
                this.jj_consume_token(4);
                return GrammarSection.COMBINE_CHOICE;
            }
            case 3: {
                this.jj_consume_token(3);
                return GrammarSection.COMBINE_INTERLEAVE;
            }
        }
        this.jj_la1[40] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final void Include(GrammarSection section, Scope scope, Annotations a) throws ParseException {
        Include include = section.makeInclude();
        Token t = this.jj_consume_token(7);
        String href = this.Literal();
        String ns = this.Inherit();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                this.jj_consume_token(11);
                a = this.IncludeBody(include, scope, a);
                this.topLevelComments(include);
                this.jj_consume_token(12);
                break;
            }
            default: {
                this.jj_la1[41] = this.jj_gen;
            }
        }
        try {
            include.endInclude(this.resolve(href), ns, this.makeLocation(t), a);
        }
        catch (IllegalSchemaException e) {
            // empty catch block
        }
    }

    public final Annotations IncludeBody(GrammarSection section, Scope scope, Annotations a) throws ParseException {
        while (this.jj_2_5(2)) {
            ParsedElementAnnotation e = this.AnnotationElementNotKeyword();
            if (a == null) {
                a = this.sb.makeAnnotations(null, this.getContext());
            }
            a.addElement(e);
        }
        block4: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 5: 
                case 6: 
                case 40: 
                case 43: 
                case 54: 
                case 55: {
                    break;
                }
                default: {
                    this.jj_la1[42] = this.jj_gen;
                    break block4;
                }
            }
            this.IncludeComponent(section, scope);
        }
        return a;
    }

    public final void IncludeComponent(GrammarSection section, Scope scope) throws ParseException {
        Annotations a = this.Annotations();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 54: 
            case 55: {
                this.Definition(section, scope, a);
                break;
            }
            case 6: {
                this.IncludeDiv(section, scope, a);
                break;
            }
            default: {
                this.jj_la1[43] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        while (this.jj_2_6(2)) {
            ParsedElementAnnotation e = this.AnnotationElementNotKeyword();
            section.topLevelAnnotation(e);
        }
    }

    public final void Div(GrammarSection section, Scope scope, Annotations a) throws ParseException {
        Div div = section.makeDiv();
        Token t = this.jj_consume_token(6);
        this.jj_consume_token(11);
        a = this.GrammarBody(div, scope, a);
        this.topLevelComments(div);
        this.jj_consume_token(12);
        div.endDiv(this.makeLocation(t), a);
    }

    public final void IncludeDiv(GrammarSection section, Scope scope, Annotations a) throws ParseException {
        Div div = section.makeDiv();
        Token t = this.jj_consume_token(6);
        this.jj_consume_token(11);
        a = this.IncludeBody(div, scope, a);
        this.topLevelComments(div);
        this.jj_consume_token(12);
        div.endDiv(this.makeLocation(t), a);
    }

    public final ParsedPattern ExternalRefExpr(Scope scope, Annotations a) throws ParseException {
        Token t = this.jj_consume_token(33);
        String href = this.Literal();
        String ns = this.Inherit();
        try {
            return this.sb.makeExternalRef(this.resolve(href), ns, scope, this.makeLocation(t), a);
        }
        catch (IllegalSchemaException e) {
            return this.sb.makeErrorPattern();
        }
    }

    public final String Inherit() throws ParseException {
        String ns = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 15: {
                this.jj_consume_token(15);
                this.jj_consume_token(2);
                ns = this.Prefix();
                break;
            }
            default: {
                this.jj_la1[44] = this.jj_gen;
            }
        }
        if (ns == null) {
            ns = this.defaultNamespace;
        }
        return ns;
    }

    public final ParsedPattern ParentExpr(Scope scope, Annotations a) throws ParseException {
        this.jj_consume_token(34);
        a = this.addCommentsToChildAnnotations(a);
        LocatedString name = this.Identifier();
        return scope.makeParentRef(name.getString(), name.getLocation(), a);
    }

    public final ParsedPattern IdentifierExpr(Scope scope, Annotations a) throws ParseException {
        LocatedString name = this.Identifier();
        return scope.makeRef(name.getString(), name.getLocation(), a);
    }

    public final ParsedPattern ValueExpr(boolean topLevel, Annotations a) throws ParseException {
        LocatedString s = this.LocatedLiteral();
        if (topLevel && this.annotationsIncludeElements) {
            this.error("top_level_follow_annotation", s.getToken());
            a = null;
        }
        return this.sb.makeValue("", "token", s.getString(), this.getContext(), this.defaultNamespace, s.getLocation(), a);
    }

    public final ParsedPattern DataExpr(boolean topLevel, Scope scope, Annotations a, Token[] except) throws ParseException {
        String datatypeUri = null;
        String s = null;
        ParsedPattern e = null;
        Token datatypeToken = this.DatatypeName();
        String datatype = datatypeToken.image;
        Location loc = this.makeLocation(datatypeToken);
        int colon = datatype.indexOf(58);
        if (colon < 0) {
            datatypeUri = "";
        } else {
            String prefix = datatype.substring(0, colon);
            datatypeUri = this.lookupDatatype(prefix, datatypeToken);
            datatype = datatype.substring(colon + 1);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 58: {
                s = this.Literal();
                if (topLevel && this.annotationsIncludeElements) {
                    this.error("top_level_follow_annotation", datatypeToken);
                    a = null;
                }
                return this.sb.makeValue(datatypeUri, datatype, s, this.getContext(), this.defaultNamespace, loc, a);
            }
        }
        this.jj_la1[48] = this.jj_gen;
        DataPatternBuilder dpb = this.sb.makeDataPatternBuilder(datatypeUri, datatype, loc);
        block3 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: {
                this.Params(dpb);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 30: {
                        e = this.Except(scope, except);
                        break block3;
                    }
                }
                this.jj_la1[45] = this.jj_gen;
                break;
            }
            default: {
                this.jj_la1[47] = this.jj_gen;
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 30: {
                        e = this.Except(scope, except);
                        break block3;
                    }
                }
                this.jj_la1[46] = this.jj_gen;
            }
        }
        return e == null ? dpb.makePattern(loc, a) : dpb.makePattern(e, loc, a);
    }

    /*
     * WARNING - void declaration
     */
    public final Token DatatypeName() throws ParseException {
        void var1_1;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 35: {
                Token t = this.jj_consume_token(35);
                break;
            }
            case 36: {
                Token t = this.jj_consume_token(36);
                break;
            }
            case 57: {
                Token t = this.jj_consume_token(57);
                break;
            }
            default: {
                this.jj_la1[49] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public final LocatedString Identifier() throws ParseException {
        void var1_3;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 54: {
                Token t = this.jj_consume_token(54);
                LocatedString s = new LocatedString(t.image, t);
                break;
            }
            case 55: {
                Token t = this.jj_consume_token(55);
                LocatedString s = new LocatedString(t.image.substring(1), t);
                break;
            }
            default: {
                this.jj_la1[50] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return var1_3;
    }

    /*
     * WARNING - void declaration
     */
    public final String Prefix() throws ParseException {
        void var1_1;
        void var2_2;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 54: {
                Token t = this.jj_consume_token(54);
                String prefix = t.image;
                break;
            }
            case 55: {
                Token t = this.jj_consume_token(55);
                String prefix = t.image.substring(1);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                Token t = this.Keyword();
                String prefix = t.image;
                break;
            }
            default: {
                this.jj_la1[51] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.lookupPrefix((String)var2_2, (Token)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final LocatedString UnprefixedName() throws ParseException {
        void var1_1;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 54: 
            case 55: {
                LocatedString s = this.Identifier();
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: {
                Token t = this.Keyword();
                LocatedString s = new LocatedString(t.image, t);
                break;
            }
            default: {
                this.jj_la1[52] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return var1_1;
    }

    public final void Params(DataPatternBuilder dpb) throws ParseException {
        this.jj_consume_token(11);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 5: 
                case 6: 
                case 7: 
                case 10: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 26: 
                case 27: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 40: 
                case 43: 
                case 54: 
                case 55: {
                    break;
                }
                default: {
                    this.jj_la1[53] = this.jj_gen;
                    break block3;
                }
            }
            this.Param(dpb);
        }
        this.jj_consume_token(12);
    }

    public final void Param(DataPatternBuilder dpb) throws ParseException {
        Annotations a = this.Annotations();
        LocatedString name = this.UnprefixedName();
        this.jj_consume_token(2);
        a = this.addCommentsToLeadingAnnotations(a);
        String value = this.Literal();
        dpb.addParam(name.getString(), value, this.getContext(), this.defaultNamespace, name.getLocation(), a);
    }

    public final ParsedPattern Except(Scope scope, Token[] except) throws ParseException {
        Token[] innerExcept = new Token[1];
        Token t = this.jj_consume_token(30);
        Annotations a = this.Annotations();
        ParsedPattern p = this.PrimaryExpr(false, scope, a, innerExcept);
        this.checkExcept(innerExcept);
        except[0] = t;
        return p;
    }

    public final ParsedElementAnnotation Documentation() throws ParseException {
        Token t;
        CommentList comments = this.getComments();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 40: {
                t = this.jj_consume_token(40);
                break;
            }
            case 43: {
                t = this.jj_consume_token(43);
                break;
            }
            default: {
                this.jj_la1[54] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        ElementAnnotationBuilder eab = this.sb.makeElementAnnotationBuilder("http://relaxng.org/ns/compatibility/annotations/1.0", "documentation", this.getCompatibilityPrefix(), this.makeLocation(t), comments, this.getContext());
        eab.addText(CompactSyntax.mungeComment(t.image), this.makeLocation(t), null);
        block7: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 41: {
                    break;
                }
                default: {
                    this.jj_la1[55] = this.jj_gen;
                    break block7;
                }
            }
            t = this.jj_consume_token(41);
            eab.addText("\n" + CompactSyntax.mungeComment(t.image), this.makeLocation(t), null);
        }
        return eab.makeElementAnnotation();
    }

    public final Annotations Annotations() throws ParseException {
        ParsedElementAnnotation e;
        CommentList comments = this.getComments();
        Annotations a = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 40: 
            case 43: {
                a = this.sb.makeAnnotations(comments, this.getContext());
                block12: while (true) {
                    e = this.Documentation();
                    a.addElement(e);
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 40: 
                        case 43: {
                            continue block12;
                        }
                    }
                    break;
                }
                this.jj_la1[56] = this.jj_gen;
                comments = this.getComments();
                if (comments == null) break;
                a.addLeadingComment(comments);
                break;
            }
            default: {
                this.jj_la1[57] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: {
                this.jj_consume_token(1);
                if (a == null) {
                    a = this.sb.makeAnnotations(comments, this.getContext());
                }
                this.clearAttributeList();
                this.annotationsIncludeElements = false;
                while (this.jj_2_7(2)) {
                    this.PrefixedAnnotationAttribute(a, false);
                }
                block14: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 5: 
                        case 6: 
                        case 7: 
                        case 10: 
                        case 13: 
                        case 14: 
                        case 15: 
                        case 16: 
                        case 17: 
                        case 18: 
                        case 19: 
                        case 26: 
                        case 27: 
                        case 31: 
                        case 32: 
                        case 33: 
                        case 34: 
                        case 35: 
                        case 36: 
                        case 54: 
                        case 55: 
                        case 57: {
                            break;
                        }
                        default: {
                            this.jj_la1[58] = this.jj_gen;
                            break block14;
                        }
                    }
                    e = this.AnnotationElement(false);
                    a.addElement(e);
                    this.annotationsIncludeElements = true;
                }
                a.addComment(this.getComments());
                this.jj_consume_token(9);
                break;
            }
            default: {
                this.jj_la1[59] = this.jj_gen;
            }
        }
        if (a == null && comments != null) {
            a = this.sb.makeAnnotations(comments, this.getContext());
        }
        return a;
    }

    public final void AnnotationAttribute(Annotations a) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 57: {
                this.PrefixedAnnotationAttribute(a, true);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 54: 
            case 55: {
                this.UnprefixedAnnotationAttribute(a);
                break;
            }
            default: {
                this.jj_la1[60] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final void PrefixedAnnotationAttribute(Annotations a, boolean nested) throws ParseException {
        Token t = this.jj_consume_token(57);
        this.jj_consume_token(2);
        String value = this.Literal();
        String qn = t.image;
        int colon = qn.indexOf(58);
        String prefix = qn.substring(0, colon);
        String ns = this.lookupPrefix(prefix, t);
        if (ns == SchemaBuilder.INHERIT_NS) {
            this.error("inherited_annotation_namespace", t);
        } else if (ns.length() == 0 && !nested) {
            this.error("unqualified_annotation_attribute", t);
        } else if (ns.equals("http://relaxng.org/ns/structure/1.0") && !nested) {
            this.error("relax_ng_namespace", t);
        } else if (ns.equals("http://www.w3.org/2000/xmlns")) {
            this.error("xmlns_annotation_attribute_uri", t);
        } else {
            if (ns.length() == 0) {
                prefix = null;
            }
            this.addAttribute(a, ns, qn.substring(colon + 1), prefix, value, t);
        }
    }

    public final void UnprefixedAnnotationAttribute(Annotations a) throws ParseException {
        LocatedString name = this.UnprefixedName();
        this.jj_consume_token(2);
        String value = this.Literal();
        if (name.getString().equals("xmlns")) {
            this.error("xmlns_annotation_attribute", name.getToken());
        } else {
            this.addAttribute(a, "", name.getString(), null, value, name.getToken());
        }
    }

    /*
     * WARNING - void declaration
     */
    public final ParsedElementAnnotation AnnotationElement(boolean nested) throws ParseException {
        void var2_2;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 57: {
                ParsedElementAnnotation a = this.PrefixedAnnotationElement(nested);
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 26: 
            case 27: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 54: 
            case 55: {
                ParsedElementAnnotation a = this.UnprefixedAnnotationElement();
                break;
            }
            default: {
                this.jj_la1[61] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public final ParsedElementAnnotation AnnotationElementNotKeyword() throws ParseException {
        void var1_1;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 57: {
                ParsedElementAnnotation a = this.PrefixedAnnotationElement(false);
                break;
            }
            case 54: 
            case 55: {
                ParsedElementAnnotation a = this.IdentifierAnnotationElement();
                break;
            }
            default: {
                this.jj_la1[62] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return var1_1;
    }

    public final ParsedElementAnnotation PrefixedAnnotationElement(boolean nested) throws ParseException {
        CommentList comments = this.getComments();
        Token t = this.jj_consume_token(57);
        String qn = t.image;
        int colon = qn.indexOf(58);
        String prefix = qn.substring(0, colon);
        String ns = this.lookupPrefix(prefix, t);
        if (ns == SchemaBuilder.INHERIT_NS) {
            this.error("inherited_annotation_namespace", t);
            ns = "";
        } else if (!nested && ns.equals("http://relaxng.org/ns/structure/1.0")) {
            this.error("relax_ng_namespace", t);
            ns = "";
        } else if (ns.length() == 0) {
            prefix = null;
        }
        ElementAnnotationBuilder eab = this.sb.makeElementAnnotationBuilder(ns, qn.substring(colon + 1), prefix, this.makeLocation(t), comments, this.getContext());
        this.AnnotationElementContent(eab);
        return eab.makeElementAnnotation();
    }

    public final ParsedElementAnnotation UnprefixedAnnotationElement() throws ParseException {
        CommentList comments = this.getComments();
        LocatedString name = this.UnprefixedName();
        ElementAnnotationBuilder eab = this.sb.makeElementAnnotationBuilder("", name.getString(), null, name.getLocation(), comments, this.getContext());
        this.AnnotationElementContent(eab);
        return eab.makeElementAnnotation();
    }

    public final ParsedElementAnnotation IdentifierAnnotationElement() throws ParseException {
        CommentList comments = this.getComments();
        LocatedString name = this.Identifier();
        ElementAnnotationBuilder eab = this.sb.makeElementAnnotationBuilder("", name.getString(), null, name.getLocation(), comments, this.getContext());
        this.AnnotationElementContent(eab);
        return eab.makeElementAnnotation();
    }

    public final void AnnotationElementContent(ElementAnnotationBuilder eab) throws ParseException {
        block13: {
            this.jj_consume_token(1);
            this.clearAttributeList();
            while (this.jj_2_8(2)) {
                this.AnnotationAttribute(eab);
            }
            block11: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 5: 
                    case 6: 
                    case 7: 
                    case 10: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 26: 
                    case 27: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 54: 
                    case 55: 
                    case 57: 
                    case 58: {
                        break;
                    }
                    default: {
                        this.jj_la1[63] = this.jj_gen;
                        break block13;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 58: {
                        this.AnnotationElementLiteral(eab);
                        while (true) {
                            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                                case 8: {
                                    break;
                                }
                                default: {
                                    this.jj_la1[64] = this.jj_gen;
                                    continue block11;
                                }
                            }
                            this.jj_consume_token(8);
                            this.AnnotationElementLiteral(eab);
                        }
                    }
                    case 5: 
                    case 6: 
                    case 7: 
                    case 10: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: 
                    case 26: 
                    case 27: 
                    case 31: 
                    case 32: 
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 54: 
                    case 55: 
                    case 57: {
                        ParsedElementAnnotation e = this.AnnotationElement(true);
                        eab.addElement(e);
                        continue block11;
                    }
                }
                break;
            }
            this.jj_la1[65] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        eab.addComment(this.getComments());
        this.jj_consume_token(9);
    }

    public final void AnnotationElementLiteral(ElementAnnotationBuilder eab) throws ParseException {
        CommentList comments = this.getComments();
        Token t = this.jj_consume_token(58);
        eab.addText(CompactSyntax.unquote(t.image), this.makeLocation(t), comments);
    }

    public final String Literal() throws ParseException {
        Token t = this.jj_consume_token(58);
        String s = CompactSyntax.unquote(t.image);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                StringBuffer buf = new StringBuffer(s);
                block6: while (true) {
                    this.jj_consume_token(8);
                    t = this.jj_consume_token(58);
                    buf.append(CompactSyntax.unquote(t.image));
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: {
                            continue block6;
                        }
                    }
                    break;
                }
                this.jj_la1[66] = this.jj_gen;
                s = buf.toString();
                break;
            }
            default: {
                this.jj_la1[67] = this.jj_gen;
            }
        }
        return s;
    }

    public final LocatedString LocatedLiteral() throws ParseException {
        Token t = this.jj_consume_token(58);
        String s = CompactSyntax.unquote(t.image);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                StringBuffer buf = new StringBuffer(s);
                block6: while (true) {
                    this.jj_consume_token(8);
                    Token t2 = this.jj_consume_token(58);
                    buf.append(CompactSyntax.unquote(t2.image));
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: {
                            continue block6;
                        }
                    }
                    break;
                }
                this.jj_la1[68] = this.jj_gen;
                s = buf.toString();
                break;
            }
            default: {
                this.jj_la1[69] = this.jj_gen;
            }
        }
        return new LocatedString(s, t);
    }

    /*
     * WARNING - void declaration
     */
    public final Token Keyword() throws ParseException {
        void var1_1;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 26: {
                Token t = this.jj_consume_token(26);
                break;
            }
            case 27: {
                Token t = this.jj_consume_token(27);
                break;
            }
            case 13: {
                Token t = this.jj_consume_token(13);
                break;
            }
            case 31: {
                Token t = this.jj_consume_token(31);
                break;
            }
            case 32: {
                Token t = this.jj_consume_token(32);
                break;
            }
            case 10: {
                Token t = this.jj_consume_token(10);
                break;
            }
            case 17: {
                Token t = this.jj_consume_token(17);
                break;
            }
            case 18: {
                Token t = this.jj_consume_token(18);
                break;
            }
            case 34: {
                Token t = this.jj_consume_token(34);
                break;
            }
            case 33: {
                Token t = this.jj_consume_token(33);
                break;
            }
            case 19: {
                Token t = this.jj_consume_token(19);
                break;
            }
            case 5: {
                Token t = this.jj_consume_token(5);
                break;
            }
            case 7: {
                Token t = this.jj_consume_token(7);
                break;
            }
            case 14: {
                Token t = this.jj_consume_token(14);
                break;
            }
            case 15: {
                Token t = this.jj_consume_token(15);
                break;
            }
            case 35: {
                Token t = this.jj_consume_token(35);
                break;
            }
            case 36: {
                Token t = this.jj_consume_token(36);
                break;
            }
            case 16: {
                Token t = this.jj_consume_token(16);
                break;
            }
            case 6: {
                Token t = this.jj_consume_token(6);
                break;
            }
            default: {
                this.jj_la1[70] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return var1_1;
    }

    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_1();
        this.jj_save(0, xla);
        return retval;
    }

    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_2();
        this.jj_save(1, xla);
        return retval;
    }

    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_3();
        this.jj_save(2, xla);
        return retval;
    }

    private final boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_4();
        this.jj_save(3, xla);
        return retval;
    }

    private final boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_5();
        this.jj_save(4, xla);
        return retval;
    }

    private final boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_6();
        this.jj_save(5, xla);
        return retval;
    }

    private final boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_7();
        this.jj_save(6, xla);
        return retval;
    }

    private final boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        boolean retval = !this.jj_3_8();
        this.jj_save(7, xla);
        return retval;
    }

    private final boolean jj_3R_92() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_91() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_90() {
        if (this.jj_scan_token(19)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_89() {
        if (this.jj_scan_token(33)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_88() {
        if (this.jj_scan_token(34)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_87() {
        if (this.jj_scan_token(18)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_86() {
        if (this.jj_scan_token(17)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_85() {
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_84() {
        if (this.jj_scan_token(32)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_83() {
        if (this.jj_scan_token(31)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_82() {
        if (this.jj_scan_token(13)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_81() {
        if (this.jj_scan_token(27)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_80() {
        if (this.jj_scan_token(26)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_79() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_80()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_81()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_82()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_83()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_84()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_85()) {
                                this.jj_scanpos = xsp;
                                if (this.jj_3R_86()) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_3R_87()) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_3R_88()) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_3R_89()) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_3R_90()) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_3R_91()) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_3R_92()) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_3R_93()) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_3R_94()) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_3R_95()) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_3R_96()) {
                                                                            this.jj_scanpos = xsp;
                                                                            if (this.jj_3R_97()) {
                                                                                this.jj_scanpos = xsp;
                                                                                if (this.jj_3R_98()) {
                                                                                    return true;
                                                                                }
                                                                                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                    return false;
                                                                                }
                                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                                return false;
                                                                            }
                                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                            return false;
                                                                        }
                                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                        return false;
                                                                    }
                                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                    return false;
                                                                }
                                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                                return false;
                                                            }
                                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                            return false;
                                                        }
                                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                        return false;
                                                    }
                                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                    return false;
                                                }
                                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                                return false;
                                            }
                                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                            return false;
                                        }
                                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                        return false;
                                    }
                                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                    return false;
                                }
                            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_30() {
        if (this.jj_scan_token(57)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_39() {
        if (this.jj_3R_30()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_31() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_39()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_40()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_7() {
        if (this.jj_3R_30()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_70() {
        if (this.jj_3R_47()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_69() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_76() {
        if (this.jj_scan_token(41)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_8() {
        if (this.jj_3R_31()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_68() {
        if (this.jj_scan_token(58)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_63() {
        if (this.jj_scan_token(1)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_67() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_52() {
        if (this.jj_3R_41()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_63()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_6() {
        if (this.jj_3R_29()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_2() {
        if (this.jj_3R_28()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_66() {
        if (this.jj_3R_64()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_5() {
        if (this.jj_3R_29()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_75() {
        if (this.jj_scan_token(43)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_78() {
        if (this.jj_3R_79()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_73() {
        if (this.jj_scan_token(4)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_77() {
        if (this.jj_3R_41()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_45() {
        if (this.jj_scan_token(4)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_64() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_77()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_78()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_58() {
        if (this.jj_scan_token(7)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_50() {
        if (this.jj_3R_47()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_59() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_65()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_66()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_67()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_68()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_69()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_70()) {
                                return true;
                            }
                            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                                return false;
                            }
                        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_65() {
        if (this.jj_scan_token(57)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_72() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_47() {
        Token xsp;
        block5: {
            if (this.jj_scan_token(1)) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_59()) break block5;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        if (this.jj_scan_token(9)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_44() {
        if (this.jj_scan_token(3)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_57() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_74() {
        if (this.jj_scan_token(40)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_62() {
        Token xsp;
        block6: {
            xsp = this.jj_scanpos;
            if (this.jj_3R_74()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_75()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_76()) break block6;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_71() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_49() {
        Token xsp;
        block3: {
            if (this.jj_3R_62()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
            do {
                xsp = this.jj_scanpos;
                if (this.jj_3R_62()) break block3;
            } while (this.jj_la != 0 || this.jj_scanpos != this.jj_lastpos);
            return false;
        }
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_43() {
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_46() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_56()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_57()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_58()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_42() {
        if (this.jj_scan_token(1)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_56() {
        if (this.jj_scan_token(5)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_55() {
        if (this.jj_scan_token(55)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_54() {
        if (this.jj_scan_token(54)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_61() {
        if (this.jj_3R_46()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_41() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_54()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_55()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_51() {
        if (this.jj_scan_token(57)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_63()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_48() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_60()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_61()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_60() {
        if (this.jj_3R_41()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_71()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_72()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_73()) {
                    return true;
                }
                if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_36() {
        if (this.jj_3R_49()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_50()) {
            this.jj_scanpos = xsp;
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_48()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_35() {
        if (this.jj_3R_47()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_3R_48()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_34() {
        if (this.jj_3R_46()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_38() {
        if (this.jj_3R_52()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_1() {
        if (this.jj_3R_28()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_33() {
        if (this.jj_3R_41()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_42()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_43()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_44()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_45()) {
                        return true;
                    }
                    if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_37() {
        if (this.jj_3R_51()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_28() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_32()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_33()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_34()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_35()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_36()) {
                            return true;
                        }
                        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                            return false;
                        }
                    } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                        return false;
                    }
                } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                    return false;
                }
            } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_32() {
        if (this.jj_scan_token(57)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(1)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_29() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_37()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_38()) {
                return true;
            }
            if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
                return false;
            }
        } else if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_4() {
        if (this.jj_3R_29()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_53() {
        if (this.jj_3R_64()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        if (this.jj_scan_token(2)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_40() {
        if (this.jj_3R_53()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_98() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3_3() {
        if (this.jj_3R_29()) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_97() {
        if (this.jj_scan_token(16)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_96() {
        if (this.jj_scan_token(36)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_95() {
        if (this.jj_scan_token(35)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_94() {
        if (this.jj_scan_token(15)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    private final boolean jj_3R_93() {
        if (this.jj_scan_token(14)) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            return false;
        }
        return false;
    }

    public CompactSyntax(InputStream stream) {
        int i;
        this.jj_input_stream = new UCode_UCodeESC_CharStream(stream, 1, 1);
        this.token_source = new CompactSyntaxTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 71; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 71; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public CompactSyntax(Reader stream) {
        int i;
        this.jj_input_stream = new UCode_UCodeESC_CharStream(stream, 1, 1);
        this.token_source = new CompactSyntaxTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 71; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 71; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public CompactSyntax(CompactSyntaxTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 71; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(CompactSyntaxTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 71; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        return this.jj_scanpos.kind != kind;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration enumeration = this.jj_expentries.elements();
            while (enumeration.hasMoreElements()) {
                int[] oldentry = (int[])enumeration.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public final ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[61];
        for (i = 0; i < 61; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 71; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((this.jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((this.jj_la1_1[i] & 1 << j) == 0) continue;
                la1tokens[32 + j] = true;
            }
        }
        for (i = 0; i < 61; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, CompactSyntaxConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 8; ++i) {
            JJCalls p = this.jj_2_rtns[i];
            do {
                if (p.gen <= this.jj_gen) continue;
                this.jj_la = p.arg;
                this.jj_lastpos = this.jj_scanpos = p.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                        break;
                    }
                    case 2: {
                        this.jj_3_3();
                        break;
                    }
                    case 3: {
                        this.jj_3_4();
                        break;
                    }
                    case 4: {
                        this.jj_3_5();
                        break;
                    }
                    case 5: {
                        this.jj_3_6();
                        break;
                    }
                    case 6: {
                        this.jj_3_7();
                        break;
                    }
                    case 7: {
                        this.jj_3_8();
                    }
                }
            } while ((p = p.next) != null);
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    final class LocatedString {
        private final String str;
        private final Token tok;

        LocatedString(String str, Token tok) {
            this.str = str;
            this.tok = tok;
        }

        String getString() {
            return this.str;
        }

        Location getLocation() {
            return CompactSyntax.this.makeLocation(this.tok);
        }

        Token getToken() {
            return this.tok;
        }
    }
}

