/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.jarv;

import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.validate.AbstractSchema;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Option;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.validate.jarv.JarvConfigurationException;
import com.thaiopensource.validate.jarv.VerifierValidator;
import java.io.IOException;
import org.iso_relax.verifier.VerifierConfigurationException;
import org.iso_relax.verifier.VerifierFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class VerifierFactorySchemaReader
implements SchemaReader {
    private final VerifierFactory vf;

    public VerifierFactorySchemaReader(VerifierFactory vf) {
        this.vf = vf;
    }

    public Schema createSchema(InputSource in, PropertyMap properties) throws IOException, SAXException, IncorrectSchemaException {
        try {
            return new SchemaImpl(this.vf.compileSchema(in));
        }
        catch (SAXException e) {
            System.err.println("compileSchema threw a SAXException class " + e.getClass().toString());
            if (e.getException() != null) {
                System.err.println("cause has class " + e.getException().getClass().toString());
            }
            throw e;
        }
        catch (VerifierConfigurationException e) {
            String message;
            Exception cause;
            while (true) {
                cause = e.getCauseException();
                message = e.getMessage();
                if (cause != null && message != null && message.equals(cause.getMessage())) {
                    message = null;
                }
                if (message != null) break;
                if (cause instanceof RuntimeException) {
                    throw (RuntimeException)cause;
                }
                if (cause instanceof SAXException) {
                    throw (SAXException)cause;
                }
                if (cause instanceof IOException) {
                    throw (IOException)cause;
                }
                if (!(cause instanceof VerifierConfigurationException)) break;
                e = (VerifierConfigurationException)((Object)cause);
            }
            throw new SAXException(message, cause);
        }
    }

    public Option getOption(String uri) {
        return null;
    }

    private static class SchemaImpl
    extends AbstractSchema {
        final org.iso_relax.verifier.Schema schema;

        private SchemaImpl(org.iso_relax.verifier.Schema schema) {
            this.schema = schema;
        }

        public Validator createValidator(PropertyMap properties) {
            try {
                return new VerifierValidator(this.schema.newVerifier(), properties);
            }
            catch (VerifierConfigurationException e) {
                Exception cause = e.getCauseException();
                if (cause instanceof RuntimeException && (e.getMessage() == null || e.getMessage().equals(cause.getMessage()))) {
                    throw (RuntimeException)cause;
                }
                throw new JarvConfigurationException(e);
            }
        }
    }
}

