/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.mns;

import com.thaiopensource.util.Localizer;
import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.util.Uri;
import com.thaiopensource.validate.AbstractSchema;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.ValidateProperty;
import com.thaiopensource.validate.Validator;
import com.thaiopensource.validate.auto.SchemaFuture;
import com.thaiopensource.validate.mns.ContextMap;
import com.thaiopensource.validate.mns.ElementsOrAttributes;
import com.thaiopensource.validate.mns.Hashset;
import com.thaiopensource.validate.mns.SchemaReceiverImpl;
import com.thaiopensource.validate.mns.ValidatorImpl;
import com.thaiopensource.xml.sax.CountingErrorHandler;
import com.thaiopensource.xml.sax.DelegatingContentHandler;
import com.thaiopensource.xml.sax.XmlBaseHandler;
import com.thaiopensource.xml.util.Name;
import com.thaiopensource.xml.util.StringSplitter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.LocatorImpl;

class SchemaImpl
extends AbstractSchema {
    static final String MNS_URI = "http://www.thaiopensource.com/ns/mns";
    private final Hashtable modeMap = new Hashtable();
    private Mode startMode;
    private static final String DEFAULT_MODE_NAME = "#default";
    private final boolean attributesSchema;
    static /* synthetic */ Class class$com$thaiopensource$validate$mns$SchemaImpl;

    SchemaImpl(boolean attributesSchema) {
        this.attributesSchema = attributesSchema;
    }

    SchemaFuture installHandlers(XMLReader in, SchemaReceiverImpl sr) {
        Handler h = new Handler(sr);
        in.setContentHandler(h);
        return h;
    }

    public Validator createValidator(PropertyMap properties) {
        return new ValidatorImpl(this.startMode, properties);
    }

    private Mode lookupCreateMode(String name) {
        Mode mode = (Mode)this.modeMap.get(name);
        if (mode == null) {
            mode = new Mode(this.attributesSchema ? ElementsOrAttributes.ELEMENTS : ElementsOrAttributes.NEITHER);
            this.modeMap.put(name, mode);
        }
        return mode;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Handler
    extends DelegatingContentHandler
    implements SchemaFuture {
        private final SchemaReceiverImpl sr;
        private ElementAction currentElementAction;
        private boolean hadError = false;
        private final ErrorHandler eh;
        private final CountingErrorHandler ceh;
        private final Localizer localizer = new Localizer(class$com$thaiopensource$validate$mns$SchemaImpl == null ? (class$com$thaiopensource$validate$mns$SchemaImpl = SchemaImpl.class$("com.thaiopensource.validate.mns.SchemaImpl")) : class$com$thaiopensource$validate$mns$SchemaImpl);
        private Locator locator;
        private final XmlBaseHandler xmlBaseHandler = new XmlBaseHandler();
        private int foreignDepth = 0;
        private String contextNs;
        private Mode contextMode;
        private String elementNs;
        private String defaultSchemaType;
        private final Stack nameStack = new Stack();
        private boolean isRoot;
        private int pathDepth = 0;
        private Validator validator;

        Handler(SchemaReceiverImpl sr) {
            this.sr = sr;
            this.eh = ValidateProperty.ERROR_HANDLER.get(sr.getProperties());
            this.ceh = new CountingErrorHandler(this.eh);
        }

        public void setDocumentLocator(Locator locator) {
            this.xmlBaseHandler.setLocator(locator);
            this.locator = locator;
        }

        public void startDocument() throws SAXException {
            try {
                PropertyMapBuilder builder = new PropertyMapBuilder(this.sr.getProperties());
                ValidateProperty.ERROR_HANDLER.put(builder, this.ceh);
                this.validator = this.sr.getMnsSchema().createValidator(builder.toPropertyMap());
            }
            catch (IOException e) {
                throw new WrappedIOException(e);
            }
            catch (IncorrectSchemaException e) {
                throw new RuntimeException("internal error in RNG schema for MNS");
            }
            this.setDelegate(this.validator.getContentHandler());
            if (this.locator != null) {
                super.setDocumentLocator(this.locator);
            }
            super.startDocument();
        }

        public Schema getSchema() throws IncorrectSchemaException, SAXException {
            if (this.validator == null || this.ceh.getHadErrorOrFatalError()) {
                throw new IncorrectSchemaException();
            }
            Enumeration enumeration = SchemaImpl.this.modeMap.keys();
            while (enumeration.hasMoreElements()) {
                String modeName = (String)enumeration.nextElement();
                Mode mode = (Mode)SchemaImpl.this.modeMap.get(modeName);
                if (mode.defined || modeName.equals(SchemaImpl.DEFAULT_MODE_NAME)) continue;
                this.error("undefined_mode", modeName, mode.whereDefined);
            }
            if (this.hadError) {
                throw new IncorrectSchemaException();
            }
            return SchemaImpl.this;
        }

        public RuntimeException unwrapException(RuntimeException e) throws SAXException, IOException, IncorrectSchemaException {
            if (e instanceof WrappedIOException) {
                throw ((WrappedIOException)e).getException();
            }
            return e;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            this.xmlBaseHandler.startElement();
            String xmlBase = attributes.getValue("http://www.w3.org/XML/1998/namespace", "base");
            if (xmlBase != null) {
                this.xmlBaseHandler.xmlBaseAttribute(xmlBase);
            }
            if (!SchemaImpl.MNS_URI.equals(uri) || this.foreignDepth > 0) {
                ++this.foreignDepth;
                return;
            }
            if (this.ceh.getHadErrorOrFatalError()) {
                return;
            }
            if (localName.equals("rules")) {
                this.parseRules(attributes);
            } else if (localName.equals("cover")) {
                this.parseCover(attributes);
            } else if (localName.equals("context")) {
                this.parseContext(attributes);
            } else if (localName.equals("root")) {
                this.parseRoot(attributes);
            } else if (localName.equals("element")) {
                this.parseElement(attributes);
            } else if (localName.equals("lax")) {
                this.parseLax(attributes);
            } else {
                this.parseValidate(localName.equals("validateAttributes"), attributes);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            super.endElement(namespaceURI, localName, qName);
            this.xmlBaseHandler.endElement();
            if (this.foreignDepth > 0) {
                --this.foreignDepth;
                return;
            }
            if (this.pathDepth > 0) {
                --this.pathDepth;
                if (this.pathDepth == 0) {
                    this.endPath();
                }
            }
        }

        private void parseRules(Attributes attributes) {
            String modeName = attributes.getValue("", "startMode");
            if (modeName == null) {
                modeName = SchemaImpl.DEFAULT_MODE_NAME;
            }
            this.defaultSchemaType = this.getSchemaType(attributes);
            SchemaImpl.this.startMode = SchemaImpl.this.lookupCreateMode(modeName);
        }

        private void parseCover(Attributes attributes) throws SAXException {
            String ns = this.getNs(attributes, false);
            this.currentElementAction.covered.add(ns);
        }

        private void parseLax(Attributes attributes) throws SAXException {
            String[] modeNames = this.getInModes(attributes);
            Mode[] modes = this.getModes(modeNames);
            ElementsOrAttributes lax = this.toElementsOrAttributes(attributes.getValue("", "allow"), ElementsOrAttributes.BOTH);
            for (int i = 0; i < modes.length; ++i) {
                if (modes[i].strictDefined) {
                    this.error("lax_multiply_defined", modeNames[i]);
                    continue;
                }
                modes[i].lax = lax;
                modes[i].strictDefined = true;
            }
        }

        private void parseValidate(boolean isAttribute, Attributes attributes) throws SAXException {
            String[] modeNames = this.getInModes(attributes);
            Mode[] modes = this.getModes(modeNames);
            String ns = this.getNs(attributes, isAttribute);
            String schemaUri = this.getSchema(attributes);
            String schemaType = this.getSchemaType(attributes);
            if (schemaType == null) {
                schemaType = this.defaultSchemaType;
            }
            try {
                if (isAttribute) {
                    Schema schema = this.sr.createChildSchema(new InputSource(schemaUri), schemaType, true);
                    for (int i = 0; i < modes.length; ++i) {
                        if (modes[i].attributesMap.get(ns) != null) {
                            this.error("validate_attributes_multiply_defined", modeNames[i], ns);
                            continue;
                        }
                        modes[i].attributesMap.put(ns, schema);
                    }
                } else {
                    Schema schema = this.sr.createChildSchema(new InputSource(schemaUri), schemaType, false);
                    this.currentElementAction = new ElementAction(ns, schema, this.getUseMode(attributes), new ContextMap(), this.getPrune(attributes));
                    this.contextNs = ns;
                    for (int i = 0; i < modes.length; ++i) {
                        if (modes[i].elementMap.get(ns) != null) {
                            this.error("validate_element_multiply_defined", modeNames[i], ns);
                            continue;
                        }
                        modes[i].elementMap.put(ns, this.currentElementAction);
                    }
                }
            }
            catch (IncorrectSchemaException e) {
                this.hadError = true;
            }
            catch (IOException e) {
                throw new WrappedIOException(e);
            }
        }

        private void parseContext(Attributes attributes) throws SAXException {
            String ns = this.getNs(attributes, false);
            if (ns != null) {
                this.contextNs = ns;
            }
            this.elementNs = this.contextNs;
            this.contextMode = this.getUseMode(attributes);
        }

        private void parseRoot(Attributes attributes) throws SAXException {
            String ns = this.getNs(attributes, false);
            if (ns != null) {
                this.elementNs = ns;
            }
            this.isRoot = true;
            ++this.pathDepth;
        }

        private void parseElement(Attributes attributes) throws SAXException {
            String ns = this.getNs(attributes, false);
            if (ns != null) {
                this.elementNs = ns;
            }
            if (!this.currentElementAction.covered.contains(this.elementNs)) {
                this.error("context_ns_not_covered", this.elementNs);
            }
            this.nameStack.push(new Name(this.elementNs, attributes.getValue("", "name").trim()));
            ++this.pathDepth;
        }

        private void endPath() throws SAXException {
            if (!this.currentElementAction.contextMap.put(this.isRoot, this.nameStack, this.contextMode)) {
                this.error("path_multiply_defined", this.displayPath(this.isRoot, this.nameStack));
            }
            this.elementNs = this.contextNs;
            this.isRoot = false;
            this.nameStack.setSize(0);
        }

        private String displayPath(boolean isRoot, Stack nameStack) {
            StringBuffer buf = new StringBuffer();
            int len = nameStack.size();
            for (int i = 0; i < len; ++i) {
                Name name;
                if (i > 0 || isRoot) {
                    buf.append('/');
                }
                if ((name = (Name)nameStack.elementAt(i)).getNamespaceUri().length() > 0) {
                    buf.append('{');
                    buf.append(name.getNamespaceUri());
                    buf.append('}');
                }
                buf.append(name.getLocalName());
            }
            return buf.toString();
        }

        private String getSchema(Attributes attributes) throws SAXException {
            String schemaUri = attributes.getValue("", "schema");
            if (Uri.hasFragmentId(schemaUri)) {
                this.error("schema_fragment_id");
            }
            return Uri.resolve(this.xmlBaseHandler.getBaseUri(), Uri.escapeDisallowedChars(schemaUri));
        }

        private String getSchemaType(Attributes attributes) {
            return attributes.getValue("", "schemaType");
        }

        private ElementsOrAttributes getPrune(Attributes attributes) {
            return this.toElementsOrAttributes(attributes.getValue("", "prune"), ElementsOrAttributes.NEITHER);
        }

        private ElementsOrAttributes toElementsOrAttributes(String value, ElementsOrAttributes defaultValue) {
            if (value == null) {
                return defaultValue;
            }
            ElementsOrAttributes eoa = ElementsOrAttributes.NEITHER;
            if (value.indexOf("elements") >= 0) {
                eoa = eoa.addElements();
            }
            if (value.indexOf("attributes") >= 0) {
                eoa = eoa.addAttributes();
            }
            return eoa;
        }

        private Mode getUseMode(Attributes attributes) {
            Mode mode;
            String modeName = attributes.getValue("", "useMode");
            if (modeName == null) {
                modeName = SchemaImpl.DEFAULT_MODE_NAME;
            }
            if ((mode = SchemaImpl.this.lookupCreateMode(modeName)).whereDefined == null && this.locator != null) {
                mode.whereDefined = new LocatorImpl(this.locator);
            }
            return mode;
        }

        private String getNs(Attributes attributes, boolean forbidEmpty) throws SAXException {
            String ns = attributes.getValue("", "ns");
            if (!(ns == null || Uri.isAbsolute(ns) || !forbidEmpty && ns.equals(""))) {
                this.error("ns_absolute");
            }
            return ns;
        }

        private Mode[] getModes(String[] modeNames) {
            Mode[] modes = new Mode[modeNames.length];
            for (int i = 0; i < modes.length; ++i) {
                modes[i] = SchemaImpl.this.lookupCreateMode(modeNames[i]);
                modes[i].defined = true;
            }
            return modes;
        }

        private String[] getInModes(Attributes attributes) {
            String inModes = attributes.getValue("", "inModes");
            if (inModes == null) {
                return new String[]{SchemaImpl.DEFAULT_MODE_NAME};
            }
            return StringSplitter.split(inModes);
        }

        void error(String key) throws SAXException {
            this.hadError = true;
            if (this.eh == null) {
                return;
            }
            this.eh.error(new SAXParseException(this.localizer.message(key), this.locator));
        }

        void error(String key, String arg) throws SAXException {
            this.hadError = true;
            if (this.eh == null) {
                return;
            }
            this.eh.error(new SAXParseException(this.localizer.message(key, arg), this.locator));
        }

        void error(String key, String arg, Locator locator) throws SAXException {
            this.hadError = true;
            if (this.eh == null) {
                return;
            }
            this.eh.error(new SAXParseException(this.localizer.message(key, arg), locator));
        }

        void error(String key, String arg1, String arg2) throws SAXException {
            this.hadError = true;
            if (this.eh == null) {
                return;
            }
            this.eh.error(new SAXParseException(this.localizer.message(key, arg1, arg2), this.locator));
        }
    }

    static class Mode {
        private Locator whereDefined;
        private boolean defined = false;
        private ElementsOrAttributes lax;
        private boolean strictDefined = false;
        private final Hashtable elementMap = new Hashtable();
        private final Hashtable attributesMap = new Hashtable();

        Mode(ElementsOrAttributes lax) {
            this.lax = lax;
        }

        ElementsOrAttributes getLax() {
            return this.lax;
        }

        Schema getAttributesSchema(String ns) {
            return (Schema)this.attributesMap.get(ns);
        }

        ElementAction getElementAction(String ns) {
            return (ElementAction)this.elementMap.get(ns);
        }
    }

    static class ElementAction {
        private final Schema schema;
        private final Mode mode;
        private final ContextMap contextMap;
        private final ElementsOrAttributes prune;
        private final Hashset covered = new Hashset();

        ElementAction(String ns, Schema schema, Mode mode, ContextMap contextMap, ElementsOrAttributes prune) {
            this.schema = schema;
            this.mode = mode;
            this.contextMap = contextMap;
            this.prune = prune;
            this.covered.add(ns);
        }

        Mode getMode() {
            return this.mode;
        }

        ContextMap getContextMap() {
            return this.contextMap;
        }

        Schema getSchema() {
            return this.schema;
        }

        ElementsOrAttributes getPrune() {
            return this.prune;
        }

        Hashset getCoveredNamespaces() {
            return this.covered;
        }
    }

    private static final class WrappedIOException
    extends RuntimeException {
        private final IOException exception;

        private WrappedIOException(IOException exception) {
            this.exception = exception;
        }

        private IOException getException() {
            return this.exception;
        }
    }
}

