/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.mns;

import com.thaiopensource.util.PropertyMap;
import com.thaiopensource.util.PropertyMapBuilder;
import com.thaiopensource.validate.IncorrectSchemaException;
import com.thaiopensource.validate.Schema;
import com.thaiopensource.validate.SchemaReader;
import com.thaiopensource.validate.auto.AutoSchemaReader;
import com.thaiopensource.validate.auto.SchemaFuture;
import com.thaiopensource.validate.auto.SchemaReceiver;
import com.thaiopensource.validate.auto.SchemaReceiverFactory;
import com.thaiopensource.validate.mns.SchemaImpl;
import com.thaiopensource.validate.nrl.NrlProperty;
import com.thaiopensource.validate.rng.CompactSchemaReader;
import com.thaiopensource.validate.rng.SAXSchemaReader;
import java.io.IOException;
import java.net.URL;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

class SchemaReceiverImpl
implements SchemaReceiver {
    private static final String MNS_SCHEMA = "mns.rng";
    private static final String RNC_MEDIA_TYPE = "application/x-rnc";
    private final PropertyMap properties;
    private final PropertyMap attributeSchemaProperties;
    private final boolean attributesSchema;
    private final SchemaReader autoSchemaLanguage;
    private Schema mnsSchema = null;
    static /* synthetic */ Class class$com$thaiopensource$validate$mns$SchemaReceiverImpl;

    public SchemaReceiverImpl(PropertyMap properties) {
        this.attributesSchema = properties.contains(NrlProperty.ATTRIBUTES_SCHEMA);
        PropertyMapBuilder builder = new PropertyMapBuilder(properties);
        if (this.attributesSchema) {
            this.attributeSchemaProperties = properties;
            builder.put(NrlProperty.ATTRIBUTES_SCHEMA, null);
            this.properties = builder.toPropertyMap();
        } else {
            this.properties = properties;
            NrlProperty.ATTRIBUTES_SCHEMA.add(builder);
            this.attributeSchemaProperties = builder.toPropertyMap();
        }
        this.autoSchemaLanguage = new AutoSchemaReader(SchemaReceiverFactory.PROPERTY.get(properties));
    }

    public SchemaFuture installHandlers(XMLReader xr) {
        return new SchemaImpl(this.attributesSchema).installHandlers(xr, this);
    }

    Schema getMnsSchema() throws IOException, IncorrectSchemaException, SAXException {
        if (this.mnsSchema == null) {
            String className = (class$com$thaiopensource$validate$mns$SchemaReceiverImpl == null ? (class$com$thaiopensource$validate$mns$SchemaReceiverImpl = SchemaReceiverImpl.class$("com.thaiopensource.validate.mns.SchemaReceiverImpl")) : class$com$thaiopensource$validate$mns$SchemaReceiverImpl).getName();
            String resourceName = className.substring(0, className.lastIndexOf(46)).replace('.', '/') + "/resources/" + MNS_SCHEMA;
            URL mnsSchemaUrl = SchemaReceiverImpl.getResource(resourceName);
            this.mnsSchema = SAXSchemaReader.getInstance().createSchema(new InputSource(mnsSchemaUrl.toString()), this.properties);
        }
        return this.mnsSchema;
    }

    private static URL getResource(String resourceName) {
        ClassLoader cl = (class$com$thaiopensource$validate$mns$SchemaReceiverImpl == null ? (class$com$thaiopensource$validate$mns$SchemaReceiverImpl = SchemaReceiverImpl.class$("com.thaiopensource.validate.mns.SchemaReceiverImpl")) : class$com$thaiopensource$validate$mns$SchemaReceiverImpl).getClassLoader();
        if (cl == null) {
            return ClassLoader.getSystemResource(resourceName);
        }
        return cl.getResource(resourceName);
    }

    PropertyMap getProperties() {
        return this.properties;
    }

    Schema createChildSchema(InputSource inputSource, String schemaType, boolean isAttributesSchema) throws IOException, IncorrectSchemaException, SAXException {
        SchemaReader lang = SchemaReceiverImpl.isRnc(schemaType) ? CompactSchemaReader.getInstance() : this.autoSchemaLanguage;
        return lang.createSchema(inputSource, isAttributesSchema ? this.attributeSchemaProperties : this.properties);
    }

    private static boolean isRnc(String schemaType) {
        if (schemaType == null) {
            return false;
        }
        schemaType = schemaType.trim();
        return schemaType.equals(RNC_MEDIA_TYPE);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

