/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.validate.nrl;

import com.thaiopensource.validate.nrl.ActionSet;
import com.thaiopensource.validate.nrl.AttributeActionSet;
import java.util.Enumeration;
import java.util.Hashtable;
import org.xml.sax.Locator;
import org.xml.sax.helpers.LocatorImpl;

class Mode {
    static final String ANY_NAMESPACE = "##any";
    static final int ATTRIBUTE_PROCESSING_NONE = 0;
    static final int ATTRIBUTE_PROCESSING_QUALIFIED = 1;
    static final int ATTRIBUTE_PROCESSING_FULL = 2;
    static final Mode CURRENT = new Mode("#current", null);
    private final String name;
    private Mode baseMode;
    private boolean defined;
    private Locator whereDefined;
    private Locator whereUsed;
    private final Hashtable elementMap = new Hashtable();
    private final Hashtable attributeMap = new Hashtable();
    private int attributeProcessing = -1;

    Mode(String name, Mode baseMode) {
        this.name = name;
        this.baseMode = baseMode;
    }

    String getName() {
        return this.name;
    }

    Mode getBaseMode() {
        return this.baseMode;
    }

    void setBaseMode(Mode baseMode) {
        this.baseMode = baseMode;
    }

    ActionSet getElementActions(String ns) {
        ActionSet actions = this.getElementActionsExplicit(ns);
        if (actions == null) {
            actions = this.getElementActionsExplicit(ANY_NAMESPACE);
        }
        return actions;
    }

    private ActionSet getElementActionsExplicit(String ns) {
        ActionSet actions = (ActionSet)this.elementMap.get(ns);
        if (actions == null && this.baseMode != null && (actions = this.baseMode.getElementActionsExplicit(ns)) != null) {
            actions = actions.changeCurrentMode(this);
            this.elementMap.put(ns, actions);
        }
        return actions;
    }

    AttributeActionSet getAttributeActions(String ns) {
        AttributeActionSet actions = this.getAttributeActionsExplicit(ns);
        if (actions == null) {
            actions = this.getAttributeActionsExplicit(ANY_NAMESPACE);
        }
        return actions;
    }

    private AttributeActionSet getAttributeActionsExplicit(String ns) {
        AttributeActionSet actions = (AttributeActionSet)this.attributeMap.get(ns);
        if (actions == null && this.baseMode != null && (actions = this.baseMode.getAttributeActionsExplicit(ns)) != null) {
            this.attributeMap.put(ns, actions);
        }
        return actions;
    }

    int getAttributeProcessing() {
        if (this.attributeProcessing == -1) {
            this.attributeProcessing = this.baseMode != null ? this.baseMode.getAttributeProcessing() : 0;
            Enumeration enumeration = this.attributeMap.keys();
            while (enumeration.hasMoreElements() && this.attributeProcessing != 2) {
                String ns = (String)enumeration.nextElement();
                AttributeActionSet actions = (AttributeActionSet)this.attributeMap.get(ns);
                if (actions.getAttach() && !actions.getReject() && actions.getSchemas().length <= 0) continue;
                this.attributeProcessing = ns.equals("") || ns.equals(ANY_NAMESPACE) ? 2 : 1;
            }
        }
        return this.attributeProcessing;
    }

    Locator getWhereDefined() {
        return this.whereDefined;
    }

    boolean isDefined() {
        return this.defined;
    }

    Locator getWhereUsed() {
        return this.whereUsed;
    }

    void noteUsed(Locator locator) {
        if (this.whereUsed == null && locator != null) {
            this.whereUsed = new LocatorImpl(locator);
        }
    }

    void noteDefined(Locator locator) {
        this.defined = true;
        if (this.whereDefined == null && locator != null) {
            this.whereDefined = new LocatorImpl(locator);
        }
    }

    boolean bindElement(String ns, ActionSet actions) {
        if (this.elementMap.get(ns) != null) {
            return false;
        }
        this.elementMap.put(ns, actions);
        return true;
    }

    boolean bindAttribute(String ns, AttributeActionSet actions) {
        if (this.attributeMap.get(ns) != null) {
            return false;
        }
        this.attributeMap.put(ns, actions);
        return true;
    }
}

